package io.intino.datahub.model;

import io.intino.magritte.framework.Graph;

public class AbstractGraph extends io.intino.magritte.framework.GraphWrapper {
	protected io.intino.magritte.framework.Graph graph;
	private io.intino.datahub.model.Broker broker;
	private io.intino.datahub.model.Datalake datalake;
	private java.util.List<io.intino.datahub.model.Datamart> datamartList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.Terminal> terminalList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.Namespace> namespaceList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.Sensor> sensorList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.Resource> resourceList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.Message> messageList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.Component> componentList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.Entity> entityList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.Struct> structList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.Expression> expressionList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.EntityData> entityDataList = new java.util.ArrayList<>();

	private java.util.Map<String, Indexer> _index = _fillIndex();

	public AbstractGraph(io.intino.magritte.framework.Graph graph) {
		this.graph = graph;
		this.graph.i18n().register("Ness");
	}

	public AbstractGraph(io.intino.magritte.framework.Graph graph, AbstractGraph wrapper) {
		this.graph = graph;
		this.graph.i18n().register("Ness");
		this.broker = wrapper.broker;
		this.datalake = wrapper.datalake;
		this.datamartList = new java.util.ArrayList<>(wrapper.datamartList);
		this.terminalList = new java.util.ArrayList<>(wrapper.terminalList);
		this.namespaceList = new java.util.ArrayList<>(wrapper.namespaceList);
		this.sensorList = new java.util.ArrayList<>(wrapper.sensorList);
		this.resourceList = new java.util.ArrayList<>(wrapper.resourceList);
		this.messageList = new java.util.ArrayList<>(wrapper.messageList);
		this.componentList = new java.util.ArrayList<>(wrapper.componentList);
		this.entityList = new java.util.ArrayList<>(wrapper.entityList);
		this.structList = new java.util.ArrayList<>(wrapper.structList);
		this.expressionList = new java.util.ArrayList<>(wrapper.expressionList);
		this.entityDataList = new java.util.ArrayList<>(wrapper.entityDataList);
	}

	public <T extends io.intino.magritte.framework.GraphWrapper> T a$(Class<T> t) {
		return this.core$().as(t);
	}

    @Override
	public void update() {
		this._index.values().forEach(v -> v.clear());
		graph.rootList().forEach(r -> addNode$(r));
	}

	@Override
	protected void addNode$(io.intino.magritte.framework.Node node) {
		for (io.intino.magritte.framework.Concept c : node.conceptList()) if (this._index.containsKey(c.id())) this._index.get(c.id()).add(node);
		if (this._index.containsKey(node.id())) this._index.get(node.id()).add(node);
	}

	@Override
	protected void removeNode$(io.intino.magritte.framework.Node node) {
		for (io.intino.magritte.framework.Concept c : node.conceptList()) if (this._index.containsKey(c.id())) this._index.get(c.id()).remove(node);
		if (this._index.containsKey(node.id())) this._index.get(node.id()).remove(node);
	}

	public java.net.URL resourceAsMessage$(String language, String key) {
		return graph.loadResource(graph.i18n().message(language, key));
	}

	public io.intino.datahub.model.Broker broker() {
		return broker;
	}

	public io.intino.datahub.model.Datalake datalake() {
		return datalake;
	}

	public java.util.List<io.intino.datahub.model.Datamart> datamartList() {
		return datamartList;
	}

	public java.util.List<io.intino.datahub.model.Terminal> terminalList() {
		return terminalList;
	}

	public java.util.List<io.intino.datahub.model.Namespace> namespaceList() {
		return namespaceList;
	}

	public java.util.List<io.intino.datahub.model.Sensor> sensorList() {
		return sensorList;
	}

	public java.util.List<io.intino.datahub.model.Resource> resourceList() {
		return resourceList;
	}

	public java.util.List<io.intino.datahub.model.Message> messageList() {
		return messageList;
	}

	public java.util.List<io.intino.datahub.model.Component> componentList() {
		return componentList;
	}

	public java.util.List<io.intino.datahub.model.Entity> entityList() {
		return entityList;
	}

	public java.util.List<io.intino.datahub.model.Struct> structList() {
		return structList;
	}

	public java.util.List<io.intino.datahub.model.Expression> expressionList() {
		return expressionList;
	}

	public java.util.List<io.intino.datahub.model.EntityData> entityDataList() {
		return entityDataList;
	}

	public java.util.stream.Stream<io.intino.datahub.model.Datamart> datamartList(java.util.function.Predicate<io.intino.datahub.model.Datamart> filter) {
		return datamartList.stream().filter(filter);
	}

	public io.intino.datahub.model.Datamart datamart(int index) {
		return datamartList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.Terminal> terminalList(java.util.function.Predicate<io.intino.datahub.model.Terminal> filter) {
		return terminalList.stream().filter(filter);
	}

	public io.intino.datahub.model.Terminal terminal(int index) {
		return terminalList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.Namespace> namespaceList(java.util.function.Predicate<io.intino.datahub.model.Namespace> filter) {
		return namespaceList.stream().filter(filter);
	}

	public io.intino.datahub.model.Namespace namespace(int index) {
		return namespaceList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.Sensor> sensorList(java.util.function.Predicate<io.intino.datahub.model.Sensor> filter) {
		return sensorList.stream().filter(filter);
	}

	public io.intino.datahub.model.Sensor sensor(int index) {
		return sensorList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.Resource> resourceList(java.util.function.Predicate<io.intino.datahub.model.Resource> filter) {
		return resourceList.stream().filter(filter);
	}

	public io.intino.datahub.model.Resource resource(int index) {
		return resourceList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.Message> messageList(java.util.function.Predicate<io.intino.datahub.model.Message> filter) {
		return messageList.stream().filter(filter);
	}

	public io.intino.datahub.model.Message message(int index) {
		return messageList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.Component> componentList(java.util.function.Predicate<io.intino.datahub.model.Component> filter) {
		return componentList.stream().filter(filter);
	}

	public io.intino.datahub.model.Component component(int index) {
		return componentList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.Entity> entityList(java.util.function.Predicate<io.intino.datahub.model.Entity> filter) {
		return entityList.stream().filter(filter);
	}

	public io.intino.datahub.model.Entity entity(int index) {
		return entityList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.Struct> structList(java.util.function.Predicate<io.intino.datahub.model.Struct> filter) {
		return structList.stream().filter(filter);
	}

	public io.intino.datahub.model.Struct struct(int index) {
		return structList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.Expression> expressionList(java.util.function.Predicate<io.intino.datahub.model.Expression> filter) {
		return expressionList.stream().filter(filter);
	}

	public io.intino.datahub.model.Expression expression(int index) {
		return expressionList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.EntityData> entityDataList(java.util.function.Predicate<io.intino.datahub.model.EntityData> filter) {
		return entityDataList.stream().filter(filter);
	}

	public io.intino.datahub.model.EntityData entityData(int index) {
		return entityDataList.get(index);
	}

	public io.intino.magritte.framework.Graph core$() {
		return graph;
	}

	public io.intino.magritte.framework.utils.I18n i18n$() {
		return graph.i18n();
	}

	public Create create() {
		return new Create("Misc", null);
	}

	public Create create(String stash) {
		return new Create(stash, null);
	}

	public Create create(String stash, String name) {
		return new Create(stash, name);
	}

	public Clear clear() {
		return new Clear();
	}

	public class Create {
		private final String stash;
		private final String name;

		public Create(String stash, String name) {
			this.stash = stash;
			this.name = name;
		}

		public io.intino.datahub.model.Broker broker() {
			io.intino.datahub.model.Broker newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Broker.class, stash, this.name).a$(io.intino.datahub.model.Broker.class);
			return newElement;
		}

		public io.intino.datahub.model.Datalake datalake(io.intino.datahub.model.rules.Scale scale) {
			io.intino.datahub.model.Datalake newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Datalake.class, stash, this.name).a$(io.intino.datahub.model.Datalake.class);
			newElement.core$().set(newElement, "scale", java.util.Collections.singletonList(scale));
			return newElement;
		}

		public io.intino.datahub.model.Datamart datamart() {
			io.intino.datahub.model.Datamart newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Datamart.class, stash, this.name).a$(io.intino.datahub.model.Datamart.class);
			return newElement;
		}

		public io.intino.datahub.model.Terminal terminal() {
			io.intino.datahub.model.Terminal newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Terminal.class, stash, this.name).a$(io.intino.datahub.model.Terminal.class);
			return newElement;
		}

		public io.intino.datahub.model.Namespace namespace() {
			io.intino.datahub.model.Namespace newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Namespace.class, stash, this.name).a$(io.intino.datahub.model.Namespace.class);
			return newElement;
		}

		public io.intino.datahub.model.Sensor sensor() {
			io.intino.datahub.model.Sensor newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Sensor.class, stash, this.name).a$(io.intino.datahub.model.Sensor.class);
			return newElement;
		}

		public io.intino.datahub.model.Resource resource() {
			io.intino.datahub.model.Resource newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Resource.class, stash, this.name).a$(io.intino.datahub.model.Resource.class);
			return newElement;
		}

		public io.intino.datahub.model.Message message() {
			io.intino.datahub.model.Message newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Message.class, stash, this.name).a$(io.intino.datahub.model.Message.class);
			return newElement;
		}

		public io.intino.datahub.model.Component component() {
			io.intino.datahub.model.Component newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Component.class, stash, this.name).a$(io.intino.datahub.model.Component.class);
			return newElement;
		}

		public io.intino.datahub.model.Entity entity() {
			io.intino.datahub.model.Entity newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Entity.class, stash, this.name).a$(io.intino.datahub.model.Entity.class);
			return newElement;
		}

		public io.intino.datahub.model.Struct struct() {
			io.intino.datahub.model.Struct newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Struct.class, stash, this.name).a$(io.intino.datahub.model.Struct.class);
			return newElement;
		}
	}

	public class Clear {
	    public void datamart(java.util.function.Predicate<io.intino.datahub.model.Datamart> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.datamartList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void terminal(java.util.function.Predicate<io.intino.datahub.model.Terminal> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.terminalList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void namespace(java.util.function.Predicate<io.intino.datahub.model.Namespace> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.namespaceList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void sensor(java.util.function.Predicate<io.intino.datahub.model.Sensor> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.sensorList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void resource(java.util.function.Predicate<io.intino.datahub.model.Resource> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.resourceList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void message(java.util.function.Predicate<io.intino.datahub.model.Message> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.messageList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void component(java.util.function.Predicate<io.intino.datahub.model.Component> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.componentList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void entity(java.util.function.Predicate<io.intino.datahub.model.Entity> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.entityList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void struct(java.util.function.Predicate<io.intino.datahub.model.Struct> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.structList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }
	}


	private java.util.HashMap<String, Indexer> _fillIndex() {
		java.util.HashMap<String, Indexer> map = new java.util.HashMap<>();
		map.put("Broker", new Indexer(node -> broker = node.as(io.intino.datahub.model.Broker.class), node -> broker = null, () -> broker = null));
		map.put("Datalake", new Indexer(node -> datalake = node.as(io.intino.datahub.model.Datalake.class), node -> datalake = null, () -> datalake = null));
		map.put("Datamart", new Indexer(node -> datamartList.add(node.as(io.intino.datahub.model.Datamart.class)), node -> datamartList.remove(node.as(io.intino.datahub.model.Datamart.class)), () -> datamartList.clear()));
		map.put("Terminal", new Indexer(node -> terminalList.add(node.as(io.intino.datahub.model.Terminal.class)), node -> terminalList.remove(node.as(io.intino.datahub.model.Terminal.class)), () -> terminalList.clear()));
		map.put("Namespace", new Indexer(node -> namespaceList.add(node.as(io.intino.datahub.model.Namespace.class)), node -> namespaceList.remove(node.as(io.intino.datahub.model.Namespace.class)), () -> namespaceList.clear()));
		map.put("Sensor", new Indexer(node -> sensorList.add(node.as(io.intino.datahub.model.Sensor.class)), node -> sensorList.remove(node.as(io.intino.datahub.model.Sensor.class)), () -> sensorList.clear()));
		map.put("Resource", new Indexer(node -> resourceList.add(node.as(io.intino.datahub.model.Resource.class)), node -> resourceList.remove(node.as(io.intino.datahub.model.Resource.class)), () -> resourceList.clear()));
		map.put("Message", new Indexer(node -> messageList.add(node.as(io.intino.datahub.model.Message.class)), node -> messageList.remove(node.as(io.intino.datahub.model.Message.class)), () -> messageList.clear()));
		map.put("Component", new Indexer(node -> componentList.add(node.as(io.intino.datahub.model.Component.class)), node -> componentList.remove(node.as(io.intino.datahub.model.Component.class)), () -> componentList.clear()));
		map.put("Entity", new Indexer(node -> entityList.add(node.as(io.intino.datahub.model.Entity.class)), node -> entityList.remove(node.as(io.intino.datahub.model.Entity.class)), () -> entityList.clear()));
		map.put("Struct", new Indexer(node -> structList.add(node.as(io.intino.datahub.model.Struct.class)), node -> structList.remove(node.as(io.intino.datahub.model.Struct.class)), () -> structList.clear()));
		map.put("Expression", new Indexer(node -> expressionList.add(node.as(io.intino.datahub.model.Expression.class)), node -> expressionList.remove(node.as(io.intino.datahub.model.Expression.class)), () -> expressionList.clear()));
		map.put("EntityData", new Indexer(node -> entityDataList.add(node.as(io.intino.datahub.model.EntityData.class)), node -> entityDataList.remove(node.as(io.intino.datahub.model.EntityData.class)), () -> entityDataList.clear()));
		return map;
	}

	public static io.intino.magritte.io.Stash[] _language() {
		return new io.intino.magritte.io.Stash[]{stash()};
	}

	private static io.intino.magritte.io.Stash stash() {
		String content = "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";
		return io.intino.magritte.io.StashDeserializer.stashFrom(java.util.Base64.getDecoder().decode(content));
	}

	public static class Indexer {
		Add add;
		Remove remove;
		IndexClear clear;

		public Indexer(Add add, Remove remove, IndexClear clear) {
			this.add = add;
			this.remove = remove;
			this.clear = clear;
		}

		void add(io.intino.magritte.framework.Node node) {
			this.add.add(node);
		}

		void remove(io.intino.magritte.framework.Node node) {
			this.remove.remove(node);
		}

		void clear() {
			this.clear.clear();
		}
	}

	interface Add {
		void add(io.intino.magritte.framework.Node node);
	}

	interface Remove {
		void remove(io.intino.magritte.framework.Node node);
	}

	interface IndexClear {
		void clear();
	}
}