/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.model;

import io.intino.datahub.model.EntityData;
import io.intino.datahub.model.Expression;
import io.intino.datahub.model.NessGraph;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.BooleanLoader;
import io.intino.magritte.framework.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Struct
extends Layer
implements Terminal {
    protected boolean multiple;
    protected List<Attribute> attributeList = new ArrayList<Attribute>();
    protected List<Method> methodList = new ArrayList<Method>();
    protected List<Struct> structList = new ArrayList<Struct>();

    public Struct(Node node) {
        super(node);
    }

    public boolean multiple() {
        return this.multiple;
    }

    public Struct multiple(boolean value) {
        this.multiple = value;
        return this;
    }

    public List<Attribute> attributeList() {
        return Collections.unmodifiableList(this.attributeList);
    }

    public Attribute attribute(int index) {
        return this.attributeList.get(index);
    }

    public List<Attribute> attributeList(Predicate<Attribute> predicate) {
        return this.attributeList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Attribute attribute(Predicate<Attribute> predicate) {
        return this.attributeList().stream().filter(predicate).findFirst().orElse(null);
    }

    public List<Method> methodList() {
        return Collections.unmodifiableList(this.methodList);
    }

    public Method method(int index) {
        return this.methodList.get(index);
    }

    public List<Method> methodList(Predicate<Method> predicate) {
        return this.methodList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Method method(Predicate<Method> predicate) {
        return this.methodList().stream().filter(predicate).findFirst().orElse(null);
    }

    public List<Struct> structList() {
        return Collections.unmodifiableList(this.structList);
    }

    public Struct struct(int index) {
        return this.structList.get(index);
    }

    public List<Struct> structList(Predicate<Struct> predicate) {
        return this.structList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Struct struct(Predicate<Struct> predicate) {
        return this.structList().stream().filter(predicate).findFirst().orElse(null);
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Attribute>(this.attributeList).forEach(c -> components.add(c.core$()));
        new ArrayList<Method>(this.methodList).forEach(c -> components.add(c.core$()));
        new ArrayList<Struct>(this.structList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("multiple", new ArrayList<Boolean>(Collections.singletonList(this.multiple)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Struct$Attribute")) {
            this.attributeList.add((Attribute)node.as(Attribute.class));
        }
        if (node.is("Struct$Method")) {
            this.methodList.add((Method)node.as(Method.class));
        }
        if (node.is("Struct")) {
            this.structList.add((Struct)node.as(Struct.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Struct$Attribute")) {
            this.attributeList.remove(node.as(Attribute.class));
        }
        if (node.is("Struct$Method")) {
            this.methodList.remove(node.as(Method.class));
        }
        if (node.is("Struct")) {
            this.structList.remove(node.as(Struct.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("multiple")) {
            this.multiple = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("multiple")) {
            this.multiple = (Boolean)values.get(0);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public NessGraph graph() {
        return (NessGraph)this.core$().graph().as(NessGraph.class);
    }

    public static class Attribute
    extends EntityData
    implements Terminal {
        public Attribute(Node node) {
            super(node);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        @Override
        public NessGraph graph() {
            return (NessGraph)this.core$().graph().as(NessGraph.class);
        }
    }

    public static class Method
    extends Expression
    implements Terminal {
        public Method(Node node) {
            super(node);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        @Override
        public NessGraph graph() {
            return (NessGraph)this.core$().graph().as(NessGraph.class);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Attribute attribute() {
            Attribute newElement = (Attribute)Struct.this.core$().graph().concept(Attribute.class).createNode(this.name, Struct.this.core$()).as(Attribute.class);
            return newElement;
        }

        public Method method() {
            Method newElement = (Method)Struct.this.core$().graph().concept(Method.class).createNode(this.name, Struct.this.core$()).as(Method.class);
            return newElement;
        }

        public Struct struct() {
            Struct newElement = (Struct)Struct.this.core$().graph().concept(Struct.class).createNode(this.name, Struct.this.core$()).as(Struct.class);
            return newElement;
        }
    }

    public class Clear {
        public void attribute(Predicate<Attribute> filter) {
            new ArrayList<Attribute>(Struct.this.attributeList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void method(Predicate<Method> filter) {
            new ArrayList<Method>(Struct.this.methodList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void struct(Predicate<Struct> filter) {
            new ArrayList<Struct>(Struct.this.structList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }
}

