/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.model;

import io.intino.datahub.model.BrokerImplementation;
import io.intino.datahub.model.NessGraph;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.IntegerLoader;
import io.intino.magritte.framework.loaders.ObjectLoader;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.loaders.WordLoader;
import io.intino.magritte.framework.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Broker
extends Layer
implements Terminal {
    protected String path;
    protected int port;
    protected int secondaryPort;
    protected BrokerImplementation implementation;
    protected List<CompositeDestination> compositeDestinationList = new ArrayList<CompositeDestination>();
    protected List<User> userList = new ArrayList<User>();
    protected List<Pipe> pipeList = new ArrayList<Pipe>();
    protected List<Bridge> bridgeList = new ArrayList<Bridge>();

    public Broker(Node node) {
        super(node);
    }

    public String path() {
        return this.path;
    }

    public int port() {
        return this.port;
    }

    public int secondaryPort() {
        return this.secondaryPort;
    }

    public BrokerImplementation implementation() {
        return this.implementation;
    }

    public Broker path(String value) {
        this.path = value;
        return this;
    }

    public Broker port(int value) {
        this.port = value;
        return this;
    }

    public Broker secondaryPort(int value) {
        this.secondaryPort = value;
        return this;
    }

    public Broker implementation(BrokerImplementation value) {
        this.implementation = value;
        return this;
    }

    public List<CompositeDestination> compositeDestinationList() {
        return Collections.unmodifiableList(this.compositeDestinationList);
    }

    public CompositeDestination compositeDestination(int index) {
        return this.compositeDestinationList.get(index);
    }

    public List<CompositeDestination> compositeDestinationList(Predicate<CompositeDestination> predicate) {
        return this.compositeDestinationList().stream().filter(predicate).collect(Collectors.toList());
    }

    public CompositeDestination compositeDestination(Predicate<CompositeDestination> predicate) {
        return this.compositeDestinationList().stream().filter(predicate).findFirst().orElse(null);
    }

    public List<User> userList() {
        return Collections.unmodifiableList(this.userList);
    }

    public User user(int index) {
        return this.userList.get(index);
    }

    public List<User> userList(Predicate<User> predicate) {
        return this.userList().stream().filter(predicate).collect(Collectors.toList());
    }

    public User user(Predicate<User> predicate) {
        return this.userList().stream().filter(predicate).findFirst().orElse(null);
    }

    public List<Pipe> pipeList() {
        return Collections.unmodifiableList(this.pipeList);
    }

    public Pipe pipe(int index) {
        return this.pipeList.get(index);
    }

    public List<Pipe> pipeList(Predicate<Pipe> predicate) {
        return this.pipeList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Pipe pipe(Predicate<Pipe> predicate) {
        return this.pipeList().stream().filter(predicate).findFirst().orElse(null);
    }

    public List<Bridge> bridgeList() {
        return Collections.unmodifiableList(this.bridgeList);
    }

    public Bridge bridge(int index) {
        return this.bridgeList.get(index);
    }

    public List<Bridge> bridgeList(Predicate<Bridge> predicate) {
        return this.bridgeList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Bridge bridge(Predicate<Bridge> predicate) {
        return this.bridgeList().stream().filter(predicate).findFirst().orElse(null);
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<CompositeDestination>(this.compositeDestinationList).forEach(c -> components.add(c.core$()));
        new ArrayList<User>(this.userList).forEach(c -> components.add(c.core$()));
        new ArrayList<Pipe>(this.pipeList).forEach(c -> components.add(c.core$()));
        new ArrayList<Bridge>(this.bridgeList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("path", new ArrayList<String>(Collections.singletonList(this.path)));
        map.put("port", new ArrayList<Integer>(Collections.singletonList(this.port)));
        map.put("secondaryPort", new ArrayList<Integer>(Collections.singletonList(this.secondaryPort)));
        map.put("implementation", new ArrayList<BrokerImplementation>(Collections.singletonList(this.implementation)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Broker$CompositeDestination")) {
            this.compositeDestinationList.add((CompositeDestination)node.as(CompositeDestination.class));
        }
        if (node.is("Broker$User")) {
            this.userList.add((User)node.as(User.class));
        }
        if (node.is("Broker$Pipe")) {
            this.pipeList.add((Pipe)node.as(Pipe.class));
        }
        if (node.is("Broker$Bridge")) {
            this.bridgeList.add((Bridge)node.as(Bridge.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Broker$CompositeDestination")) {
            this.compositeDestinationList.remove(node.as(CompositeDestination.class));
        }
        if (node.is("Broker$User")) {
            this.userList.remove(node.as(User.class));
        }
        if (node.is("Broker$Pipe")) {
            this.pipeList.remove(node.as(Pipe.class));
        }
        if (node.is("Broker$Bridge")) {
            this.bridgeList.remove(node.as(Bridge.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("path")) {
            this.path = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("port")) {
            this.port = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("secondaryPort")) {
            this.secondaryPort = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("implementation")) {
            this.implementation = (BrokerImplementation)ObjectLoader.load(values, BrokerImplementation.class, (Layer)this).get(0);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("path")) {
            this.path = (String)values.get(0);
        } else if (name.equalsIgnoreCase("port")) {
            this.port = (Integer)values.get(0);
        } else if (name.equalsIgnoreCase("secondaryPort")) {
            this.secondaryPort = (Integer)values.get(0);
        } else if (name.equalsIgnoreCase("implementation")) {
            this.implementation = (BrokerImplementation)values.get(0);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public NessGraph graph() {
        return (NessGraph)this.core$().graph().as(NessGraph.class);
    }

    public static class CompositeDestination
    extends Layer
    implements Terminal {
        protected Type type;
        protected String name;
        protected List<String> forwardTo = new ArrayList<String>();

        public CompositeDestination(Node node) {
            super(node);
        }

        public Type type() {
            return this.type;
        }

        public String name() {
            return this.name;
        }

        public List<String> forwardTo() {
            return this.forwardTo;
        }

        public String forwardTo(int index) {
            return this.forwardTo.get(index);
        }

        public List<String> forwardTo(Predicate<String> predicate) {
            return this.forwardTo().stream().filter(predicate).collect(Collectors.toList());
        }

        public CompositeDestination type(Type value) {
            this.type = value;
            return this;
        }

        public CompositeDestination name(String value) {
            this.name = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("type", new ArrayList<Type>(Collections.singletonList(this.type)));
            map.put("name", new ArrayList<String>(Collections.singletonList(this.name)));
            map.put("forwardTo", this.forwardTo);
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("type")) {
                this.type = (Type)((Object)WordLoader.load(values, Type.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("name")) {
                this.name = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("forwardTo")) {
                this.forwardTo = StringLoader.load(values, (Layer)this);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("type")) {
                this.type = (Type)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("name")) {
                this.name = (String)values.get(0);
            } else if (name.equalsIgnoreCase("forwardTo")) {
                this.forwardTo = new ArrayList(values);
            }
        }

        public NessGraph graph() {
            return (NessGraph)this.core$().graph().as(NessGraph.class);
        }

        public static enum Type {
            Topic,
            Queue;

        }
    }

    public static class User
    extends Layer
    implements Terminal {
        protected String name;
        protected String password;

        public User(Node node) {
            super(node);
        }

        public String name() {
            return this.name;
        }

        public String password() {
            return this.password;
        }

        public User name(String value) {
            this.name = value;
            return this;
        }

        public User password(String value) {
            this.password = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("name", new ArrayList<String>(Collections.singletonList(this.name)));
            map.put("password", new ArrayList<String>(Collections.singletonList(this.password)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("name")) {
                this.name = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("password")) {
                this.password = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("name")) {
                this.name = (String)values.get(0);
            } else if (name.equalsIgnoreCase("password")) {
                this.password = (String)values.get(0);
            }
        }

        public NessGraph graph() {
            return (NessGraph)this.core$().graph().as(NessGraph.class);
        }
    }

    public static class Pipe
    extends Layer
    implements Terminal {
        protected String origin;
        protected String destination;

        public Pipe(Node node) {
            super(node);
        }

        public String origin() {
            return this.origin;
        }

        public String destination() {
            return this.destination;
        }

        public Pipe origin(String value) {
            this.origin = value;
            return this;
        }

        public Pipe destination(String value) {
            this.destination = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("origin", new ArrayList<String>(Collections.singletonList(this.origin)));
            map.put("destination", new ArrayList<String>(Collections.singletonList(this.destination)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("origin")) {
                this.origin = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("destination")) {
                this.destination = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("origin")) {
                this.origin = (String)values.get(0);
            } else if (name.equalsIgnoreCase("destination")) {
                this.destination = (String)values.get(0);
            }
        }

        public NessGraph graph() {
            return (NessGraph)this.core$().graph().as(NessGraph.class);
        }
    }

    public static class Bridge
    extends Layer
    implements Terminal {
        protected Direction direction;
        protected List<String> topics = new ArrayList<String>();
        protected ExternalBus externalBus;

        public Bridge(Node node) {
            super(node);
        }

        public Direction direction() {
            return this.direction;
        }

        public List<String> topics() {
            return this.topics;
        }

        public String topics(int index) {
            return this.topics.get(index);
        }

        public List<String> topics(Predicate<String> predicate) {
            return this.topics().stream().filter(predicate).collect(Collectors.toList());
        }

        public Bridge direction(Direction value) {
            this.direction = value;
            return this;
        }

        public ExternalBus externalBus() {
            return this.externalBus;
        }

        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            if (this.externalBus != null) {
                components.add(this.externalBus.core$());
            }
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("direction", new ArrayList<Direction>(Collections.singletonList(this.direction)));
            map.put("topics", this.topics);
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Broker$Bridge$ExternalBus")) {
                this.externalBus = (ExternalBus)node.as(ExternalBus.class);
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Broker$Bridge$ExternalBus")) {
                this.externalBus = null;
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("direction")) {
                this.direction = (Direction)((Object)WordLoader.load(values, Direction.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("topics")) {
                this.topics = StringLoader.load(values, (Layer)this);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("direction")) {
                this.direction = (Direction)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("topics")) {
                this.topics = new ArrayList(values);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public NessGraph graph() {
            return (NessGraph)this.core$().graph().as(NessGraph.class);
        }

        public static enum Direction {
            outgoing,
            incoming;

        }

        public static class ExternalBus
        extends Layer
        implements Terminal {
            protected String url;
            protected String user;
            protected String password;
            protected String sessionId;

            public ExternalBus(Node node) {
                super(node);
            }

            public String url() {
                return this.url;
            }

            public String user() {
                return this.user;
            }

            public String password() {
                return this.password;
            }

            public String sessionId() {
                return this.sessionId;
            }

            public ExternalBus url(String value) {
                this.url = value;
                return this;
            }

            public ExternalBus user(String value) {
                this.user = value;
                return this;
            }

            public ExternalBus password(String value) {
                this.password = value;
                return this;
            }

            public ExternalBus sessionId(String value) {
                this.sessionId = value;
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("url", new ArrayList<String>(Collections.singletonList(this.url)));
                map.put("user", new ArrayList<String>(Collections.singletonList(this.user)));
                map.put("password", new ArrayList<String>(Collections.singletonList(this.password)));
                map.put("sessionId", new ArrayList<String>(Collections.singletonList(this.sessionId)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("url")) {
                    this.url = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("user")) {
                    this.user = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("password")) {
                    this.password = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("sessionId")) {
                    this.sessionId = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("url")) {
                    this.url = (String)values.get(0);
                } else if (name.equalsIgnoreCase("user")) {
                    this.user = (String)values.get(0);
                } else if (name.equalsIgnoreCase("password")) {
                    this.password = (String)values.get(0);
                } else if (name.equalsIgnoreCase("sessionId")) {
                    this.sessionId = (String)values.get(0);
                }
            }

            public NessGraph graph() {
                return (NessGraph)this.core$().graph().as(NessGraph.class);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public ExternalBus externalBus(String url, String user, String password, String sessionId) {
                ExternalBus newElement = (ExternalBus)Bridge.this.core$().graph().concept(ExternalBus.class).createNode(this.name, Bridge.this.core$()).as(ExternalBus.class);
                newElement.core$().set((Layer)newElement, "url", Collections.singletonList(url));
                newElement.core$().set((Layer)newElement, "user", Collections.singletonList(user));
                newElement.core$().set((Layer)newElement, "password", Collections.singletonList(password));
                newElement.core$().set((Layer)newElement, "sessionId", Collections.singletonList(sessionId));
                return newElement;
            }
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public CompositeDestination compositeDestination(CompositeDestination.Type type, String name, List<String> forwardTo) {
            CompositeDestination newElement = (CompositeDestination)Broker.this.core$().graph().concept(CompositeDestination.class).createNode(this.name, Broker.this.core$()).as(CompositeDestination.class);
            newElement.core$().set((Layer)newElement, "type", Collections.singletonList(type));
            newElement.core$().set((Layer)newElement, "name", Collections.singletonList(name));
            newElement.core$().set((Layer)newElement, "forwardTo", forwardTo);
            return newElement;
        }

        public User user(String name, String password) {
            User newElement = (User)Broker.this.core$().graph().concept(User.class).createNode(this.name, Broker.this.core$()).as(User.class);
            newElement.core$().set((Layer)newElement, "name", Collections.singletonList(name));
            newElement.core$().set((Layer)newElement, "password", Collections.singletonList(password));
            return newElement;
        }

        public Pipe pipe(String origin, String destination) {
            Pipe newElement = (Pipe)Broker.this.core$().graph().concept(Pipe.class).createNode(this.name, Broker.this.core$()).as(Pipe.class);
            newElement.core$().set((Layer)newElement, "origin", Collections.singletonList(origin));
            newElement.core$().set((Layer)newElement, "destination", Collections.singletonList(destination));
            return newElement;
        }

        public Bridge bridge(List<String> topics) {
            Bridge newElement = (Bridge)Broker.this.core$().graph().concept(Bridge.class).createNode(this.name, Broker.this.core$()).as(Bridge.class);
            newElement.core$().set((Layer)newElement, "topics", topics);
            return newElement;
        }
    }

    public class Clear {
        public void compositeDestination(Predicate<CompositeDestination> filter) {
            new ArrayList<CompositeDestination>(Broker.this.compositeDestinationList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void user(Predicate<User> filter) {
            new ArrayList<User>(Broker.this.userList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void pipe(Predicate<Pipe> filter) {
            new ArrayList<Pipe>(Broker.this.pipeList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void bridge(Predicate<Bridge> filter) {
            new ArrayList<Bridge>(Broker.this.bridgeList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }
}

