/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.model;

import io.intino.datahub.model.Broker;
import io.intino.datahub.model.Component;
import io.intino.datahub.model.Datalake;
import io.intino.datahub.model.Datamart;
import io.intino.datahub.model.Entity;
import io.intino.datahub.model.EntityData;
import io.intino.datahub.model.Expression;
import io.intino.datahub.model.Message;
import io.intino.datahub.model.Namespace;
import io.intino.datahub.model.Resource;
import io.intino.datahub.model.Sensor;
import io.intino.datahub.model.Struct;
import io.intino.datahub.model.Terminal;
import io.intino.datahub.model.rules.Scale;
import io.intino.magritte.framework.Concept;
import io.intino.magritte.framework.Graph;
import io.intino.magritte.framework.GraphWrapper;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.utils.I18n;
import io.intino.magritte.io.Stash;
import io.intino.magritte.io.StashDeserializer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class AbstractGraph
extends GraphWrapper {
    protected Graph graph;
    private Broker broker;
    private Datalake datalake;
    private List<Datamart> datamartList = new ArrayList<Datamart>();
    private List<Terminal> terminalList = new ArrayList<Terminal>();
    private List<Namespace> namespaceList = new ArrayList<Namespace>();
    private List<Sensor> sensorList = new ArrayList<Sensor>();
    private List<Resource> resourceList = new ArrayList<Resource>();
    private List<Message> messageList = new ArrayList<Message>();
    private List<Component> componentList = new ArrayList<Component>();
    private List<Entity> entityList = new ArrayList<Entity>();
    private List<Struct> structList = new ArrayList<Struct>();
    private List<Expression> expressionList = new ArrayList<Expression>();
    private List<EntityData> entityDataList = new ArrayList<EntityData>();
    private Map<String, Indexer> _index = this._fillIndex();

    public AbstractGraph(Graph graph) {
        this.graph = graph;
        this.graph.i18n().register("Ness");
    }

    public AbstractGraph(Graph graph, AbstractGraph wrapper) {
        this.graph = graph;
        this.graph.i18n().register("Ness");
        this.broker = wrapper.broker;
        this.datalake = wrapper.datalake;
        this.datamartList = new ArrayList<Datamart>(wrapper.datamartList);
        this.terminalList = new ArrayList<Terminal>(wrapper.terminalList);
        this.namespaceList = new ArrayList<Namespace>(wrapper.namespaceList);
        this.sensorList = new ArrayList<Sensor>(wrapper.sensorList);
        this.resourceList = new ArrayList<Resource>(wrapper.resourceList);
        this.messageList = new ArrayList<Message>(wrapper.messageList);
        this.componentList = new ArrayList<Component>(wrapper.componentList);
        this.entityList = new ArrayList<Entity>(wrapper.entityList);
        this.structList = new ArrayList<Struct>(wrapper.structList);
        this.expressionList = new ArrayList<Expression>(wrapper.expressionList);
        this.entityDataList = new ArrayList<EntityData>(wrapper.entityDataList);
    }

    public <T extends GraphWrapper> T a$(Class<T> t) {
        return (T)this.core$().as(t);
    }

    public void update() {
        this._index.values().forEach(v -> v.clear());
        this.graph.rootList().forEach(r -> this.addNode$((Node)r));
    }

    protected void addNode$(Node node) {
        for (Concept c : node.conceptList()) {
            if (!this._index.containsKey(c.id())) continue;
            this._index.get(c.id()).add(node);
        }
        if (this._index.containsKey(node.id())) {
            this._index.get(node.id()).add(node);
        }
    }

    protected void removeNode$(Node node) {
        for (Concept c : node.conceptList()) {
            if (!this._index.containsKey(c.id())) continue;
            this._index.get(c.id()).remove(node);
        }
        if (this._index.containsKey(node.id())) {
            this._index.get(node.id()).remove(node);
        }
    }

    public URL resourceAsMessage$(String language, String key) {
        return this.graph.loadResource(this.graph.i18n().message(language, key, new Object[0]));
    }

    public Broker broker() {
        return this.broker;
    }

    public Datalake datalake() {
        return this.datalake;
    }

    public List<Datamart> datamartList() {
        return this.datamartList;
    }

    public List<Terminal> terminalList() {
        return this.terminalList;
    }

    public List<Namespace> namespaceList() {
        return this.namespaceList;
    }

    public List<Sensor> sensorList() {
        return this.sensorList;
    }

    public List<Resource> resourceList() {
        return this.resourceList;
    }

    public List<Message> messageList() {
        return this.messageList;
    }

    public List<Component> componentList() {
        return this.componentList;
    }

    public List<Entity> entityList() {
        return this.entityList;
    }

    public List<Struct> structList() {
        return this.structList;
    }

    public List<Expression> expressionList() {
        return this.expressionList;
    }

    public List<EntityData> entityDataList() {
        return this.entityDataList;
    }

    public Stream<Datamart> datamartList(Predicate<Datamart> filter) {
        return this.datamartList.stream().filter(filter);
    }

    public Datamart datamart(int index) {
        return this.datamartList.get(index);
    }

    public Stream<Terminal> terminalList(Predicate<Terminal> filter) {
        return this.terminalList.stream().filter(filter);
    }

    public Terminal terminal(int index) {
        return this.terminalList.get(index);
    }

    public Stream<Namespace> namespaceList(Predicate<Namespace> filter) {
        return this.namespaceList.stream().filter(filter);
    }

    public Namespace namespace(int index) {
        return this.namespaceList.get(index);
    }

    public Stream<Sensor> sensorList(Predicate<Sensor> filter) {
        return this.sensorList.stream().filter(filter);
    }

    public Sensor sensor(int index) {
        return this.sensorList.get(index);
    }

    public Stream<Resource> resourceList(Predicate<Resource> filter) {
        return this.resourceList.stream().filter(filter);
    }

    public Resource resource(int index) {
        return this.resourceList.get(index);
    }

    public Stream<Message> messageList(Predicate<Message> filter) {
        return this.messageList.stream().filter(filter);
    }

    public Message message(int index) {
        return this.messageList.get(index);
    }

    public Stream<Component> componentList(Predicate<Component> filter) {
        return this.componentList.stream().filter(filter);
    }

    public Component component(int index) {
        return this.componentList.get(index);
    }

    public Stream<Entity> entityList(Predicate<Entity> filter) {
        return this.entityList.stream().filter(filter);
    }

    public Entity entity(int index) {
        return this.entityList.get(index);
    }

    public Stream<Struct> structList(Predicate<Struct> filter) {
        return this.structList.stream().filter(filter);
    }

    public Struct struct(int index) {
        return this.structList.get(index);
    }

    public Stream<Expression> expressionList(Predicate<Expression> filter) {
        return this.expressionList.stream().filter(filter);
    }

    public Expression expression(int index) {
        return this.expressionList.get(index);
    }

    public Stream<EntityData> entityDataList(Predicate<EntityData> filter) {
        return this.entityDataList.stream().filter(filter);
    }

    public EntityData entityData(int index) {
        return this.entityDataList.get(index);
    }

    public Graph core$() {
        return this.graph;
    }

    public I18n i18n$() {
        return this.graph.i18n();
    }

    public Create create() {
        return new Create("Misc", null);
    }

    public Create create(String stash) {
        return new Create(stash, null);
    }

    public Create create(String stash, String name) {
        return new Create(stash, name);
    }

    public Clear clear() {
        return new Clear();
    }

    private HashMap<String, Indexer> _fillIndex() {
        HashMap<String, Indexer> map = new HashMap<String, Indexer>();
        map.put("Broker", new Indexer(node -> {
            this.broker = (Broker)node.as(Broker.class);
        }, node -> {
            this.broker = null;
        }, () -> {
            this.broker = null;
        }));
        map.put("Datalake", new Indexer(node -> {
            this.datalake = (Datalake)node.as(Datalake.class);
        }, node -> {
            this.datalake = null;
        }, () -> {
            this.datalake = null;
        }));
        map.put("Datamart", new Indexer(node -> this.datamartList.add((Datamart)node.as(Datamart.class)), node -> this.datamartList.remove(node.as(Datamart.class)), () -> this.datamartList.clear()));
        map.put("Terminal", new Indexer(node -> this.terminalList.add((Terminal)node.as(Terminal.class)), node -> this.terminalList.remove(node.as(Terminal.class)), () -> this.terminalList.clear()));
        map.put("Namespace", new Indexer(node -> this.namespaceList.add((Namespace)node.as(Namespace.class)), node -> this.namespaceList.remove(node.as(Namespace.class)), () -> this.namespaceList.clear()));
        map.put("Sensor", new Indexer(node -> this.sensorList.add((Sensor)node.as(Sensor.class)), node -> this.sensorList.remove(node.as(Sensor.class)), () -> this.sensorList.clear()));
        map.put("Resource", new Indexer(node -> this.resourceList.add((Resource)node.as(Resource.class)), node -> this.resourceList.remove(node.as(Resource.class)), () -> this.resourceList.clear()));
        map.put("Message", new Indexer(node -> this.messageList.add((Message)node.as(Message.class)), node -> this.messageList.remove(node.as(Message.class)), () -> this.messageList.clear()));
        map.put("Component", new Indexer(node -> this.componentList.add((Component)node.as(Component.class)), node -> this.componentList.remove(node.as(Component.class)), () -> this.componentList.clear()));
        map.put("Entity", new Indexer(node -> this.entityList.add((Entity)node.as(Entity.class)), node -> this.entityList.remove(node.as(Entity.class)), () -> this.entityList.clear()));
        map.put("Struct", new Indexer(node -> this.structList.add((Struct)node.as(Struct.class)), node -> this.structList.remove(node.as(Struct.class)), () -> this.structList.clear()));
        map.put("Expression", new Indexer(node -> this.expressionList.add((Expression)node.as(Expression.class)), node -> this.expressionList.remove(node.as(Expression.class)), () -> this.expressionList.clear()));
        map.put("EntityData", new Indexer(node -> this.entityDataList.add((EntityData)node.as(EntityData.class)), node -> this.entityDataList.remove(node.as(EntityData.class)), () -> this.entityDataList.clear()));
        return map;
    }

    public static Stash[] _language() {
        return new Stash[]{AbstractGraph.stash()};
    }

    private static Stash stash() {
        String content = "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";
        return StashDeserializer.stashFrom((byte[])Base64.getDecoder().decode(content));
    }

    public static class Indexer {
        Add add;
        Remove remove;
        IndexClear clear;

        public Indexer(Add add, Remove remove, IndexClear clear) {
            this.add = add;
            this.remove = remove;
            this.clear = clear;
        }

        void add(Node node) {
            this.add.add(node);
        }

        void remove(Node node) {
            this.remove.remove(node);
        }

        void clear() {
            this.clear.clear();
        }
    }

    public class Create {
        private final String stash;
        private final String name;

        public Create(String stash, String name) {
            this.stash = stash;
            this.name = name;
        }

        public Broker broker() {
            Broker newElement = (Broker)((Broker)AbstractGraph.this.graph.createRoot(Broker.class, this.stash, this.name)).a$(Broker.class);
            return newElement;
        }

        public Datalake datalake(Scale scale) {
            Datalake newElement = (Datalake)((Datalake)AbstractGraph.this.graph.createRoot(Datalake.class, this.stash, this.name)).a$(Datalake.class);
            newElement.core$().set((Layer)newElement, "scale", Collections.singletonList(scale));
            return newElement;
        }

        public Datamart datamart() {
            Datamart newElement = (Datamart)((Datamart)AbstractGraph.this.graph.createRoot(Datamart.class, this.stash, this.name)).a$(Datamart.class);
            return newElement;
        }

        public Terminal terminal() {
            Terminal newElement = (Terminal)((Terminal)AbstractGraph.this.graph.createRoot(Terminal.class, this.stash, this.name)).a$(Terminal.class);
            return newElement;
        }

        public Namespace namespace() {
            Namespace newElement = (Namespace)((Namespace)AbstractGraph.this.graph.createRoot(Namespace.class, this.stash, this.name)).a$(Namespace.class);
            return newElement;
        }

        public Sensor sensor() {
            Sensor newElement = (Sensor)((Sensor)AbstractGraph.this.graph.createRoot(Sensor.class, this.stash, this.name)).a$(Sensor.class);
            return newElement;
        }

        public Resource resource() {
            Resource newElement = (Resource)((Resource)AbstractGraph.this.graph.createRoot(Resource.class, this.stash, this.name)).a$(Resource.class);
            return newElement;
        }

        public Message message() {
            Message newElement = (Message)((Message)AbstractGraph.this.graph.createRoot(Message.class, this.stash, this.name)).a$(Message.class);
            return newElement;
        }

        public Component component() {
            Component newElement = (Component)((Component)AbstractGraph.this.graph.createRoot(Component.class, this.stash, this.name)).a$(Component.class);
            return newElement;
        }

        public Entity entity() {
            Entity newElement = (Entity)((Entity)AbstractGraph.this.graph.createRoot(Entity.class, this.stash, this.name)).a$(Entity.class);
            return newElement;
        }

        public Struct struct() {
            Struct newElement = (Struct)((Struct)AbstractGraph.this.graph.createRoot(Struct.class, this.stash, this.name)).a$(Struct.class);
            return newElement;
        }
    }

    public class Clear {
        public void datamart(Predicate<Datamart> filter) {
            new ArrayList<Datamart>(AbstractGraph.this.datamartList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void terminal(Predicate<Terminal> filter) {
            new ArrayList<Terminal>(AbstractGraph.this.terminalList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void namespace(Predicate<Namespace> filter) {
            new ArrayList<Namespace>(AbstractGraph.this.namespaceList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void sensor(Predicate<Sensor> filter) {
            new ArrayList<Sensor>(AbstractGraph.this.sensorList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void resource(Predicate<Resource> filter) {
            new ArrayList<Resource>(AbstractGraph.this.resourceList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void message(Predicate<Message> filter) {
            new ArrayList<Message>(AbstractGraph.this.messageList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void component(Predicate<Component> filter) {
            new ArrayList<Component>(AbstractGraph.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void entity(Predicate<Entity> filter) {
            new ArrayList<Entity>(AbstractGraph.this.entityList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void struct(Predicate<Struct> filter) {
            new ArrayList<Struct>(AbstractGraph.this.structList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    static interface Add {
        public void add(Node var1);
    }

    static interface Remove {
        public void remove(Node var1);
    }

    static interface IndexClear {
        public void clear();
    }
}

