/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datamart.serialization;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.zim.ZimStream;
import io.intino.alexandria.zim.ZimWriter;
import io.intino.datahub.box.DataHubBox;
import io.intino.datahub.datamart.MasterDatamart;
import io.intino.datahub.datamart.impl.LocalMasterDatamart;
import io.intino.datahub.model.Datamart;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MasterDatamartSerializer {
    public static final String SNAPSHOT_EXTENSION = ".dm-snapshot.zim";
    private final DataHubBox box;

    public MasterDatamartSerializer(DataHubBox box) {
        this.box = box;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(MasterDatamart datamart, Predicate<Message> messagePredicate, OutputStream outputStream) throws IOException {
        MasterDatamart masterDatamart = datamart;
        synchronized (masterDatamart) {
            try (ZimWriter writer = new ZimWriter(outputStream);){
                Iterator messages = datamart.entityStore().stream().filter(messagePredicate::test).iterator();
                while (messages.hasNext()) {
                    writer.write((Message)messages.next());
                }
            }
        }
    }

    public MasterDatamart deserialize(File file, Datamart definition) throws IOException {
        return this.deserialize(new FileInputStream(file), definition);
    }

    public MasterDatamart deserialize(InputStream inputStream, Datamart definition) throws IOException {
        try (ZimStream messages = ZimStream.of((InputStream)inputStream);){
            LocalMasterDatamart localMasterDatamart = new LocalMasterDatamart(this.box, definition).reflow((Stream<Message>)messages);
            return localMasterDatamart;
        }
    }

    public void saveSnapshot(Timetag timetag, MasterDatamart datamart) throws IOException {
        File file = this.snapshotDirOf(datamart.name() + "/" + timetag.value() + SNAPSHOT_EXTENSION);
        file.getParentFile().mkdirs();
        this.serialize(datamart, t -> true, new FileOutputStream(file));
    }

    public List<Timetag> listAvailableSnapshotsOf(String datamartName) {
        return this.listSnapshotFilesIn(this.snapshotDirOf(datamartName)).stream().map(this::timetagOf).collect(Collectors.toList());
    }

    public Optional<MasterDatamart.Snapshot> loadMostRecentSnapshot(String datamartName) {
        return this.loadMostRecentSnapshotTo(datamartName, Timetag.of((LocalDate)LocalDate.now(), (Scale)Scale.Day));
    }

    public Optional<MasterDatamart.Snapshot> loadMostRecentSnapshotTo(String datamartName, Timetag timetag) {
        return this.findSnapshotFileOf(this.snapshotDirOf(datamartName), timetag).map(f -> this.loadSnapshot((File)f, datamartName));
    }

    private MasterDatamart.Snapshot loadSnapshot(File file, String datamartName) {
        try {
            MasterDatamart datamart = this.deserialize(new FileInputStream(file), this.definitionOf(datamartName));
            return new MasterDatamart.Snapshot(this.timetagOf(file), datamart);
        }
        catch (IOException e) {
            Logger.error((String)("Failed to deserialize datamart snapshot " + file.getName() + ": " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    private Datamart definitionOf(String name) {
        return this.box.graph().datamartList().stream().filter(d -> d.name$().equals(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("No datamart named " + name + " defined"));
    }

    public File snapshotDirOf(String datamartName) {
        return new File(this.box.datamartsDirectory(), datamartName);
    }

    private Optional<File> findSnapshotFileOf(File dir, Timetag timetag) {
        return this.listSnapshotFilesIn(dir).stream().sorted(Collections.reverseOrder()).filter(f -> this.snapshotIsEqualOrBefore(this.timetagOf((File)f), timetag)).findFirst();
    }

    private Timetag timetagOf(File file) {
        try {
            String name = file.getName().replace(SNAPSHOT_EXTENSION, "");
            Timetag timetag = Timetag.of((String)name.substring(name.indexOf(46) + 1));
            timetag.datetime();
            return timetag;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private List<File> listSnapshotFilesIn(File dir) {
        File[] files = dir.listFiles(f -> f.getName().endsWith(SNAPSHOT_EXTENSION) && this.timetagOf(f) != null);
        if (files == null || files.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(files);
    }

    private boolean snapshotIsEqualOrBefore(Timetag snapshotTimetag, Timetag targetTimetag) {
        if (snapshotTimetag == null) {
            return false;
        }
        return snapshotTimetag.equals((Object)targetTimetag) || snapshotTimetag.isBefore(targetTimetag);
    }
}

