/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datamart.mounters.timelines;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.measurement.MeasurementEvent;
import io.intino.alexandria.logger.Logger;
import io.intino.datahub.box.DataHubBox;
import io.intino.datahub.datamart.MasterDatamart;
import io.intino.datahub.datamart.mounters.MounterUtils;
import io.intino.datahub.datamart.mounters.timelines.IndicatorMounter;
import io.intino.datahub.model.Timeline;
import io.intino.sumus.chronos.TimelineStore;
import io.intino.sumus.chronos.timelines.TimelineWriter;
import io.intino.sumus.chronos.timelines.stores.FileTimelineStore;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class TimelineRawMounter {
    private final DataHubBox box;
    private final MasterDatamart datamart;
    private final Map<String, Set<String>> timelineTypes;
    private final IndicatorMounter indicatorMounter;

    public TimelineRawMounter(DataHubBox box, MasterDatamart datamart, Map<String, Set<String>> timelineTypes) {
        this.box = box;
        this.datamart = datamart;
        this.timelineTypes = timelineTypes;
        this.indicatorMounter = new IndicatorMounter(datamart);
    }

    public void mount(MeasurementEvent event) {
        try {
            if (event.ss() == null) {
                return;
            }
            TimelineStore store = this.getOrCreateTimelineStore(event, MounterUtils.sourceSensor((Event)event));
            this.update(store, event);
            this.mountIndicator(event, store);
        }
        catch (Exception e) {
            Logger.error((String)("Could not mount event " + event.type() + ", ss = " + event.ss() + ": " + e.getMessage()), (Throwable)e);
        }
    }

    private void mountIndicator(MeasurementEvent event, TimelineStore store) {
        Timeline.Raw definition = this.definitionOf(event);
        if (store != null && definition != null && definition.asTimeline().isIndicator()) {
            this.indicatorMounter.mount(definition.tank().asTank().asMeasurement().sensor().name$(), store);
        }
    }

    private Timeline.Raw definitionOf(MeasurementEvent event) {
        return this.datamart.definition().timelineList().stream().filter(Timeline::isRaw).map(Timeline::asRaw).filter(t -> this.timelineTypes.getOrDefault(t.name$(), Set.of()).contains(event.type())).findFirst().orElse(null);
    }

    public List<String> destinationsOf(MeasurementEvent event) {
        return List.of(event.type() + "\u0000" + MounterUtils.sourceSensor((Event)event));
    }

    private TimelineStore getOrCreateTimelineStore(MeasurementEvent event, String sensor) throws IOException {
        return MounterUtils.rawTimelineBuilder().datamart(this.datamart).datamartDir(this.box.datamartTimelinesDirectory(this.datamart.name())).start(event.ts()).type(event.type()).entity(sensor).createIfNotExists();
    }

    protected void update(TimelineStore tlStore, MeasurementEvent event) throws IOException {
        File timelineFile = ((FileTimelineStore)tlStore).file();
        File sessionFile = MounterUtils.copyOf(timelineFile, ".session");
        try {
            try (TimelineWriter writer = TimelineStore.of((File)sessionFile).writer();){
                TimelineRawMounter.checkTs(event.ts(), writer);
                writer.set(event.values());
            }
            Files.move(sessionFile.toPath(), timelineFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            sessionFile.delete();
            throw e;
        }
    }

    private static void checkTs(Instant ts, TimelineWriter writer) throws IOException {
        long lapse = Duration.between(writer.header().next(), ts).getSeconds();
        if (lapse > writer.timeModel().period().duration() * 2L) {
            writer.set(ts);
        }
    }

    private static String name(MeasurementEvent event, int i) {
        String name = event.magnitudes()[i].name();
        return name.contains("=") ? name.substring(0, name.indexOf(":")) : name;
    }

    public static class OfSingleTimeline
    extends TimelineRawMounter {
        private final Supplier<TimelineWriter> writer;

        public OfSingleTimeline(MasterDatamart datamart, Supplier<TimelineWriter> writer) {
            super(datamart.box(), datamart, Collections.emptyMap());
            this.writer = writer;
        }

        @Override
        public void mount(MeasurementEvent event) {
            try {
                TimelineWriter writer = this.writer.get();
                TimelineRawMounter.checkTs(event.ts(), writer);
                writer.set(event.values());
            }
            catch (Exception e) {
                Logger.error((String)("Could not mount event " + event.type() + ", ss = " + event.ss() + ": " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

