/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datamart;

import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class TimeShiftCache {
    private final File file;
    private Connection connection;
    private PreparedStatement query;
    private PreparedStatement insert;
    private PreparedStatement delete;
    private ExecutorService executorService;
    private ScheduledExecutorService commitService;

    public TimeShiftCache(File file) {
        this.file = file;
    }

    public TimeShiftCache open() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                return this;
            }
            this.file.getParentFile().mkdirs();
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.file.getAbsolutePath());
            this.connection.createStatement().execute("CREATE TABLE IF NOT EXISTS events (id text NOT NULL PRIMARY KEY, ts bigint);");
            this.insert = this.connection.prepareStatement("INSERT OR REPLACE INTO events (id, ts) VALUES(?,?);");
            this.delete = this.connection.prepareStatement("DELETE FROM events WHERE id=?;");
            this.query = this.connection.prepareStatement("SELECT * FROM events WHERE id=?");
            this.connection.setAutoCommit(false);
            this.executorService = Executors.newSingleThreadExecutor(r -> new Thread(r, "TimeShift-" + this.file.getName()));
            this.commitService = Executors.newScheduledThreadPool(1, r -> new Thread(r, "TimeShift-commit-" + this.file.getName()));
            this.commitService.scheduleAtFixedRate(this::commit, 1L, 1L, TimeUnit.MINUTES);
        }
        catch (ClassNotFoundException | SQLException e) {
            Logger.error((Throwable)e);
        }
        return this;
    }

    public synchronized void put(String id, Instant ts) {
        this.executorService.execute(() -> {
            try {
                this.insert.setString(1, id);
                this.insert.setLong(2, ts.toEpochMilli() / 1000L);
                this.insert.executeUpdate();
            }
            catch (SQLException e) {
                Logger.error((Throwable)e);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Instant get(String id) {
        this.commit();
        try (ResultSet rs = this.query(id);){
            boolean next = rs.next();
            if (!next) {
                Instant instant2 = null;
                return instant2;
            }
            Instant instant = Instant.ofEpochSecond(rs.getLong(2));
            return instant;
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public synchronized void remove(String id) {
        try {
            this.delete.setString(1, id);
            this.delete.executeUpdate();
        }
        catch (SQLException e) {
            Logger.error((Throwable)e);
        }
    }

    private void commit() {
        try {
            this.connection.commit();
        }
        catch (SQLException e) {
            Logger.error((Throwable)e);
        }
    }

    private ResultSet query(String id) throws SQLException {
        this.query.setString(1, id);
        return this.query.executeQuery();
    }

    public void close() throws Exception {
        try {
            this.closeExecutor();
            this.insert.close();
            this.delete.close();
            this.query.close();
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void closeExecutor() {
        try {
            this.executorService.shutdown();
            this.executorService.awaitTermination(1L, TimeUnit.MINUTES);
            this.commitService.shutdown();
            this.commitService.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Logger.error((Throwable)e);
        }
    }
}

