/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datalake.regenerator;

import io.intino.alexandria.Fingerprint;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.event.message.MessageEventReader;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.MessageWriter;
import io.intino.alexandria.zim.Zim;
import io.intino.datahub.datalake.regenerator.Mapper;
import io.intino.datahub.datalake.regenerator.RegeneratorReporter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.time.Instant;
import java.util.Collection;
import org.apache.commons.io.FileUtils;

public class SessionRegenerator {
    private final Datalake datalake;
    private final File backupDirectory;
    private final File reviewDirectory;
    private final String ts;

    public SessionRegenerator(Datalake datalake, File backupDirectory, File reviewDirectory) {
        this.datalake = datalake;
        this.backupDirectory = backupDirectory;
        this.reviewDirectory = reviewDirectory;
        this.ts = this.ts();
    }

    public File review(Mapper mapper) {
        File reportFile = new File(this.reviewDirectory, this.mapperPrefixName(mapper) + ".html");
        RegeneratorReporter reporter = new RegeneratorReporter(reportFile);
        for (File session : this.sessions()) {
            if (this.notSuitable(session, mapper.filter())) continue;
            try (MessageEventReader reader = new MessageEventReader(session);){
                reader.forEachRemaining(e -> {
                    String before = e.toString();
                    this.map(mapper, reporter, (MessageEvent)e, before);
                });
            }
            catch (Exception e2) {
                Logger.error((Throwable)e2);
            }
        }
        reporter.commit();
        return reportFile;
    }

    public File revise(Mapper mapper) {
        File reportFile = new File(this.backupDirectory, this.mapperPrefixName(mapper) + ".html");
        RegeneratorReporter reporter = new RegeneratorReporter(reportFile);
        for (File session : this.sessions()) {
            if (this.notSuitable(session, mapper.filter())) continue;
            MessageWriter writer = new MessageWriter(this.zim(this.temp(session)));
            try (MessageEventReader reader = new MessageEventReader(session);){
                reader.forEachRemaining(e -> {
                    String before = e.toString();
                    MessageEvent after = this.map(mapper, reporter, (MessageEvent)e, before);
                    if (after != null) {
                        this.write(writer, after);
                    }
                });
            }
            catch (Exception e2) {
                Logger.error((Throwable)e2);
            }
            this.close(writer);
            this.backupSourceSession(mapper, session);
            if (this.temp(session).length() > 20L) {
                this.move(this.temp(session), session);
                continue;
            }
            this.temp(session).delete();
        }
        reporter.commit();
        return reportFile;
    }

    private boolean notSuitable(File session, Mapper.Filter filter) {
        Datalake.Store.Tank<MessageEvent> tank = this.tankOf(session);
        Datalake.Store.Source<MessageEvent> source = this.sourceOf(tank, session);
        return !filter.allow(tank) || !filter.allow(tank, source, this.timetagOf(session));
    }

    private MessageEvent map(Mapper mapper, RegeneratorReporter reporter, MessageEvent e, String before) {
        MessageEvent after = e;
        Mapper.Filter filter = mapper.filter();
        if (filter.allow((Event)e)) {
            after = (MessageEvent)mapper.apply((Event)e);
            reporter.addItem(before, after == null ? null : after.toString());
        }
        return after;
    }

    private Timetag timetagOf(File session) {
        return SessionRegenerator.fingerprintOf(session).timetag();
    }

    private Datalake.Store.Tank<MessageEvent> tankOf(File session) {
        return this.datalake.messageStore().tank(SessionRegenerator.fingerprintOf(session).tank());
    }

    private Datalake.Store.Source<MessageEvent> sourceOf(Datalake.Store.Tank<MessageEvent> tank, File session) {
        Fingerprint fingerprint = SessionRegenerator.fingerprintOf(session);
        return tank.source(fingerprint.source());
    }

    private Collection<File> sessions() {
        this.backupDirectory.mkdirs();
        return FileUtils.listFiles((File)this.backupDirectory, (String[])new String[]{"event.session.treated"}, (boolean)true);
    }

    private void backupSourceSession(Mapper mapper, File session) {
        File dest = new File(session.getParentFile(), this.mapperPrefixName(mapper) + "_" + session.getName() + ".bak");
        this.move(session, dest);
    }

    private String mapperPrefixName(Mapper mapper) {
        return "backup_" + mapper.getClass().getSimpleName() + "_" + this.ts;
    }

    private File temp(File file) {
        return new File(file.getAbsolutePath() + ".tmp");
    }

    private String ts() {
        return Instant.now().toString().replaceAll("[-:]", "").replace("T", "").substring(0, 14);
    }

    private void move(File source, File dest) {
        try {
            Files.move(source.toPath(), dest.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private void write(MessageWriter writer, MessageEvent after) {
        try {
            writer.write(after.toMessage());
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private void close(MessageWriter writer) {
        try {
            writer.close();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private OutputStream zim(File file) {
        try {
            return Zim.compressing((OutputStream)new BufferedOutputStream(new FileOutputStream(file)));
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    private static Fingerprint fingerprintOf(File file) {
        return new Fingerprint(SessionRegenerator.cleanedNameOf(file));
    }

    private static String cleanedNameOf(File file) {
        return file.getName().substring(0, file.getName().indexOf("#")).replace("-", "/").replace(String.valueOf(Event.Format.Message) + ".session.treated", "");
    }
}

