/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datalake.regenerator;

import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.datalake.file.FileDatalake;
import io.intino.alexandria.logger.Logger;
import io.intino.datahub.datalake.regenerator.DatalakeRegenerator;
import io.intino.datahub.datalake.regenerator.Mapper;
import io.intino.datahub.datalake.regenerator.SessionRegenerator;
import java.io.File;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;

public class Regenerator {
    private final FileDatalake datalake;
    private final File sessionsBackupDirectory;
    private final File reviewsDirectory;

    public Regenerator(FileDatalake datalake, File sessionsBackupDirectory, File reviewsDirectory) {
        this.datalake = datalake;
        this.sessionsBackupDirectory = sessionsBackupDirectory;
        this.reviewsDirectory = reviewsDirectory;
    }

    public List<File> review(Mapper mapper) {
        String ts = this.ts();
        Logger.info((String)("Executing Regeneration review with mapper " + mapper.getClass().getSimpleName()));
        File datalakeReport = new DatalakeRegenerator(this.datalake, this.reviewsDirectory, ts).review(mapper);
        Logger.info((String)"Finished review on datalake");
        if (this.sessionsBackupDirectory != null) {
            File sessionsReport = new SessionRegenerator((Datalake)this.datalake, this.sessionsBackupDirectory, this.reviewsDirectory).review(mapper);
            Logger.info((String)"Finished Regeneration review");
            return Arrays.asList(datalakeReport, sessionsReport);
        }
        Logger.info((String)"Finished Regeneration revise");
        return List.of(datalakeReport);
    }

    public List<File> revise(Mapper mapper) {
        String ts = this.ts();
        Logger.info((String)("Executing Regeneration revise with mapper " + mapper.getClass().getSimpleName()));
        File datalakeReport = new DatalakeRegenerator(this.datalake, this.reviewsDirectory, ts).revise(mapper);
        Logger.info((String)"Finished revise on datalake");
        if (this.sessionsBackupDirectory != null) {
            File sessionsReport = new SessionRegenerator((Datalake)this.datalake, this.sessionsBackupDirectory, this.reviewsDirectory).revise(mapper);
            Logger.info((String)"Finished Regeneration revise");
            return Arrays.asList(datalakeReport, sessionsReport);
        }
        Logger.info((String)"Finished Regeneration revise");
        return List.of(datalakeReport);
    }

    private String ts() {
        return Instant.now().toString().replaceAll("-|:", "").replace("T", "").substring(0, 14);
    }
}

