/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datalake.actions;

import io.intino.alexandria.logger.Logger;
import io.intino.datahub.box.DataHubBox;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;

public class DatalakeBackupAction {
    public static final String BAK = "bak";
    private static AtomicBoolean started = new AtomicBoolean(false);
    private final DataHubBox box;

    public DatalakeBackupAction(DataHubBox box) {
        this.box = box;
    }

    public boolean isStarted() {
        return started.get();
    }

    public synchronized void execute() {
        if (this.box.graph().datalake().backup() == null) {
            return;
        }
        if (started.get()) {
            return;
        }
        started.set(true);
        this.removeOldBacks();
        File backupDirectory = new File(this.box.graph().datalake().backup().path());
        this.backupDatalake(backupDirectory);
        this.backupSessions(new File(backupDirectory, "sessions"));
        Logger.info((String)"Backup finished");
        started.set(false);
    }

    private void removeOldBacks() {
        File root = new File(this.box.graph().datalake().path());
        List collect = new ArrayList(FileUtils.listFiles((File)root, (String[])new String[]{BAK}, (boolean)true)).stream().filter(f -> new Date(f.lastModified()).before(Date.from(Instant.now().minus(7L, ChronoUnit.DAYS).truncatedTo(ChronoUnit.DAYS)))).collect(Collectors.toList());
        for (File file : collect) {
            file.delete();
        }
    }

    private void backupDatalake(File backupDirectory) {
        Logger.info((String)"Launching Backup of datalake...");
        backupDirectory.mkdir();
        File root = new File(this.box.graph().datalake().path());
        File destination = new File(backupDirectory, this.name() + ".zip");
        destination.getParentFile().mkdirs();
        try {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(destination));
            this.zipDirectory(root, root.getName(), zos);
            zos.flush();
            zos.close();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
        Logger.info((String)"Datalake Backup finished");
    }

    private String name() {
        return Instant.now().toString().replaceAll("-|:", "").replaceAll("T", "_").substring(0, 13);
    }

    private void backupSessions(File backupDirectory) {
        Logger.info((String)"Launching Backup of sessions...");
        File stage = this.box.stageDirectory();
        ArrayList collect = new ArrayList(FileUtils.listFiles((File)stage, (String[])new String[]{"treated"}, (boolean)true));
        Logger.info((String)(collect.size() + " session to backup"));
        for (File session : collect) {
            try {
                if (!session.exists()) continue;
                File destination = new File(backupDirectory, this.ts(session));
                destination.mkdirs();
                File destinationFile = new File(destination, session.getName());
                if (!destinationFile.exists()) {
                    Files.move(session.toPath(), destinationFile.toPath(), new CopyOption[0]);
                    continue;
                }
                session.renameTo(new File(session.getAbsolutePath() + ".duplicated"));
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
            }
        }
    }

    private String ts(File session) {
        return new Date(session.lastModified()).toInstant().toString().replace("-", "").substring(0, 8);
    }

    private void zipDirectory(File folder, String parentFolder, ZipOutputStream zos) throws IOException {
        for (File file : Objects.requireNonNull(folder.listFiles())) {
            int read;
            if (file.isDirectory()) {
                this.zipDirectory(file, parentFolder + "/" + file.getName(), zos);
                continue;
            }
            zos.putNextEntry(new ZipEntry(parentFolder + "/" + file.getName()));
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            byte[] bytesIn = new byte[4096];
            while ((read = bis.read(bytesIn)) != -1) {
                zos.write(bytesIn, 0, read);
            }
            zos.closeEntry();
        }
    }
}

