/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.broker.jms;

import io.intino.alexandria.Fingerprint;
import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.logger.Logger;
import io.intino.datahub.broker.jms.JmsMessageTranslator;
import jakarta.jms.Message;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Iterator;
import java.util.function.Consumer;

class ProcessStatusSerializer {
    private final File stage;
    private final String tank;
    private final Scale scale;

    ProcessStatusSerializer(File stage, String processStatusTank, Scale scale) {
        this.stage = stage;
        this.tank = processStatusTank;
        this.scale = scale;
    }

    Consumer<Message> create() {
        return message -> this.save(JmsMessageTranslator.toInlMessages(message));
    }

    private void save(Iterator<io.intino.alexandria.message.Message> messages) {
        messages.forEachRemaining(m -> this.write(this.destination((io.intino.alexandria.message.Message)m).toPath(), (io.intino.alexandria.message.Message)m));
    }

    private void write(Path path, io.intino.alexandria.message.Message message) {
        try {
            Files.writeString(path, (CharSequence)(message.toString() + "\n\n"), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private File destination(io.intino.alexandria.message.Message message) {
        MessageEvent event = new MessageEvent(message);
        String fingerprint = Fingerprint.of((String)this.tank, (String)event.ss(), (Timetag)this.timetag(event), (Event.Format)Event.Format.Message).name();
        return new File(this.stage, fingerprint + ".session");
    }

    private Timetag timetag(MessageEvent event) {
        return Timetag.of((LocalDateTime)LocalDateTime.ofInstant(event.ts(), ZoneOffset.UTC), (Scale)this.scale);
    }
}

