/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.box.service.scheduling;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.scheduler.AlexandriaScheduler;
import io.intino.alexandria.scheduler.ScheduledTrigger;
import io.intino.datahub.box.DataHubBox;
import io.intino.datahub.box.actions.BackupAction;
import io.intino.datahub.box.actions.DatamartsSnapshotAction;
import io.intino.datahub.box.actions.SealAction;
import io.intino.datahub.model.Datalake;
import java.time.ZoneId;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TimeZone;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public class Sentinels {
    private final AlexandriaScheduler scheduler = new AlexandriaScheduler();

    public Sentinels(DataHubBox box) {
        try {
            if (box.graph().datalake() != null && box.graph().datalake().seal() != null) {
                this.addSealingSentinel(box);
            }
            if (box.graph().datalake() != null && box.graph().datalake().backup() != null) {
                this.addDatalakeBackupSentinel(box);
            }
            if (box.graph().datamartList() != null && !box.graph().datamartList().isEmpty()) {
                this.addDatamartsSnapshotSentinel(box);
            }
            this.scheduler.startSchedules();
        }
        catch (Exception e) {
            Logger.error((String)e.getMessage());
        }
    }

    private void addDatamartsSnapshotSentinel(DataHubBox box) throws SchedulerException {
        JobDetail job = JobBuilder.newJob(DatamartsSnapshotSentinel.class).withIdentity("DatamartsSnapshot").build();
        job.getJobDataMap().put("box", (Object)box);
        this.scheduler.scheduleJob(job, Sentinels.newSet(TriggerBuilder.newTrigger().withIdentity("DataHub#DatamartsSnapshot").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.dailyAt00AM()).inTimeZone(TimeZone.getDefault())).build()), true);
    }

    private void addDatalakeBackupSentinel(DataHubBox box) throws SchedulerException {
        JobDetail job = JobBuilder.newJob(DatalakeBackupListener.class).withIdentity("DatalakeBackup").build();
        job.getJobDataMap().put("box", (Object)box);
        Datalake.Backup.Cron cron = box.graph().datalake().backup().cron();
        String zoneId = cron.timeZone();
        this.scheduler.scheduleJob(job, Sentinels.newSet(TriggerBuilder.newTrigger().withIdentity("DataHub#DatalakeBackup").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron.pattern()).inTimeZone(zoneId == null ? TimeZone.getDefault() : TimeZone.getTimeZone(ZoneId.of(zoneId)))).build()), true);
    }

    private void addSealingSentinel(DataHubBox box) throws SchedulerException {
        JobDetail job = JobBuilder.newJob(SealingListener.class).withIdentity("Sealing").build();
        job.getJobDataMap().put("box", (Object)box);
        Datalake.Seal.Cron cron = box.graph().datalake().seal().cron();
        String zoneId = cron.timeZone();
        this.scheduler.scheduleJob(job, Sentinels.newSet(TriggerBuilder.newTrigger().withIdentity("DataHub#Sealing").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron.pattern()).inTimeZone(zoneId == null ? TimeZone.getDefault() : TimeZone.getTimeZone(ZoneId.of(zoneId)))).build()), true);
    }

    public void stop() {
        try {
            this.scheduler.shutdownSchedules();
        }
        catch (SchedulerException e) {
            Logger.error((Throwable)e);
        }
    }

    private String dailyAt00AM() {
        return "0 0 0 1/1 * ? *";
    }

    private static Set<Trigger> newSet(Trigger ... triggers) {
        LinkedHashSet<Trigger> set = new LinkedHashSet<Trigger>();
        Collections.addAll(set, triggers);
        return set;
    }

    public static class DatamartsSnapshotSentinel
    implements ScheduledTrigger {
        public void execute(JobExecutionContext context) throws JobExecutionException {
            new DatamartsSnapshotAction((DataHubBox)((Object)context.getMergedJobDataMap().get((Object)"box"))).execute();
        }
    }

    public static class DatalakeBackupListener
    implements ScheduledTrigger {
        public void execute(JobExecutionContext context) {
            new BackupAction((DataHubBox)((Object)context.getMergedJobDataMap().get((Object)"box"))).execute();
        }
    }

    public static class SealingListener
    implements ScheduledTrigger {
        public void execute(JobExecutionContext context) {
            new SealAction((DataHubBox)((Object)context.getMergedJobDataMap().get((Object)"box"))).execute();
        }
    }
}

