/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.box.actions;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.logger.Logger;
import io.intino.datahub.box.DataHubBox;
import io.intino.datahub.datamart.MasterDatamart;
import io.intino.datahub.model.Datamart;
import io.intino.datahub.model.rules.DayOfWeek;
import io.intino.datahub.model.rules.SnapshotScale;
import java.io.File;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class DatamartsSnapshotAction {
    public DataHubBox box;

    public DatamartsSnapshotAction() {
    }

    public DatamartsSnapshotAction(DataHubBox box) {
        this.box = box;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        Class<DatamartsSnapshotAction> clazz = DatamartsSnapshotAction.class;
        synchronized (DatamartsSnapshotAction.class) {
            Timetag timetag = Timetag.of((LocalDate)LocalDate.now(), (Scale)Scale.Day).previous();
            this.box.datamarts().datamarts().parallelStream().forEach(datamart -> this.createSnapshotIfNecessary(timetag, (MasterDatamart)datamart));
            this.removeOldSnapshots();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void removeOldSnapshots() {
        for (MasterDatamart datamart : this.box.datamarts().datamarts()) {
            File snapshotsDir = this.box.datamartSerializer().snapshotDirOf(datamart.name());
            File[] files = snapshotsDir.listFiles(f -> f.getName().endsWith(".zim") && Timetag.isTimetag((String)f.getName().replace(".zim", "")));
            int maxCount = this.definitionOf(datamart).snapshots().maxCount();
            if (files == null || maxCount < 0 || files.length <= maxCount) continue;
            Arrays.stream(files).sorted().limit(maxCount - files.length).forEach(File::delete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSnapshotIfNecessary(Timetag today, MasterDatamart datamart) {
        MasterDatamart masterDatamart = datamart;
        synchronized (masterDatamart) {
            try {
                Datamart definition = this.definitionOf(datamart);
                if (definition.snapshots() == null) {
                    return;
                }
                SnapshotScale scale = definition.snapshots().scale();
                if (scale == null) {
                    return;
                }
                DayOfWeek firstDayOfWeek = definition.snapshots().firstDayOfWeek();
                if (firstDayOfWeek == null) {
                    firstDayOfWeek = DayOfWeek.MONDAY;
                }
                if (MasterDatamart.Snapshot.shouldCreateSnapshot(today, scale, firstDayOfWeek)) {
                    this.box.datamartSerializer().saveSnapshot(today, datamart);
                }
            }
            catch (Throwable e) {
                Logger.error((String)("Failed to handle snapshot of " + datamart.name() + ": " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private Datamart definitionOf(MasterDatamart datamart) {
        return this.box.graph().datamartList(d -> d.name$().equals(datamart.name())).findFirst().orElseThrow(() -> new NoSuchElementException("No datamart named " + datamart.name() + " defined in ness model"));
    }
}

