package io.intino.datahub.box;

import java.util.Map;
import java.util.HashMap;
import java.io.File;

public class DataHubConfiguration extends io.intino.alexandria.core.BoxConfiguration {

	public DataHubConfiguration(String[] args) {
		super(args);
	}

	public String uiPort() {
		return get("ui_port");
	}

	public File backupDirectory() {
		return get("backup_directory") == null ? null : new File(get("backup_directory"));
	}

	public String brokerPort() {
		return get("broker_port");
	}

	public String brokerSecondaryPort() {
		return get("broker_secondary_port");
	}

	public String keystorePath() {
		return get("keystore_path");
	}

	public String keystorePassword() {
		return get("keystore_password");
	}

	public String truststorePath() {
		return get("truststore_path");
	}

	public String truststorePassword() {
		return get("truststore_password");
	}

	public java.io.File home() {
		return new java.io.File(args.getOrDefault("home", System.getProperty("user.home")));
	}
}