package io.intino.datahub.model;

import io.intino.magritte.framework.Graph;

public class AbstractGraph extends io.intino.magritte.framework.GraphWrapper {
	protected io.intino.magritte.framework.Graph graph;
	private io.intino.datahub.model.Broker broker;
	private io.intino.datahub.model.Datalake datalake;
	private java.util.List<io.intino.datahub.model.Datamart> datamartList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.Terminal> terminalList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.Namespace> namespaceList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.Sensor> sensorList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.Resource> resourceList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.Message> messageList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.Component> componentList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.Entity> entityList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.Struct> structList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.Expression> expressionList = new java.util.ArrayList<>();
	private java.util.List<io.intino.datahub.model.EntityData> entityDataList = new java.util.ArrayList<>();

	private java.util.Map<String, Indexer> _index = _fillIndex();

	public AbstractGraph(io.intino.magritte.framework.Graph graph) {
		this.graph = graph;
		this.graph.i18n().register("Ness");
	}

	public AbstractGraph(io.intino.magritte.framework.Graph graph, AbstractGraph wrapper) {
		this.graph = graph;
		this.graph.i18n().register("Ness");
		this.broker = wrapper.broker;
		this.datalake = wrapper.datalake;
		this.datamartList = new java.util.ArrayList<>(wrapper.datamartList);
		this.terminalList = new java.util.ArrayList<>(wrapper.terminalList);
		this.namespaceList = new java.util.ArrayList<>(wrapper.namespaceList);
		this.sensorList = new java.util.ArrayList<>(wrapper.sensorList);
		this.resourceList = new java.util.ArrayList<>(wrapper.resourceList);
		this.messageList = new java.util.ArrayList<>(wrapper.messageList);
		this.componentList = new java.util.ArrayList<>(wrapper.componentList);
		this.entityList = new java.util.ArrayList<>(wrapper.entityList);
		this.structList = new java.util.ArrayList<>(wrapper.structList);
		this.expressionList = new java.util.ArrayList<>(wrapper.expressionList);
		this.entityDataList = new java.util.ArrayList<>(wrapper.entityDataList);
	}

	public <T extends io.intino.magritte.framework.GraphWrapper> T a$(Class<T> t) {
		return this.core$().as(t);
	}

    @Override
	public void update() {
		this._index.values().forEach(v -> v.clear());
		graph.rootList().forEach(r -> addNode$(r));
	}

	@Override
	protected void addNode$(io.intino.magritte.framework.Node node) {
		for (io.intino.magritte.framework.Concept c : node.conceptList()) if (this._index.containsKey(c.id())) this._index.get(c.id()).add(node);
		if (this._index.containsKey(node.id())) this._index.get(node.id()).add(node);
	}

	@Override
	protected void removeNode$(io.intino.magritte.framework.Node node) {
		for (io.intino.magritte.framework.Concept c : node.conceptList()) if (this._index.containsKey(c.id())) this._index.get(c.id()).remove(node);
		if (this._index.containsKey(node.id())) this._index.get(node.id()).remove(node);
	}

	public java.net.URL resourceAsMessage$(String language, String key) {
		return graph.loadResource(graph.i18n().message(language, key));
	}

	public io.intino.datahub.model.Broker broker() {
		return broker;
	}

	public io.intino.datahub.model.Datalake datalake() {
		return datalake;
	}

	public java.util.List<io.intino.datahub.model.Datamart> datamartList() {
		return datamartList;
	}

	public java.util.List<io.intino.datahub.model.Terminal> terminalList() {
		return terminalList;
	}

	public java.util.List<io.intino.datahub.model.Namespace> namespaceList() {
		return namespaceList;
	}

	public java.util.List<io.intino.datahub.model.Sensor> sensorList() {
		return sensorList;
	}

	public java.util.List<io.intino.datahub.model.Resource> resourceList() {
		return resourceList;
	}

	public java.util.List<io.intino.datahub.model.Message> messageList() {
		return messageList;
	}

	public java.util.List<io.intino.datahub.model.Component> componentList() {
		return componentList;
	}

	public java.util.List<io.intino.datahub.model.Entity> entityList() {
		return entityList;
	}

	public java.util.List<io.intino.datahub.model.Struct> structList() {
		return structList;
	}

	public java.util.List<io.intino.datahub.model.Expression> expressionList() {
		return expressionList;
	}

	public java.util.List<io.intino.datahub.model.EntityData> entityDataList() {
		return entityDataList;
	}

	public java.util.stream.Stream<io.intino.datahub.model.Datamart> datamartList(java.util.function.Predicate<io.intino.datahub.model.Datamart> filter) {
		return datamartList.stream().filter(filter);
	}

	public io.intino.datahub.model.Datamart datamart(int index) {
		return datamartList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.Terminal> terminalList(java.util.function.Predicate<io.intino.datahub.model.Terminal> filter) {
		return terminalList.stream().filter(filter);
	}

	public io.intino.datahub.model.Terminal terminal(int index) {
		return terminalList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.Namespace> namespaceList(java.util.function.Predicate<io.intino.datahub.model.Namespace> filter) {
		return namespaceList.stream().filter(filter);
	}

	public io.intino.datahub.model.Namespace namespace(int index) {
		return namespaceList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.Sensor> sensorList(java.util.function.Predicate<io.intino.datahub.model.Sensor> filter) {
		return sensorList.stream().filter(filter);
	}

	public io.intino.datahub.model.Sensor sensor(int index) {
		return sensorList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.Resource> resourceList(java.util.function.Predicate<io.intino.datahub.model.Resource> filter) {
		return resourceList.stream().filter(filter);
	}

	public io.intino.datahub.model.Resource resource(int index) {
		return resourceList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.Message> messageList(java.util.function.Predicate<io.intino.datahub.model.Message> filter) {
		return messageList.stream().filter(filter);
	}

	public io.intino.datahub.model.Message message(int index) {
		return messageList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.Component> componentList(java.util.function.Predicate<io.intino.datahub.model.Component> filter) {
		return componentList.stream().filter(filter);
	}

	public io.intino.datahub.model.Component component(int index) {
		return componentList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.Entity> entityList(java.util.function.Predicate<io.intino.datahub.model.Entity> filter) {
		return entityList.stream().filter(filter);
	}

	public io.intino.datahub.model.Entity entity(int index) {
		return entityList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.Struct> structList(java.util.function.Predicate<io.intino.datahub.model.Struct> filter) {
		return structList.stream().filter(filter);
	}

	public io.intino.datahub.model.Struct struct(int index) {
		return structList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.Expression> expressionList(java.util.function.Predicate<io.intino.datahub.model.Expression> filter) {
		return expressionList.stream().filter(filter);
	}

	public io.intino.datahub.model.Expression expression(int index) {
		return expressionList.get(index);
	}

	public java.util.stream.Stream<io.intino.datahub.model.EntityData> entityDataList(java.util.function.Predicate<io.intino.datahub.model.EntityData> filter) {
		return entityDataList.stream().filter(filter);
	}

	public io.intino.datahub.model.EntityData entityData(int index) {
		return entityDataList.get(index);
	}

	public io.intino.magritte.framework.Graph core$() {
		return graph;
	}

	public io.intino.magritte.framework.utils.I18n i18n$() {
		return graph.i18n();
	}

	public Create create() {
		return new Create("Misc", null);
	}

	public Create create(String stash) {
		return new Create(stash, null);
	}

	public Create create(String stash, String name) {
		return new Create(stash, name);
	}

	public Clear clear() {
		return new Clear();
	}

	public class Create {
		private final String stash;
		private final String name;

		public Create(String stash, String name) {
			this.stash = stash;
			this.name = name;
		}

		public io.intino.datahub.model.Broker broker() {
			io.intino.datahub.model.Broker newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Broker.class, stash, this.name).a$(io.intino.datahub.model.Broker.class);
			return newElement;
		}

		public io.intino.datahub.model.Datalake datalake(io.intino.datahub.model.rules.Scale scale) {
			io.intino.datahub.model.Datalake newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Datalake.class, stash, this.name).a$(io.intino.datahub.model.Datalake.class);
			newElement.core$().set(newElement, "scale", java.util.Collections.singletonList(scale));
			return newElement;
		}

		public io.intino.datahub.model.Datamart datamart() {
			io.intino.datahub.model.Datamart newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Datamart.class, stash, this.name).a$(io.intino.datahub.model.Datamart.class);
			return newElement;
		}

		public io.intino.datahub.model.Terminal terminal() {
			io.intino.datahub.model.Terminal newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Terminal.class, stash, this.name).a$(io.intino.datahub.model.Terminal.class);
			return newElement;
		}

		public io.intino.datahub.model.Namespace namespace() {
			io.intino.datahub.model.Namespace newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Namespace.class, stash, this.name).a$(io.intino.datahub.model.Namespace.class);
			return newElement;
		}

		public io.intino.datahub.model.Sensor sensor() {
			io.intino.datahub.model.Sensor newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Sensor.class, stash, this.name).a$(io.intino.datahub.model.Sensor.class);
			return newElement;
		}

		public io.intino.datahub.model.Resource resource() {
			io.intino.datahub.model.Resource newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Resource.class, stash, this.name).a$(io.intino.datahub.model.Resource.class);
			return newElement;
		}

		public io.intino.datahub.model.Message message() {
			io.intino.datahub.model.Message newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Message.class, stash, this.name).a$(io.intino.datahub.model.Message.class);
			return newElement;
		}

		public io.intino.datahub.model.Component component() {
			io.intino.datahub.model.Component newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Component.class, stash, this.name).a$(io.intino.datahub.model.Component.class);
			return newElement;
		}

		public io.intino.datahub.model.Entity entity() {
			io.intino.datahub.model.Entity newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Entity.class, stash, this.name).a$(io.intino.datahub.model.Entity.class);
			return newElement;
		}

		public io.intino.datahub.model.Struct struct() {
			io.intino.datahub.model.Struct newElement = AbstractGraph.this.graph.createRoot(io.intino.datahub.model.Struct.class, stash, this.name).a$(io.intino.datahub.model.Struct.class);
			return newElement;
		}
	}

	public class Clear {
	    public void datamart(java.util.function.Predicate<io.intino.datahub.model.Datamart> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.datamartList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void terminal(java.util.function.Predicate<io.intino.datahub.model.Terminal> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.terminalList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void namespace(java.util.function.Predicate<io.intino.datahub.model.Namespace> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.namespaceList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void sensor(java.util.function.Predicate<io.intino.datahub.model.Sensor> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.sensorList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void resource(java.util.function.Predicate<io.intino.datahub.model.Resource> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.resourceList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void message(java.util.function.Predicate<io.intino.datahub.model.Message> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.messageList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void component(java.util.function.Predicate<io.intino.datahub.model.Component> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.componentList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void entity(java.util.function.Predicate<io.intino.datahub.model.Entity> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.entityList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }

	    public void struct(java.util.function.Predicate<io.intino.datahub.model.Struct> filter) {
	    	new java.util.ArrayList<>(AbstractGraph.this.structList()).stream().filter(filter).forEach(io.intino.magritte.framework.Layer::delete$);
	    }
	}


	private java.util.HashMap<String, Indexer> _fillIndex() {
		java.util.HashMap<String, Indexer> map = new java.util.HashMap<>();
		map.put("Broker", new Indexer(node -> broker = node.as(io.intino.datahub.model.Broker.class), node -> broker = null, () -> broker = null));
		map.put("Datalake", new Indexer(node -> datalake = node.as(io.intino.datahub.model.Datalake.class), node -> datalake = null, () -> datalake = null));
		map.put("Datamart", new Indexer(node -> datamartList.add(node.as(io.intino.datahub.model.Datamart.class)), node -> datamartList.remove(node.as(io.intino.datahub.model.Datamart.class)), () -> datamartList.clear()));
		map.put("Terminal", new Indexer(node -> terminalList.add(node.as(io.intino.datahub.model.Terminal.class)), node -> terminalList.remove(node.as(io.intino.datahub.model.Terminal.class)), () -> terminalList.clear()));
		map.put("Namespace", new Indexer(node -> namespaceList.add(node.as(io.intino.datahub.model.Namespace.class)), node -> namespaceList.remove(node.as(io.intino.datahub.model.Namespace.class)), () -> namespaceList.clear()));
		map.put("Sensor", new Indexer(node -> sensorList.add(node.as(io.intino.datahub.model.Sensor.class)), node -> sensorList.remove(node.as(io.intino.datahub.model.Sensor.class)), () -> sensorList.clear()));
		map.put("Resource", new Indexer(node -> resourceList.add(node.as(io.intino.datahub.model.Resource.class)), node -> resourceList.remove(node.as(io.intino.datahub.model.Resource.class)), () -> resourceList.clear()));
		map.put("Message", new Indexer(node -> messageList.add(node.as(io.intino.datahub.model.Message.class)), node -> messageList.remove(node.as(io.intino.datahub.model.Message.class)), () -> messageList.clear()));
		map.put("Component", new Indexer(node -> componentList.add(node.as(io.intino.datahub.model.Component.class)), node -> componentList.remove(node.as(io.intino.datahub.model.Component.class)), () -> componentList.clear()));
		map.put("Entity", new Indexer(node -> entityList.add(node.as(io.intino.datahub.model.Entity.class)), node -> entityList.remove(node.as(io.intino.datahub.model.Entity.class)), () -> entityList.clear()));
		map.put("Struct", new Indexer(node -> structList.add(node.as(io.intino.datahub.model.Struct.class)), node -> structList.remove(node.as(io.intino.datahub.model.Struct.class)), () -> structList.clear()));
		map.put("Expression", new Indexer(node -> expressionList.add(node.as(io.intino.datahub.model.Expression.class)), node -> expressionList.remove(node.as(io.intino.datahub.model.Expression.class)), () -> expressionList.clear()));
		map.put("EntityData", new Indexer(node -> entityDataList.add(node.as(io.intino.datahub.model.EntityData.class)), node -> entityDataList.remove(node.as(io.intino.datahub.model.EntityData.class)), () -> entityDataList.clear()));
		return map;
	}

	public static io.intino.magritte.io.Stash[] _language() {
		return new io.intino.magritte.io.Stash[]{stash()};
	}

	private static io.intino.magritte.io.Stash stash() {
		String content = "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";
		return io.intino.magritte.io.StashDeserializer.stashFrom(java.util.Base64.getDecoder().decode(content));
	}

	public static class Indexer {
		Add add;
		Remove remove;
		IndexClear clear;

		public Indexer(Add add, Remove remove, IndexClear clear) {
			this.add = add;
			this.remove = remove;
			this.clear = clear;
		}

		void add(io.intino.magritte.framework.Node node) {
			this.add.add(node);
		}

		void remove(io.intino.magritte.framework.Node node) {
			this.remove.remove(node);
		}

		void clear() {
			this.clear.clear();
		}
	}

	interface Add {
		void add(io.intino.magritte.framework.Node node);
	}

	interface Remove {
		void remove(io.intino.magritte.framework.Node node);
	}

	interface IndexClear {
		void clear();
	}
}