/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datamart.mounters;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.datahub.datamart.MasterDatamart;
import io.intino.datahub.datamart.mounters.MasterDatamartMounter;
import java.util.Collections;
import java.util.List;

public final class EntityMounter
extends MasterDatamartMounter {
    public EntityMounter(MasterDatamart datamart) {
        super(datamart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mount(Event event) {
        MasterDatamart masterDatamart = this.datamart;
        synchronized (masterDatamart) {
            if (event instanceof MessageEvent) {
                MessageEvent e = (MessageEvent)event;
                this.mount(e.toMessage());
            }
        }
    }

    @Override
    public void mount(Message message) {
        if (message == null) {
            return;
        }
        try {
            String id = message.get("id").asString();
            if (this.isInvalidId(id)) {
                return;
            }
            Message oldMessage = this.datamart.entityStore().get(id);
            if (oldMessage != null) {
                this.update(message, id, oldMessage);
            } else {
                this.addNewEntity(message, id);
            }
        }
        catch (Throwable e) {
            Logger.error((String)("Failed to mount message of type " + message.type() + ": " + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public List<String> destinationsOf(Message message) {
        return Collections.emptyList();
    }

    private void addNewEntity(Message message, String id) {
        this.datamart.entityStore().put(id, message);
    }

    private void update(Message message, String id, Message oldMessage) {
        if (!oldMessage.type().equals(message.type())) {
            throw new MismatchMessageTypeException("Id " + id + " already exists with a different message type: old=" + oldMessage.type() + ", new=" + message.type());
        }
        this.update(oldMessage, message);
    }

    private void update(Message message, Message changes) {
        changes.attributes().forEach(attribute -> message.set(attribute, changes.get(attribute).data()));
        this.removeAllComponents(message);
        message.add(changes.components());
    }

    private void removeAllComponents(Message message) {
        message.components().forEach(arg_0 -> ((Message)message).remove(arg_0));
    }

    private boolean isInvalidId(String id) {
        return id == null || id.isEmpty();
    }

    private static boolean isDisabled(Message message) {
        return message.contains("enabled") && message.get("enabled").asBoolean() == false;
    }

    private static class MismatchMessageTypeException
    extends IllegalStateException {
        public MismatchMessageTypeException(String message) {
            super(message);
        }
    }
}

