/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datamart;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.datahub.box.DataHubBox;
import io.intino.datahub.datamart.TimeShiftCache;
import io.intino.datahub.datamart.mounters.MasterDatamartMounter;
import io.intino.datahub.datamart.mounters.MounterUtils;
import io.intino.datahub.model.Datalake;
import io.intino.datahub.model.Datamart;
import io.intino.datahub.model.IndicatorFile;
import io.intino.datahub.model.rules.DayOfWeek;
import io.intino.datahub.model.rules.SnapshotScale;
import io.intino.sumus.chronos.ReelFile;
import io.intino.sumus.chronos.TimelineStore;
import java.io.Closeable;
import java.io.File;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;

public interface MasterDatamart
extends Closeable {
    public Datamart definition();

    public DataHubBox box();

    public String name();

    public Store<Message> entityStore();

    public ChronosDirectory<TimelineStore> timelineStore();

    public IndicatorDirectory indicatorStore();

    public ChronosDirectory<ReelFile> reelStore();

    public Stream<MasterDatamartMounter> createMountersFor(Datalake.Tank var1);

    public TimeShiftCache cacheOf(String var1);

    default public Instant ts() {
        return this.entityStore().stream().map(m -> m.get("ts").asInstant()).filter(Objects::nonNull).max(Comparator.naturalOrder()).orElse(null);
    }

    default public void clear() {
        this.entityStore().clear();
        this.timelineStore().clear();
        this.reelStore().clear();
    }

    @Override
    public void close();

    public static String normalizePath(String path) {
        return path.replace(":", "-");
    }

    public static interface Store<T> {
        public int size();

        public boolean contains(String var1);

        public T get(String var1);

        public void put(String var1, T var2);

        public void remove(String var1);

        public void clear();

        public Stream<T> stream();

        public Map<String, T> toMap();

        public Collection<String> subscribedEvents();

        public boolean isSubscribedTo(Datalake.Tank var1);
    }

    public static abstract class ChronosDirectory<T> {
        private final File root;

        public ChronosDirectory(File root) {
            this.root = root;
        }

        protected abstract String extension();

        public int size() {
            return this.listFiles().size();
        }

        public abstract T get(String var1, String var2);

        public boolean contains(String type, String id) {
            return this.fileOf(type, id).exists();
        }

        public void remove(String type, String id) {
            this.fileOf(type, id).delete();
        }

        public void clear() {
            for (File file : this.listFiles()) {
                try {
                    file.delete();
                }
                catch (Exception e) {
                    Logger.error((Throwable)e);
                }
            }
        }

        public abstract Stream<T> stream();

        public abstract Collection<String> subscribedEvents();

        public abstract boolean isSubscribedTo(Datalake.Tank var1);

        protected File fileOf(String type, String id) {
            return new File(this.root, MasterDatamart.normalizePath(type + File.separator + id + this.extension()));
        }

        protected List<File> listFiles() {
            return this.root.exists() ? new ArrayList(FileUtils.listFiles((File)this.root, (String[])new String[]{this.extension(), this.extension().substring(1)}, (boolean)true)) : Collections.emptyList();
        }
    }

    public static class IndicatorDirectory {
        private final Set<String> subscribedEvents;
        private final File root;

        public IndicatorDirectory(Datamart definition, File root) {
            this.subscribedEvents = definition.timelineList().stream().flatMap(MounterUtils::types).collect(Collectors.toSet());
            this.root = root;
        }

        protected String extension() {
            return ".indicator";
        }

        public IndicatorFile get(String indicator) {
            return IndicatorFile.of(this.fileOf(indicator));
        }

        public boolean contains(String indicator) {
            return this.fileOf(indicator).exists();
        }

        public Stream<IndicatorFile> stream() {
            return this.listFiles().stream().map(IndicatorFile::of);
        }

        protected File fileOf(String indicator) {
            return new File(this.root, MasterDatamart.normalizePath(indicator) + this.extension());
        }

        protected List<File> listFiles() {
            return this.root.exists() ? new ArrayList(FileUtils.listFiles((File)this.root, (String[])new String[]{this.extension(), this.extension().substring(1)}, (boolean)true)) : Collections.emptyList();
        }

        public Collection<String> subscribedEvents() {
            return this.subscribedEvents;
        }

        public boolean isSubscribedTo(Datalake.Tank tank) {
            Collection<String> events = this.subscribedEvents();
            if (tank.isMeasurement() && events.contains(tank.asMeasurement().sensor().name$())) {
                return true;
            }
            return tank.isMessage() && events.contains(tank.asMessage().message().name$());
        }
    }

    public record Snapshot(Timetag timetag, MasterDatamart datamart) {
        public static boolean shouldCreateSnapshot(Timetag oldTimetag, Timetag newTimetag, SnapshotScale scale, DayOfWeek firstDayOfWeek) {
            return switch (scale) {
                default -> throw new IncompatibleClassChangeError();
                case SnapshotScale.None -> false;
                case SnapshotScale.Day -> {
                    if (ChronoUnit.DAYS.between(oldTimetag.date(), newTimetag.date()) >= 1L) {
                        yield true;
                    }
                    yield false;
                }
                case SnapshotScale.Month -> {
                    if (ChronoUnit.MONTHS.between(oldTimetag.date(), newTimetag.date()) >= 1L) {
                        yield true;
                    }
                    yield false;
                }
                case SnapshotScale.Year -> {
                    if (ChronoUnit.YEARS.between(oldTimetag.date(), newTimetag.date()) >= 1L) {
                        yield true;
                    }
                    yield false;
                }
                case SnapshotScale.Week -> ChronoUnit.WEEKS.between(oldTimetag.date(), newTimetag.date()) >= 1L;
            };
        }

        public static boolean shouldCreateSnapshot(Timetag timetag, SnapshotScale scale, DayOfWeek firstDayOfWeek) {
            return switch (scale) {
                default -> throw new IncompatibleClassChangeError();
                case SnapshotScale.None -> false;
                case SnapshotScale.Day -> true;
                case SnapshotScale.Year -> Snapshot.isFirstDayOfYear(timetag);
                case SnapshotScale.Month -> Snapshot.isFirstDayOfMonth(timetag);
                case SnapshotScale.Week -> Snapshot.isFirstDayOfWeek(timetag, firstDayOfWeek);
            };
        }

        private static boolean isFirstDayOfYear(Timetag today) {
            return today.month() == 1 && today.day() == 1;
        }

        private static boolean isFirstDayOfMonth(Timetag today) {
            return today.day() == 1;
        }

        private static boolean isFirstDayOfWeek(Timetag today, DayOfWeek firstDayOfWeek) {
            return today.datetime().getDayOfWeek().name().equalsIgnoreCase(firstDayOfWeek.name());
        }
    }
}

