/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datalake.seal;

import io.intino.alexandria.FS;
import io.intino.alexandria.Fingerprint;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.sealing.EventSealer;
import io.intino.alexandria.sealing.SessionSealer;
import io.intino.datahub.datalake.seal.MeasurementEventSealer;
import io.intino.datahub.model.Datalake;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EventSessionSealer {
    private final Datalake datalake;
    private final io.intino.datahub.model.Datalake graphDl;
    private final File stageDir;
    private final File tmpDir;
    private final File treatedDir;
    private EventSealer eventSealer;
    private MeasurementEventSealer measurementSealer;

    public EventSessionSealer(Datalake datalake, io.intino.datahub.model.Datalake graphDl, File stageDir, File tmpDir, File treatedDir) {
        this.datalake = datalake;
        this.graphDl = graphDl;
        this.stageDir = stageDir;
        this.tmpDir = tmpDir;
        this.treatedDir = treatedDir;
    }

    public void seal() {
        this.seal(t -> true);
    }

    public void seal(SessionSealer.TankNameFilter tankNameFilter) {
        this.eventSealer = new EventSealer(this.datalake, tankNameFilter, this.tmpDir);
        this.measurementSealer = new MeasurementEventSealer(this.datalake, this.graphDl);
        ((Stream)EventSessionSealer.sessions(this.stageDir).collect(Collectors.groupingBy(EventSessionSealer::fingerprintOf)).entrySet().stream().sorted(Comparator.comparing(t -> ((Fingerprint)t.getKey()).toString())).parallel()).forEach(this::seal);
    }

    private void seal(Map.Entry<Fingerprint, List<File>> e) {
        try {
            switch (this.formatOf(e.getKey().tank())) {
                case Message: 
                case Resource: {
                    this.eventSealer.seal(e.getKey(), e.getValue());
                    break;
                }
                case Measurement: {
                    this.measurementSealer.seal(e.getKey(), e.getValue());
                }
            }
            this.moveTreated(e);
        }
        catch (IOException ex) {
            Logger.error((Throwable)ex);
        }
    }

    private Event.Format formatOf(String tankName) {
        return this.graphDl.tankList().stream().filter(tank -> EventSessionSealer.matches(tankName, tank)).findFirst().map(this::formatOf).orElse(Event.Format.Unknown);
    }

    private Event.Format formatOf(Datalake.Tank tank) {
        if (tank.isMessage()) {
            return Event.Format.Message;
        }
        if (tank.isMeasurement()) {
            return Event.Format.Measurement;
        }
        if (tank.isResource()) {
            return Event.Format.Resource;
        }
        return Event.Format.Unknown;
    }

    private static boolean matches(String tankName, Datalake.Tank tank) {
        if (tank.isMessage() && tank.asMessage().qn().equals(tankName)) {
            return true;
        }
        if (tank.isMeasurement() && tank.asMeasurement().qn().equals(tankName)) {
            return true;
        }
        return tank.isResource() && tank.asResource().qn().equals(tankName);
    }

    private void moveTreated(Map.Entry<Fingerprint, List<File>> e) {
        e.getValue().forEach(f -> f.renameTo(new File(this.treatedDir, f.getName() + ".treated")));
    }

    private static Stream<File> sessions(File stage) {
        if (!stage.exists()) {
            return Stream.empty();
        }
        try {
            return FS.allFilesIn((File)stage, f -> f.getName().endsWith(".session") && f.length() > 0L);
        }
        catch (IOException e) {
            Logger.error((String)("Error while listing sessions in " + stage + ": " + e.getMessage()), (Throwable)e);
            return Stream.empty();
        }
    }

    private static Fingerprint fingerprintOf(File file) {
        return Fingerprint.of((File)file);
    }
}

