/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.broker.jms;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.MessageReader;
import jakarta.jms.Message;
import jakarta.jms.MessageNotWriteableException;
import jakarta.jms.TextMessage;
import java.util.Collections;
import java.util.Iterator;
import org.apache.activemq.command.ActiveMQTextMessage;

public class JmsMessageTranslator {
    public static Iterator<io.intino.alexandria.message.Message> toInlMessages(Message message) {
        try {
            return JmsMessageTranslator.readMessages(((TextMessage)message).getText());
        }
        catch (Throwable e) {
            Logger.error((String)e.getMessage(), (Throwable)e);
            return Collections.emptyIterator();
        }
    }

    private static Iterator<io.intino.alexandria.message.Message> readMessages(String text) {
        return new MessageReader(text).iterator();
    }

    public static Message toJmsMessage(String message) {
        ActiveMQTextMessage activeMQTextMessage = new ActiveMQTextMessage();
        try {
            activeMQTextMessage.setText(message);
            return activeMQTextMessage;
        }
        catch (MessageNotWriteableException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }
}

