/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.box.actions;

import io.intino.alexandria.Context;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.jms.TopicProducer;
import io.intino.alexandria.logger.Logger;
import io.intino.datahub.box.DataHubBox;
import io.intino.datahub.box.actions.SealAction;
import io.intino.datahub.broker.jms.JmsMessageTranslator;
import io.intino.datahub.datamart.DatamartFactory;
import io.intino.datahub.datamart.MasterDatamart;
import io.intino.datahub.datamart.impl.LocalMasterDatamart;
import io.intino.datahub.model.Datamart;
import java.util.List;

public class RecreateDatamartAction {
    public DataHubBox box;
    public Context context = new Context();
    public String datamartName;

    public String execute() {
        try {
            return this.datamartName.equalsIgnoreCase("all") ? this.launchAllDatamartsCreation() : this.launchDatamartCreation();
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            return e.getClass().getSimpleName() + ": " + e.getMessage();
        }
    }

    private String launchAllDatamartsCreation() {
        this.executeAsync(this::recreateAll);
        return "Recreation of all datamarts launched (" + this.box.graph().datamartList().size() + "). Check log for more info.";
    }

    private String launchDatamartCreation() {
        Datamart datamart = this.box.graph().datamartList(d -> d.name$().equals(this.datamartName)).findFirst().orElse(null);
        if (datamart == null) {
            return "Datamart " + this.datamartName + " not found";
        }
        this.executeAsync(() -> {
            new SealAction(this.box).execute();
            this.recreate(datamart);
            new Thread(() -> this.notifySubscribers(datamart.name$())).start();
        });
        return "Recreation of datamart " + this.datamartName + " launched. Check log for more info.";
    }

    private void notifySubscribers(String dm) {
        TopicProducer topicProducer = this.box.brokerService().manager().topicProducerOf("service.ness.datamarts");
        topicProducer.produce(JmsMessageTranslator.toJmsMessage("{\"operation\":\"reload\", datamart:\"" + dm + "\"}"));
        topicProducer.close();
    }

    private void recreateAll() {
        new SealAction(this.box).execute();
        List<Datamart> datamartList = this.box.graph().datamartList();
        for (int i = 0; i < datamartList.size(); ++i) {
            Datamart datamart = datamartList.get(i);
            Logger.info((String)("Creating " + datamart.name$() + " (" + (i + 1) + "/" + datamartList.size() + ")..."));
            this.recreate(datamart);
            this.notifySubscribers(datamart.name$());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recreate(Datamart definition) {
        try {
            Class<RecreateDatamartAction> clazz = RecreateDatamartAction.class;
            synchronized (RecreateDatamartAction.class) {
                this.box.brokerService().manager().pauseTankConsumers();
                MasterDatamart datamart = this.box.datamarts().get(this.datamartName);
                if (datamart == null) {
                    datamart = new LocalMasterDatamart(this.box, definition);
                    this.box.datamarts().put(definition.name$(), datamart);
                }
                datamart.clear();
                new DatamartFactory(this.box, (Datalake)this.box.datalake()).reflow(datamart, definition);
                Logger.info((String)("Datamart " + definition.name$() + " recreated!"));
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
        }
        finally {
            this.box.brokerService().manager().startTankConsumers();
        }
        {
            return;
        }
    }

    private void executeAsync(Runnable action) {
        new Thread(action, this.getClass().getSimpleName()).start();
    }
}

