/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.messages.universe;

import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import io.intino.cosmos.datahub.messages.universe.ObservableAssertion;
import java.io.Serializable;
import java.time.Instant;
import java.util.Objects;

public class QueryAssertion
extends ObservableAssertion
implements Serializable {
    public QueryAssertion(String ss, String id) {
        this(new MessageEvent("QueryAssertion", ss).toMessage(), id);
    }

    public QueryAssertion(MessageEvent event) {
        this(event.toMessage());
    }

    public QueryAssertion(Message message) {
        this(message, message.get("id").asString());
    }

    private QueryAssertion(Message message, String id) {
        super(message.set("id", Objects.requireNonNull(id, "Assertion Id cannot be null")));
    }

    @Override
    public String id() {
        return this.message.get("id").asString();
    }

    @Override
    public QueryAssertion ts(Instant ts) {
        super.ts(ts);
        return this;
    }

    @Override
    public QueryAssertion ss(String ss) {
        super.ss(ss);
        return this;
    }

    @Override
    public boolean enabled() {
        return this.message.get("enabled").asOptional(Boolean.TYPE).orElse(true);
    }

    @Override
    public QueryAssertion enabled(boolean enabled) {
        this.message.set("enabled", (Object)enabled);
        return this;
    }

    public static QueryAssertion fromString(String event) {
        return new QueryAssertion(new MessageReader(event).next());
    }

    public String query() {
        return !this.message.contains("query") ? null : this.message.get("query").asString();
    }

    public String hash() {
        return !this.message.contains("hash") ? null : this.message.get("hash").asString();
    }

    public QueryAssertion query(String query) {
        if (query == null) {
            this.message.remove("query");
        } else {
            this.message.set("query", query);
        }
        return this;
    }

    public QueryAssertion hash(String hash) {
        if (hash == null) {
            this.message.remove("hash");
        } else {
            this.message.set("hash", hash);
        }
        return this;
    }

    @Override
    public Message toMessage() {
        return super.toMessage();
    }
}

