/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.messages.universe;

import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import io.intino.cosmos.datahub.messages.universe.ObservableAssertion;
import java.io.Serializable;
import java.time.Instant;
import java.util.Objects;

public class PersonAssertion
extends ObservableAssertion
implements Serializable {
    public PersonAssertion(String ss, String id) {
        this(new MessageEvent("PersonAssertion", ss).toMessage(), id);
    }

    public PersonAssertion(MessageEvent event) {
        this(event.toMessage());
    }

    public PersonAssertion(Message message) {
        this(message, message.get("id").asString());
    }

    private PersonAssertion(Message message, String id) {
        super(message.set("id", Objects.requireNonNull(id, "Assertion Id cannot be null")));
    }

    @Override
    public String id() {
        return this.message.get("id").asString();
    }

    @Override
    public PersonAssertion ts(Instant ts) {
        super.ts(ts);
        return this;
    }

    @Override
    public PersonAssertion ss(String ss) {
        super.ss(ss);
        return this;
    }

    @Override
    public boolean enabled() {
        return this.message.get("enabled").asOptional(Boolean.TYPE).orElse(true);
    }

    @Override
    public PersonAssertion enabled(boolean enabled) {
        this.message.set("enabled", (Object)enabled);
        return this;
    }

    public static PersonAssertion fromString(String event) {
        return new PersonAssertion(new MessageReader(event).next());
    }

    public String area() {
        return !this.message.contains("area") ? null : this.message.get("area").asString();
    }

    public String role() {
        return !this.message.contains("role") ? null : this.message.get("role").asString();
    }

    public String supervisor() {
        return !this.message.contains("supervisor") ? null : this.message.get("supervisor").asString();
    }

    public String email() {
        return !this.message.contains("email") ? null : this.message.get("email").asString();
    }

    public String phone() {
        return !this.message.contains("phone") ? null : this.message.get("phone").asString();
    }

    public PersonAssertion area(String area) {
        if (area == null) {
            this.message.remove("area");
        } else {
            this.message.set("area", area);
        }
        return this;
    }

    public PersonAssertion role(String role) {
        if (role == null) {
            this.message.remove("role");
        } else {
            this.message.set("role", role);
        }
        return this;
    }

    public PersonAssertion supervisor(String supervisor) {
        if (supervisor == null) {
            this.message.remove("supervisor");
        } else {
            this.message.set("supervisor", supervisor);
        }
        return this;
    }

    public PersonAssertion email(String email) {
        if (email == null) {
            this.message.remove("email");
        } else {
            this.message.set("email", email);
        }
        return this;
    }

    public PersonAssertion phone(String phone) {
        if (phone == null) {
            this.message.remove("phone");
        } else {
            this.message.set("phone", phone);
        }
        return this;
    }

    @Override
    public Message toMessage() {
        return super.toMessage();
    }
}

