/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.messages.universe;

import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class OrderTypeAssertion
extends MessageEvent
implements Serializable {
    private List<Assistant> assistantList = null;

    public OrderTypeAssertion(String ss, String id) {
        this(new MessageEvent("OrderTypeAssertion", ss).toMessage(), id);
    }

    public OrderTypeAssertion(MessageEvent event) {
        this(event.toMessage());
    }

    public OrderTypeAssertion(Message message) {
        this(message, message.get("id").asString());
    }

    private OrderTypeAssertion(Message message, String id) {
        super(message.set("id", Objects.requireNonNull(id, "Assertion Id cannot be null")));
    }

    public String id() {
        return this.message.get("id").asString();
    }

    public OrderTypeAssertion ts(Instant ts) {
        super.ts(ts);
        return this;
    }

    public OrderTypeAssertion ss(String ss) {
        super.ss(ss);
        return this;
    }

    public boolean enabled() {
        return this.message.get("enabled").asOptional(Boolean.TYPE).orElse(true);
    }

    public OrderTypeAssertion enabled(boolean enabled) {
        this.message.set("enabled", (Object)enabled);
        return this;
    }

    public static OrderTypeAssertion fromString(String event) {
        return new OrderTypeAssertion(new MessageReader(event).next());
    }

    public String label() {
        return !this.message.contains("label") ? null : this.message.get("label").asString();
    }

    public Integer effort() {
        return this.message.get("effort").asInteger();
    }

    public String target() {
        return !this.message.contains("target") ? null : this.message.get("target").asString();
    }

    public String assertion() {
        return !this.message.contains("assertion") ? null : this.message.get("assertion").asString();
    }

    public String calculations() {
        return !this.message.contains("calculations") ? null : this.message.get("calculations").asString();
    }

    public List<String> input() {
        String[] array = (String[])this.message.get("input").as(String[].class);
        return new ArrayList<String>(array != null ? Arrays.asList(array) : Collections.emptyList()){

            @Override
            public boolean add(String value) {
                super.add(value);
                OrderTypeAssertion.this.message.append("input", value);
                return true;
            }

            @Override
            public void add(int index, String element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object value) {
                if (!(value instanceof String)) {
                    return false;
                }
                super.remove(value);
                OrderTypeAssertion.this.message.remove("input", value);
                return true;
            }

            @Override
            public String remove(int index) {
                String type = (String)this.get(index);
                this.remove(type);
                return type;
            }

            @Override
            public boolean removeIf(Predicate<? super String> filter) {
                return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((String)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                c.forEach(this::remove);
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends String> c) {
                c.forEach(this::add);
                return true;
            }

            @Override
            public boolean addAll(int index, Collection<? extends String> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                super.clear();
                OrderTypeAssertion.this.message.remove("input");
            }
        };
    }

    public List<String> annexes() {
        String[] array = (String[])this.message.get("annexes").as(String[].class);
        return new ArrayList<String>(array != null ? Arrays.asList(array) : Collections.emptyList()){

            @Override
            public boolean add(String value) {
                super.add(value);
                OrderTypeAssertion.this.message.append("annexes", value);
                return true;
            }

            @Override
            public void add(int index, String element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object value) {
                if (!(value instanceof String)) {
                    return false;
                }
                super.remove(value);
                OrderTypeAssertion.this.message.remove("annexes", value);
                return true;
            }

            @Override
            public String remove(int index) {
                String type = (String)this.get(index);
                this.remove(type);
                return type;
            }

            @Override
            public boolean removeIf(Predicate<? super String> filter) {
                return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((String)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                c.forEach(this::remove);
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends String> c) {
                c.forEach(this::add);
                return true;
            }

            @Override
            public boolean addAll(int index, Collection<? extends String> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                super.clear();
                OrderTypeAssertion.this.message.remove("annexes");
            }
        };
    }

    public Assistant assistant() {
        List components = this.message.components("Assistant");
        return components.isEmpty() ? null : new Assistant((Message)components.get(0));
    }

    public OrderTypeAssertion label(String label) {
        if (label == null) {
            this.message.remove("label");
        } else {
            this.message.set("label", label);
        }
        return this;
    }

    public OrderTypeAssertion effort(Integer effort) {
        this.message.set("effort", (Object)effort);
        return this;
    }

    public OrderTypeAssertion target(String target) {
        if (target == null) {
            this.message.remove("target");
        } else {
            this.message.set("target", target);
        }
        return this;
    }

    public OrderTypeAssertion assertion(String assertion) {
        if (assertion == null) {
            this.message.remove("assertion");
        } else {
            this.message.set("assertion", assertion);
        }
        return this;
    }

    public OrderTypeAssertion calculations(String calculations) {
        if (calculations == null) {
            this.message.remove("calculations");
        } else {
            this.message.set("calculations", calculations);
        }
        return this;
    }

    public OrderTypeAssertion input(List<String> input) {
        this.message.set("input", input);
        return this;
    }

    public OrderTypeAssertion annexes(List<String> annexes) {
        this.message.set("annexes", annexes);
        return this;
    }

    public OrderTypeAssertion assistant(Assistant assistant) {
        this.message.components("Assistant").forEach(v -> this.message.remove(v));
        if (assistant != null) {
            this.message.add(assistant.toMessage());
        }
        return this;
    }

    public Message toMessage() {
        return super.toMessage();
    }

    public static class Assistant
    implements Serializable {
        private List<Step> stepList = null;
        protected Message message;

        public Assistant() {
            this.message = new Message("Assistant");
        }

        public Assistant(Message message) {
            this.message = message;
        }

        public List<Step> stepList() {
            if (this.stepList != null) {
                return this.stepList;
            }
            this.stepList = new ArrayList<Step>((Collection)this.message.components("Step").stream().map(c -> new Step((Message)c)).collect(Collectors.toList())){

                @Override
                public boolean add(Step element) {
                    super.add(element);
                    message.add(element.toMessage());
                    return true;
                }

                @Override
                public void add(int index, Step element) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean remove(Object o) {
                    if (!(o instanceof Step)) {
                        return false;
                    }
                    super.remove(o);
                    message.remove(((Step)o).toMessage());
                    return true;
                }

                @Override
                public Step remove(int index) {
                    Step type = (Step)this.get(index);
                    this.remove(type);
                    return type;
                }

                @Override
                public boolean removeIf(Predicate<? super Step> filter) {
                    return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((Step)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
                }

                @Override
                public boolean removeAll(Collection<?> c) {
                    c.forEach(this::remove);
                    return true;
                }

                @Override
                public boolean addAll(Collection<? extends Step> c) {
                    c.forEach(this::add);
                    return true;
                }

                @Override
                public boolean addAll(int index, Collection<? extends Step> c) {
                    throw new UnsupportedOperationException();
                }
            };
            return this.stepList;
        }

        public Assistant stepList(List<Step> step) {
            new ArrayList<Step>(this.stepList()).forEach((Consumer<Step>)((Consumer<Object>)v -> this.stepList.remove(v)));
            this.stepList.addAll(step);
            return this;
        }

        public Message toMessage() {
            return this.message;
        }

        public static class Step
        implements Serializable {
            protected Message message;

            public Step() {
                this.message = new Message("Step");
            }

            public Step(Message message) {
                this.message = message;
            }

            public Type type() {
                return !this.message.contains("type") ? null : Type.valueOf(this.message.get("type").asString());
            }

            public String code() {
                return !this.message.contains("code") ? null : this.message.get("code").asString();
            }

            public String title() {
                return !this.message.contains("title") ? null : this.message.get("title").asString();
            }

            public String description() {
                return !this.message.contains("description") ? null : this.message.get("description").asString();
            }

            public String values() {
                return !this.message.contains("values") ? null : this.message.get("values").asString();
            }

            public String maxValue() {
                return !this.message.contains("maxValue") ? null : this.message.get("maxValue").asString();
            }

            public String minValue() {
                return !this.message.contains("minValue") ? null : this.message.get("minValue").asString();
            }

            public String defaultValue() {
                return !this.message.contains("defaultValue") ? null : this.message.get("defaultValue").asString();
            }

            public Boolean optional() {
                return this.message.get("optional").asBoolean();
            }

            public Step type(Type type) {
                if (type == null) {
                    this.message.remove("type");
                } else {
                    this.message.set("type", type.name());
                }
                return this;
            }

            public Step code(String code) {
                if (code == null) {
                    this.message.remove("code");
                } else {
                    this.message.set("code", code);
                }
                return this;
            }

            public Step title(String title) {
                if (title == null) {
                    this.message.remove("title");
                } else {
                    this.message.set("title", title);
                }
                return this;
            }

            public Step description(String description) {
                if (description == null) {
                    this.message.remove("description");
                } else {
                    this.message.set("description", description);
                }
                return this;
            }

            public Step values(String values) {
                if (values == null) {
                    this.message.remove("values");
                } else {
                    this.message.set("values", values);
                }
                return this;
            }

            public Step maxValue(String maxValue) {
                if (maxValue == null) {
                    this.message.remove("maxValue");
                } else {
                    this.message.set("maxValue", maxValue);
                }
                return this;
            }

            public Step minValue(String minValue) {
                if (minValue == null) {
                    this.message.remove("minValue");
                } else {
                    this.message.set("minValue", minValue);
                }
                return this;
            }

            public Step defaultValue(String defaultValue) {
                if (defaultValue == null) {
                    this.message.remove("defaultValue");
                } else {
                    this.message.set("defaultValue", defaultValue);
                }
                return this;
            }

            public Step optional(Boolean optional) {
                if (optional == null) {
                    this.message.remove("optional");
                } else {
                    this.message.set("optional", (Object)optional);
                }
                return this;
            }

            public Message toMessage() {
                return this.message;
            }

            public static enum Type {
                Section,
                Approval,
                Coordinates,
                Hidden,
                Option,
                Number,
                Date,
                Text,
                Image,
                Note,
                Package,
                Signature;

            }
        }
    }
}

