/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.messages.universe;

import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import io.intino.cosmos.datahub.messages.universe.SoftwareAssertion;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ObserverAssertion
extends SoftwareAssertion
implements Serializable {
    public ObserverAssertion(String ss, String id) {
        this(new MessageEvent("ObserverAssertion", ss).toMessage(), id);
    }

    public ObserverAssertion(MessageEvent event) {
        this(event.toMessage());
    }

    public ObserverAssertion(Message message) {
        this(message, message.get("id").asString());
    }

    private ObserverAssertion(Message message, String id) {
        super(message.set("id", Objects.requireNonNull(id, "Assertion Id cannot be null")));
    }

    @Override
    public String id() {
        return this.message.get("id").asString();
    }

    @Override
    public ObserverAssertion ts(Instant ts) {
        super.ts(ts);
        return this;
    }

    @Override
    public ObserverAssertion ss(String ss) {
        super.ss(ss);
        return this;
    }

    @Override
    public boolean enabled() {
        return this.message.get("enabled").asOptional(Boolean.TYPE).orElse(true);
    }

    @Override
    public ObserverAssertion enabled(boolean enabled) {
        this.message.set("enabled", (Object)enabled);
        return this;
    }

    public static ObserverAssertion fromString(String event) {
        return new ObserverAssertion(new MessageReader(event).next());
    }

    public String version() {
        return !this.message.contains("version") ? null : this.message.get("version").asString();
    }

    public List<String> installedActivities() {
        String[] array = (String[])this.message.get("installedActivities").as(String[].class);
        return new ArrayList<String>(array != null ? Arrays.asList(array) : Collections.emptyList()){

            @Override
            public boolean add(String value) {
                super.add(value);
                ObserverAssertion.this.message.append("installedActivities", value);
                return true;
            }

            @Override
            public void add(int index, String element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object value) {
                if (!(value instanceof String)) {
                    return false;
                }
                super.remove(value);
                ObserverAssertion.this.message.remove("installedActivities", value);
                return true;
            }

            @Override
            public String remove(int index) {
                String type = (String)this.get(index);
                this.remove(type);
                return type;
            }

            @Override
            public boolean removeIf(Predicate<? super String> filter) {
                return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((String)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                c.forEach(this::remove);
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends String> c) {
                c.forEach(this::add);
                return true;
            }

            @Override
            public boolean addAll(int index, Collection<? extends String> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                super.clear();
                ObserverAssertion.this.message.remove("installedActivities");
            }
        };
    }

    public List<String> enabledActivities() {
        String[] array = (String[])this.message.get("enabledActivities").as(String[].class);
        return new ArrayList<String>(array != null ? Arrays.asList(array) : Collections.emptyList()){

            @Override
            public boolean add(String value) {
                super.add(value);
                ObserverAssertion.this.message.append("enabledActivities", value);
                return true;
            }

            @Override
            public void add(int index, String element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object value) {
                if (!(value instanceof String)) {
                    return false;
                }
                super.remove(value);
                ObserverAssertion.this.message.remove("enabledActivities", value);
                return true;
            }

            @Override
            public String remove(int index) {
                String type = (String)this.get(index);
                this.remove(type);
                return type;
            }

            @Override
            public boolean removeIf(Predicate<? super String> filter) {
                return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((String)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                c.forEach(this::remove);
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends String> c) {
                c.forEach(this::add);
                return true;
            }

            @Override
            public boolean addAll(int index, Collection<? extends String> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                super.clear();
                ObserverAssertion.this.message.remove("enabledActivities");
            }
        };
    }

    public ObserverAssertion version(String version) {
        if (version == null) {
            this.message.remove("version");
        } else {
            this.message.set("version", version);
        }
        return this;
    }

    public ObserverAssertion installedActivities(List<String> installedActivities) {
        this.message.set("installedActivities", installedActivities);
        return this;
    }

    public ObserverAssertion enabledActivities(List<String> enabledActivities) {
        this.message.set("enabledActivities", enabledActivities);
        return this;
    }

    @Override
    public Message toMessage() {
        return super.toMessage();
    }
}

