/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.messages.universe;

import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class IncidentRuleAssertion
extends MessageEvent
implements Serializable {
    public IncidentRuleAssertion(String ss, String id) {
        this(new MessageEvent("IncidentRuleAssertion", ss).toMessage(), id);
    }

    public IncidentRuleAssertion(MessageEvent event) {
        this(event.toMessage());
    }

    public IncidentRuleAssertion(Message message) {
        this(message, message.get("id").asString());
    }

    private IncidentRuleAssertion(Message message, String id) {
        super(message.set("id", Objects.requireNonNull(id, "Assertion Id cannot be null")));
    }

    public String id() {
        return this.message.get("id").asString();
    }

    public IncidentRuleAssertion ts(Instant ts) {
        super.ts(ts);
        return this;
    }

    public IncidentRuleAssertion ss(String ss) {
        super.ss(ss);
        return this;
    }

    public boolean enabled() {
        return this.message.get("enabled").asOptional(Boolean.TYPE).orElse(true);
    }

    public IncidentRuleAssertion enabled(boolean enabled) {
        this.message.set("enabled", (Object)enabled);
        return this;
    }

    public static IncidentRuleAssertion fromString(String event) {
        return new IncidentRuleAssertion(new MessageReader(event).next());
    }

    public String target() {
        return !this.message.contains("target") ? null : this.message.get("target").asString();
    }

    public String model() {
        return !this.message.contains("model") ? null : this.message.get("model").asString();
    }

    public String precondition() {
        return !this.message.contains("precondition") ? null : this.message.get("precondition").asString();
    }

    public String condition() {
        return !this.message.contains("condition") ? null : this.message.get("condition").asString();
    }

    public String dismissCondition() {
        return !this.message.contains("dismissCondition") ? null : this.message.get("dismissCondition").asString();
    }

    public String tracking() {
        return !this.message.contains("tracking") ? null : this.message.get("tracking").asString();
    }

    public Level level() {
        return !this.message.contains("level") ? null : Level.valueOf(this.message.get("level").asString());
    }

    public String description() {
        return !this.message.contains("description") ? null : this.message.get("description").asString();
    }

    public List<String> triggers() {
        String[] array = (String[])this.message.get("triggers").as(String[].class);
        return new ArrayList<String>(array != null ? Arrays.asList(array) : Collections.emptyList()){

            @Override
            public boolean add(String value) {
                super.add(value);
                IncidentRuleAssertion.this.message.append("triggers", value);
                return true;
            }

            @Override
            public void add(int index, String element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object value) {
                if (!(value instanceof String)) {
                    return false;
                }
                super.remove(value);
                IncidentRuleAssertion.this.message.remove("triggers", value);
                return true;
            }

            @Override
            public String remove(int index) {
                String type = (String)this.get(index);
                this.remove(type);
                return type;
            }

            @Override
            public boolean removeIf(Predicate<? super String> filter) {
                return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((String)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                c.forEach(this::remove);
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends String> c) {
                c.forEach(this::add);
                return true;
            }

            @Override
            public boolean addAll(int index, Collection<? extends String> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                super.clear();
                IncidentRuleAssertion.this.message.remove("triggers");
            }
        };
    }

    public IncidentRuleAssertion target(String target) {
        if (target == null) {
            this.message.remove("target");
        } else {
            this.message.set("target", target);
        }
        return this;
    }

    public IncidentRuleAssertion model(String model) {
        if (model == null) {
            this.message.remove("model");
        } else {
            this.message.set("model", model);
        }
        return this;
    }

    public IncidentRuleAssertion precondition(String precondition) {
        if (precondition == null) {
            this.message.remove("precondition");
        } else {
            this.message.set("precondition", precondition);
        }
        return this;
    }

    public IncidentRuleAssertion condition(String condition) {
        if (condition == null) {
            this.message.remove("condition");
        } else {
            this.message.set("condition", condition);
        }
        return this;
    }

    public IncidentRuleAssertion dismissCondition(String dismissCondition) {
        if (dismissCondition == null) {
            this.message.remove("dismissCondition");
        } else {
            this.message.set("dismissCondition", dismissCondition);
        }
        return this;
    }

    public IncidentRuleAssertion tracking(String tracking) {
        if (tracking == null) {
            this.message.remove("tracking");
        } else {
            this.message.set("tracking", tracking);
        }
        return this;
    }

    public IncidentRuleAssertion level(Level level) {
        if (level == null) {
            this.message.remove("level");
        } else {
            this.message.set("level", level.name());
        }
        return this;
    }

    public IncidentRuleAssertion description(String description) {
        if (description == null) {
            this.message.remove("description");
        } else {
            this.message.set("description", description);
        }
        return this;
    }

    public IncidentRuleAssertion triggers(List<String> triggers) {
        this.message.set("triggers", triggers);
        return this;
    }

    public Message toMessage() {
        return super.toMessage();
    }

    public static enum Level {
        Low,
        Medium,
        High;

    }
}

