/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.messages.universe;

import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class BusinessUnitAssertion
extends MessageEvent
implements Serializable {
    public BusinessUnitAssertion(String ss, String id) {
        this(new MessageEvent("BusinessUnitAssertion", ss).toMessage(), id);
    }

    public BusinessUnitAssertion(MessageEvent event) {
        this(event.toMessage());
    }

    public BusinessUnitAssertion(Message message) {
        this(message, message.get("id").asString());
    }

    private BusinessUnitAssertion(Message message, String id) {
        super(message.set("id", Objects.requireNonNull(id, "Assertion Id cannot be null")));
    }

    public String id() {
        return this.message.get("id").asString();
    }

    public BusinessUnitAssertion ts(Instant ts) {
        super.ts(ts);
        return this;
    }

    public BusinessUnitAssertion ss(String ss) {
        super.ss(ss);
        return this;
    }

    public boolean enabled() {
        return this.message.get("enabled").asOptional(Boolean.TYPE).orElse(true);
    }

    public BusinessUnitAssertion enabled(boolean enabled) {
        this.message.set("enabled", (Object)enabled);
        return this;
    }

    public static BusinessUnitAssertion fromString(String event) {
        return new BusinessUnitAssertion(new MessageReader(event).next());
    }

    public String label() {
        return !this.message.contains("label") ? null : this.message.get("label").asString();
    }

    public List<String> domains() {
        String[] array = (String[])this.message.get("domains").as(String[].class);
        return new ArrayList<String>(array != null ? Arrays.asList(array) : Collections.emptyList()){

            @Override
            public boolean add(String value) {
                super.add(value);
                BusinessUnitAssertion.this.message.append("domains", value);
                return true;
            }

            @Override
            public void add(int index, String element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object value) {
                if (!(value instanceof String)) {
                    return false;
                }
                super.remove(value);
                BusinessUnitAssertion.this.message.remove("domains", value);
                return true;
            }

            @Override
            public String remove(int index) {
                String type = (String)this.get(index);
                this.remove(type);
                return type;
            }

            @Override
            public boolean removeIf(Predicate<? super String> filter) {
                return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((String)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                c.forEach(this::remove);
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends String> c) {
                c.forEach(this::add);
                return true;
            }

            @Override
            public boolean addAll(int index, Collection<? extends String> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                super.clear();
                BusinessUnitAssertion.this.message.remove("domains");
            }
        };
    }

    public BusinessUnitAssertion label(String label) {
        if (label == null) {
            this.message.remove("label");
        } else {
            this.message.set("label", label);
        }
        return this;
    }

    public BusinessUnitAssertion domains(List<String> domains) {
        this.message.set("domains", domains);
        return this;
    }

    public Message toMessage() {
        return super.toMessage();
    }
}

