/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.messages.universe;

import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import io.intino.cosmos.datahub.messages.universe.ApplicationAssertion;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ApplicationJavaAssertion
extends ApplicationAssertion
implements Serializable {
    public ApplicationJavaAssertion(String ss, String id) {
        this(new MessageEvent("ApplicationJavaAssertion", ss).toMessage(), id);
    }

    public ApplicationJavaAssertion(MessageEvent event) {
        this(event.toMessage());
    }

    public ApplicationJavaAssertion(Message message) {
        this(message, message.get("id").asString());
    }

    private ApplicationJavaAssertion(Message message, String id) {
        super(message.set("id", Objects.requireNonNull(id, "Assertion Id cannot be null")));
    }

    @Override
    public String id() {
        return this.message.get("id").asString();
    }

    @Override
    public ApplicationJavaAssertion ts(Instant ts) {
        super.ts(ts);
        return this;
    }

    @Override
    public ApplicationJavaAssertion ss(String ss) {
        super.ss(ss);
        return this;
    }

    @Override
    public boolean enabled() {
        return this.message.get("enabled").asOptional(Boolean.TYPE).orElse(true);
    }

    @Override
    public ApplicationJavaAssertion enabled(boolean enabled) {
        this.message.set("enabled", (Object)enabled);
        return this;
    }

    public static ApplicationJavaAssertion fromString(String event) {
        return new ApplicationJavaAssertion(new MessageReader(event).next());
    }

    public String groupId() {
        return !this.message.contains("groupId") ? null : this.message.get("groupId").asString();
    }

    public String artifactId() {
        return !this.message.contains("artifactId") ? null : this.message.get("artifactId").asString();
    }

    public String version() {
        return !this.message.contains("version") ? null : this.message.get("version").asString();
    }

    public String classpathPrefix() {
        return !this.message.contains("classpathPrefix") ? null : this.message.get("classpathPrefix").asString();
    }

    public String mainArtifact() {
        return !this.message.contains("mainArtifact") ? null : this.message.get("mainArtifact").asString();
    }

    public Integer debugPort() {
        return this.message.get("debugPort").asInteger();
    }

    public Integer jmxPort() {
        return this.message.get("jmxPort").asInteger();
    }

    public Integer minMemory() {
        return this.message.get("minMemory").asInteger();
    }

    public Integer maxMemory() {
        return this.message.get("maxMemory").asInteger();
    }

    public List<String> classpath() {
        String[] array = (String[])this.message.get("classpath").as(String[].class);
        return new ArrayList<String>(array != null ? Arrays.asList(array) : Collections.emptyList()){

            @Override
            public boolean add(String value) {
                super.add(value);
                ApplicationJavaAssertion.this.message.append("classpath", value);
                return true;
            }

            @Override
            public void add(int index, String element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object value) {
                if (!(value instanceof String)) {
                    return false;
                }
                super.remove(value);
                ApplicationJavaAssertion.this.message.remove("classpath", value);
                return true;
            }

            @Override
            public String remove(int index) {
                String type = (String)this.get(index);
                this.remove(type);
                return type;
            }

            @Override
            public boolean removeIf(Predicate<? super String> filter) {
                return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((String)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                c.forEach(this::remove);
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends String> c) {
                c.forEach(this::add);
                return true;
            }

            @Override
            public boolean addAll(int index, Collection<? extends String> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                super.clear();
                ApplicationJavaAssertion.this.message.remove("classpath");
            }
        };
    }

    public List<String> inputArguments() {
        String[] array = (String[])this.message.get("inputArguments").as(String[].class);
        return new ArrayList<String>(array != null ? Arrays.asList(array) : Collections.emptyList()){

            @Override
            public boolean add(String value) {
                super.add(value);
                ApplicationJavaAssertion.this.message.append("inputArguments", value);
                return true;
            }

            @Override
            public void add(int index, String element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object value) {
                if (!(value instanceof String)) {
                    return false;
                }
                super.remove(value);
                ApplicationJavaAssertion.this.message.remove("inputArguments", value);
                return true;
            }

            @Override
            public String remove(int index) {
                String type = (String)this.get(index);
                this.remove(type);
                return type;
            }

            @Override
            public boolean removeIf(Predicate<? super String> filter) {
                return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((String)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                c.forEach(this::remove);
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends String> c) {
                c.forEach(this::add);
                return true;
            }

            @Override
            public boolean addAll(int index, Collection<? extends String> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                super.clear();
                ApplicationJavaAssertion.this.message.remove("inputArguments");
            }
        };
    }

    public List<String> jvmParameter() {
        String[] array = (String[])this.message.get("jvmParameter").as(String[].class);
        return new ArrayList<String>(array != null ? Arrays.asList(array) : Collections.emptyList()){

            @Override
            public boolean add(String value) {
                super.add(value);
                ApplicationJavaAssertion.this.message.append("jvmParameter", value);
                return true;
            }

            @Override
            public void add(int index, String element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object value) {
                if (!(value instanceof String)) {
                    return false;
                }
                super.remove(value);
                ApplicationJavaAssertion.this.message.remove("jvmParameter", value);
                return true;
            }

            @Override
            public String remove(int index) {
                String type = (String)this.get(index);
                this.remove(type);
                return type;
            }

            @Override
            public boolean removeIf(Predicate<? super String> filter) {
                return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((String)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                c.forEach(this::remove);
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends String> c) {
                c.forEach(this::add);
                return true;
            }

            @Override
            public boolean addAll(int index, Collection<? extends String> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                super.clear();
                ApplicationJavaAssertion.this.message.remove("jvmParameter");
            }
        };
    }

    public String jvmVersion() {
        return !this.message.contains("jvmVersion") ? null : this.message.get("jvmVersion").asString();
    }

    public ApplicationJavaAssertion groupId(String groupId) {
        if (groupId == null) {
            this.message.remove("groupId");
        } else {
            this.message.set("groupId", groupId);
        }
        return this;
    }

    public ApplicationJavaAssertion artifactId(String artifactId) {
        if (artifactId == null) {
            this.message.remove("artifactId");
        } else {
            this.message.set("artifactId", artifactId);
        }
        return this;
    }

    public ApplicationJavaAssertion version(String version) {
        if (version == null) {
            this.message.remove("version");
        } else {
            this.message.set("version", version);
        }
        return this;
    }

    public ApplicationJavaAssertion classpathPrefix(String classpathPrefix) {
        if (classpathPrefix == null) {
            this.message.remove("classpathPrefix");
        } else {
            this.message.set("classpathPrefix", classpathPrefix);
        }
        return this;
    }

    public ApplicationJavaAssertion mainArtifact(String mainArtifact) {
        if (mainArtifact == null) {
            this.message.remove("mainArtifact");
        } else {
            this.message.set("mainArtifact", mainArtifact);
        }
        return this;
    }

    public ApplicationJavaAssertion debugPort(Integer debugPort) {
        this.message.set("debugPort", (Object)debugPort);
        return this;
    }

    public ApplicationJavaAssertion jmxPort(Integer jmxPort) {
        this.message.set("jmxPort", (Object)jmxPort);
        return this;
    }

    public ApplicationJavaAssertion minMemory(Integer minMemory) {
        this.message.set("minMemory", (Object)minMemory);
        return this;
    }

    public ApplicationJavaAssertion maxMemory(Integer maxMemory) {
        this.message.set("maxMemory", (Object)maxMemory);
        return this;
    }

    public ApplicationJavaAssertion classpath(List<String> classpath) {
        this.message.set("classpath", classpath);
        return this;
    }

    public ApplicationJavaAssertion inputArguments(List<String> inputArguments) {
        this.message.set("inputArguments", inputArguments);
        return this;
    }

    public ApplicationJavaAssertion jvmParameter(List<String> jvmParameter) {
        this.message.set("jvmParameter", jvmParameter);
        return this;
    }

    public ApplicationJavaAssertion jvmVersion(String jvmVersion) {
        if (jvmVersion == null) {
            this.message.remove("jvmVersion");
        } else {
            this.message.set("jvmVersion", jvmVersion);
        }
        return this;
    }

    @Override
    public Message toMessage() {
        return super.toMessage();
    }
}

