/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.messages.staff;

import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import java.io.Serializable;
import java.time.Instant;
import java.util.List;
import java.util.Objects;

public class Login
extends MessageEvent
implements Serializable {
    private List<DeviceInfo> deviceInfoList = null;

    public Login(String ss) {
        this(new MessageEvent("Login", ss).toMessage());
    }

    public Login(MessageEvent event) {
        this(event.toMessage());
    }

    public Login(Message message) {
        super(message);
    }

    private Login(Message message, String id) {
        super(message.set("id", Objects.requireNonNull(id, "Assertion Id cannot be null")));
    }

    public Login ts(Instant ts) {
        super.ts(ts);
        return this;
    }

    public Login ss(String ss) {
        super.ss(ss);
        return this;
    }

    public static Login fromString(String event) {
        return new Login(new MessageReader(event).next());
    }

    public String user() {
        return !this.message.contains("user") ? null : this.message.get("user").asString();
    }

    public String accessToken() {
        return !this.message.contains("accessToken") ? null : this.message.get("accessToken").asString();
    }

    public String refreshToken() {
        return !this.message.contains("refreshToken") ? null : this.message.get("refreshToken").asString();
    }

    public String deviceId() {
        return !this.message.contains("deviceId") ? null : this.message.get("deviceId").asString();
    }

    public Instant expiresAt() {
        return !this.message.contains("expiresAt") ? null : this.message.get("expiresAt").asInstant();
    }

    public DeviceInfo deviceInfo() {
        List components = this.message.components("DeviceInfo");
        return components.isEmpty() ? null : new DeviceInfo((Message)components.get(0));
    }

    public Login user(String user) {
        if (user == null) {
            this.message.remove("user");
        } else {
            this.message.set("user", user);
        }
        return this;
    }

    public Login accessToken(String accessToken) {
        if (accessToken == null) {
            this.message.remove("accessToken");
        } else {
            this.message.set("accessToken", accessToken);
        }
        return this;
    }

    public Login refreshToken(String refreshToken) {
        if (refreshToken == null) {
            this.message.remove("refreshToken");
        } else {
            this.message.set("refreshToken", refreshToken);
        }
        return this;
    }

    public Login deviceId(String deviceId) {
        if (deviceId == null) {
            this.message.remove("deviceId");
        } else {
            this.message.set("deviceId", deviceId);
        }
        return this;
    }

    public Login expiresAt(Instant expiresAt) {
        if (expiresAt == null) {
            this.message.remove("expiresAt");
        } else {
            this.message.set("expiresAt", (Object)expiresAt);
        }
        return this;
    }

    public Login deviceInfo(DeviceInfo deviceInfo) {
        this.message.components("DeviceInfo").forEach(v -> this.message.remove(v));
        if (deviceInfo != null) {
            this.message.add(deviceInfo.toMessage());
        }
        return this;
    }

    public Message toMessage() {
        return super.toMessage();
    }

    public static class DeviceInfo
    implements Serializable {
        protected Message message;

        public DeviceInfo() {
            this.message = new Message("DeviceInfo");
        }

        public DeviceInfo(Message message) {
            this.message = message;
        }

        public String brand() {
            return !this.message.contains("brand") ? null : this.message.get("brand").asString();
        }

        public String model() {
            return !this.message.contains("model") ? null : this.message.get("model").asString();
        }

        public String os() {
            return !this.message.contains("os") ? null : this.message.get("os").asString();
        }

        public Boolean hmsPushKit() {
            return this.message.get("hmsPushKit").asBoolean();
        }

        public String appVersion() {
            return !this.message.contains("appVersion") ? null : this.message.get("appVersion").asString();
        }

        public DeviceInfo brand(String brand) {
            if (brand == null) {
                this.message.remove("brand");
            } else {
                this.message.set("brand", brand);
            }
            return this;
        }

        public DeviceInfo model(String model) {
            if (model == null) {
                this.message.remove("model");
            } else {
                this.message.set("model", model);
            }
            return this;
        }

        public DeviceInfo os(String os) {
            if (os == null) {
                this.message.remove("os");
            } else {
                this.message.set("os", os);
            }
            return this;
        }

        public DeviceInfo hmsPushKit(Boolean hmsPushKit) {
            if (hmsPushKit == null) {
                this.message.remove("hmsPushKit");
            } else {
                this.message.set("hmsPushKit", (Object)hmsPushKit);
            }
            return this;
        }

        public DeviceInfo appVersion(String appVersion) {
            if (appVersion == null) {
                this.message.remove("appVersion");
            } else {
                this.message.set("appVersion", appVersion);
            }
            return this;
        }

        public Message toMessage() {
            return this.message;
        }
    }
}

