/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.messages.staff;

import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import java.io.Serializable;
import java.time.Instant;
import java.util.Objects;

public class EmailSubscription
extends MessageEvent
implements Serializable {
    public EmailSubscription(String ss) {
        this(new MessageEvent("EmailSubscription", ss).toMessage());
    }

    public EmailSubscription(MessageEvent event) {
        this(event.toMessage());
    }

    public EmailSubscription(Message message) {
        super(message);
    }

    private EmailSubscription(Message message, String id) {
        super(message.set("id", Objects.requireNonNull(id, "Assertion Id cannot be null")));
    }

    public EmailSubscription ts(Instant ts) {
        super.ts(ts);
        return this;
    }

    public EmailSubscription ss(String ss) {
        super.ss(ss);
        return this;
    }

    public static EmailSubscription fromString(String event) {
        return new EmailSubscription(new MessageReader(event).next());
    }

    public String recipient() {
        return !this.message.contains("recipient") ? null : this.message.get("recipient").asString();
    }

    public String emailSignature() {
        return !this.message.contains("emailSignature") ? null : this.message.get("emailSignature").asString();
    }

    public Action action() {
        return !this.message.contains("action") ? null : Action.valueOf(this.message.get("action").asString());
    }

    public EmailSubscription recipient(String recipient) {
        if (recipient == null) {
            this.message.remove("recipient");
        } else {
            this.message.set("recipient", recipient);
        }
        return this;
    }

    public EmailSubscription emailSignature(String emailSignature) {
        if (emailSignature == null) {
            this.message.remove("emailSignature");
        } else {
            this.message.set("emailSignature", emailSignature);
        }
        return this;
    }

    public EmailSubscription action(Action action) {
        if (action == null) {
            this.message.remove("action");
        } else {
            this.message.set("action", action.name());
        }
        return this;
    }

    public Message toMessage() {
        return super.toMessage();
    }

    public static enum Action {
        Add,
        Remove;

    }
}

