/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.messages.actuation;

import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Inform
extends MessageEvent
implements Serializable {
    private List<Predicate> predicateList = null;

    public Inform(String ss) {
        this(new MessageEvent("Inform", ss).toMessage());
    }

    public Inform(MessageEvent event) {
        this(event.toMessage());
    }

    public Inform(Message message) {
        super(message);
    }

    private Inform(Message message, String id) {
        super(message.set("id", Objects.requireNonNull(id, "Assertion Id cannot be null")));
    }

    public Inform ts(Instant ts) {
        super.ts(ts);
        return this;
    }

    public Inform ss(String ss) {
        super.ss(ss);
        return this;
    }

    public static Inform fromString(String event) {
        return new Inform(new MessageReader(event).next());
    }

    public String order() {
        return !this.message.contains("order") ? null : this.message.get("order").asString();
    }

    public String observable() {
        return !this.message.contains("observable") ? null : this.message.get("observable").asString();
    }

    public List<Predicate> predicateList() {
        if (this.predicateList != null) {
            return this.predicateList;
        }
        this.predicateList = new ArrayList<Predicate>((Collection)this.message.components("Predicate").stream().map(c -> new Predicate((Message)c)).collect(Collectors.toList())){

            @Override
            public boolean add(Predicate element) {
                super.add(element);
                Inform.this.message.add(element.toMessage());
                return true;
            }

            @Override
            public void add(int index, Predicate element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Predicate)) {
                    return false;
                }
                super.remove(o);
                Inform.this.message.remove(((Predicate)o).toMessage());
                return true;
            }

            @Override
            public Predicate remove(int index) {
                Predicate type = (Predicate)this.get(index);
                this.remove(type);
                return type;
            }

            @Override
            public boolean removeIf(java.util.function.Predicate<? super Predicate> filter) {
                return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((Predicate)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                c.forEach(this::remove);
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends Predicate> c) {
                c.forEach(this::add);
                return true;
            }

            @Override
            public boolean addAll(int index, Collection<? extends Predicate> c) {
                throw new UnsupportedOperationException();
            }
        };
        return this.predicateList;
    }

    public Inform order(String order) {
        if (order == null) {
            this.message.remove("order");
        } else {
            this.message.set("order", order);
        }
        return this;
    }

    public Inform observable(String observable) {
        if (observable == null) {
            this.message.remove("observable");
        } else {
            this.message.set("observable", observable);
        }
        return this;
    }

    public Inform predicateList(List<Predicate> predicate) {
        new ArrayList<Predicate>(this.predicateList()).forEach((Consumer<Predicate>)((Consumer<Object>)v -> this.predicateList.remove(v)));
        this.predicateList.addAll(predicate);
        return this;
    }

    public Message toMessage() {
        return super.toMessage();
    }

    public static class Predicate
    implements Serializable {
        protected Message message;

        public Predicate() {
            this.message = new Message("Predicate");
        }

        public Predicate(Message message) {
            this.message = message;
        }

        public String action() {
            return !this.message.contains("action") ? null : this.message.get("action").asString();
        }

        public String object() {
            return !this.message.contains("object") ? null : this.message.get("object").asString();
        }

        public Predicate action(String action) {
            if (action == null) {
                this.message.remove("action");
            } else {
                this.message.set("action", action);
            }
            return this;
        }

        public Predicate object(String object) {
            if (object == null) {
                this.message.remove("object");
            } else {
                this.message.set("object", object);
            }
            return this;
        }

        public Message toMessage() {
            return this.message;
        }
    }
}

