/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.messages.actuation;

import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Assertion
extends MessageEvent
implements Serializable {
    private List<Attribute> attributeList = null;

    public Assertion(String ss) {
        this(new MessageEvent("Assertion", ss).toMessage());
    }

    public Assertion(MessageEvent event) {
        this(event.toMessage());
    }

    public Assertion(Message message) {
        super(message);
    }

    private Assertion(Message message, String id) {
        super(message.set("id", Objects.requireNonNull(id, "Assertion Id cannot be null")));
    }

    public Assertion ts(Instant ts) {
        super.ts(ts);
        return this;
    }

    public Assertion ss(String ss) {
        super.ss(ss);
        return this;
    }

    public static Assertion fromString(String event) {
        return new Assertion(new MessageReader(event).next());
    }

    public String code() {
        return !this.message.contains("code") ? null : this.message.get("code").asString();
    }

    public String observable() {
        return !this.message.contains("observable") ? null : this.message.get("observable").asString();
    }

    public List<Attribute> attributeList() {
        if (this.attributeList != null) {
            return this.attributeList;
        }
        this.attributeList = new ArrayList<Attribute>((Collection)this.message.components("Attribute").stream().map(c -> new Attribute((Message)c)).collect(Collectors.toList())){

            @Override
            public boolean add(Attribute element) {
                super.add(element);
                Assertion.this.message.add(element.toMessage());
                return true;
            }

            @Override
            public void add(int index, Attribute element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Attribute)) {
                    return false;
                }
                super.remove(o);
                Assertion.this.message.remove(((Attribute)o).toMessage());
                return true;
            }

            @Override
            public Attribute remove(int index) {
                Attribute type = (Attribute)this.get(index);
                this.remove(type);
                return type;
            }

            @Override
            public boolean removeIf(Predicate<? super Attribute> filter) {
                return this.removeAll(IntStream.range(0, this.size()).filter(i -> filter.test((Attribute)this.get(i))).mapToObj(this::get).collect(Collectors.toList()));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                c.forEach(this::remove);
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends Attribute> c) {
                c.forEach(this::add);
                return true;
            }

            @Override
            public boolean addAll(int index, Collection<? extends Attribute> c) {
                throw new UnsupportedOperationException();
            }
        };
        return this.attributeList;
    }

    public Assertion code(String code) {
        if (code == null) {
            this.message.remove("code");
        } else {
            this.message.set("code", code);
        }
        return this;
    }

    public Assertion observable(String observable) {
        if (observable == null) {
            this.message.remove("observable");
        } else {
            this.message.set("observable", observable);
        }
        return this;
    }

    public Assertion attributeList(List<Attribute> attribute) {
        new ArrayList<Attribute>(this.attributeList()).forEach((Consumer<Attribute>)((Consumer<Object>)v -> this.attributeList.remove(v)));
        this.attributeList.addAll(attribute);
        return this;
    }

    public Message toMessage() {
        return super.toMessage();
    }

    public static class Attribute
    implements Serializable {
        protected Message message;

        public Attribute() {
            this.message = new Message("Attribute");
        }

        public Attribute(Message message) {
            this.message = message;
        }

        public String name() {
            return !this.message.contains("name") ? null : this.message.get("name").asString();
        }

        public String value() {
            return !this.message.contains("value") ? null : this.message.get("value").asString();
        }

        public Attribute name(String name) {
            if (name == null) {
                this.message.remove("name");
            } else {
                this.message.set("name", name);
            }
            return this;
        }

        public Attribute value(String value) {
            if (value == null) {
                this.message.remove("value");
            } else {
                this.message.set("value", value);
            }
            return this;
        }

        public Message toMessage() {
            return this.message;
        }
    }
}

