/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.measurements.monitoring;

import io.intino.alexandria.event.measurement.MeasurementEvent;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;

public class Switch
extends MeasurementEvent
implements Serializable {
    private static final String[] declaredMagnitudes = new String[]{"data.received;" + String.join((CharSequence)";", "unit=MB", "format=%,.0f", "operator=sum", "tail=UP"), "data.sent;" + String.join((CharSequence)";", "unit=MB", "format=%,.0f", "operator=sum", "tail=UP"), "usage.ports;" + String.join((CharSequence)";", "format=%d", "operator=last", "tail=UP", "distribution=Normal"), "clients;" + String.join((CharSequence)";", "format=%d", "operator=last", "tail=UP", "distribution=Normal")};

    public Switch(String ss) {
        super("Switch", ss, Instant.now(), declaredMagnitudes, new double[4]);
    }

    public Switch(String ss, String sensor) {
        super("Switch", ss + "?sensor=" + sensor, Instant.now(), declaredMagnitudes, new double[4]);
    }

    public Switch(String ss, String sensor, Instant ts) {
        super("Switch", ss + "?sensor=" + sensor, ts, declaredMagnitudes, new double[4]);
    }

    public Switch(MeasurementEvent event) {
        super("Switch", event.ss(), event.ts(), event.magnitudes(), event.values());
    }

    public Switch(Message message) {
        super("Switch", message.get("ss").asString(), message.get("ts").asInstant(), (String[])message.get("magnitudes").as(String[].class), Arrays.stream((String[])message.get("values").as(String[].class)).mapToDouble(Double::parseDouble).toArray());
    }

    public double dataReceived() {
        return this.values[0];
    }

    public double dataSent() {
        return this.values[1];
    }

    public double usagePorts() {
        return this.values[2];
    }

    public double clients() {
        return this.values[3];
    }

    public Switch dataReceived(double value) {
        this.values[0] = value;
        return this;
    }

    public Switch dataSent(double value) {
        this.values[1] = value;
        return this;
    }

    public Switch usagePorts(double value) {
        this.values[2] = value;
        return this;
    }

    public Switch clients(double value) {
        this.values[3] = value;
        return this;
    }

    public MessageEvent toMessageEvent() {
        Message message = new Message(this.getClass().getSimpleName());
        message.set("ts", (Object)this.ts);
        message.set("ss", this.source);
        Arrays.stream(this.magnitudes).forEach(m -> message.append("magnitudes", m.toString()));
        Arrays.stream(this.values).forEach(m -> message.append("values", (Object)m));
        return new MessageEvent(message);
    }
}

