/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.measurements.monitoring;

import io.intino.alexandria.event.measurement.MeasurementEvent;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;

public class RdbmsStatement
extends MeasurementEvent
implements Serializable {
    private static final String[] declaredMagnitudes = new String[]{"usage.executions;" + String.join((CharSequence)";", "format=%,.0f", "tail=UP", "distribution=Normal"), "usage.logical.reads;" + String.join((CharSequence)";", "format=%,.0f", "tail=UP", "distribution=Normal"), "usage.logical.writes;" + String.join((CharSequence)";", "format=%,.0f", "tail=UP", "distribution=Normal"), "time.CPU;" + String.join((CharSequence)";", "unit=seconds", "format=%,.0f", "tail=UP", "distribution=Normal"), "time.elapsed;" + String.join((CharSequence)";", "unit=seconds", "tail=UP", "format=%,.0f")};

    public RdbmsStatement(String ss) {
        super("RdbmsStatement", ss, Instant.now(), declaredMagnitudes, new double[5]);
    }

    public RdbmsStatement(String ss, String sensor) {
        super("RdbmsStatement", ss + "?sensor=" + sensor, Instant.now(), declaredMagnitudes, new double[5]);
    }

    public RdbmsStatement(String ss, String sensor, Instant ts) {
        super("RdbmsStatement", ss + "?sensor=" + sensor, ts, declaredMagnitudes, new double[5]);
    }

    public RdbmsStatement(MeasurementEvent event) {
        super("RdbmsStatement", event.ss(), event.ts(), event.magnitudes(), event.values());
    }

    public RdbmsStatement(Message message) {
        super("RdbmsStatement", message.get("ss").asString(), message.get("ts").asInstant(), (String[])message.get("magnitudes").as(String[].class), Arrays.stream((String[])message.get("values").as(String[].class)).mapToDouble(Double::parseDouble).toArray());
    }

    public double usageExecutions() {
        return this.values[0];
    }

    public double usageLogicalReads() {
        return this.values[1];
    }

    public double usageLogicalWrites() {
        return this.values[2];
    }

    public double timeCPU() {
        return this.values[3];
    }

    public double timeElapsed() {
        return this.values[4];
    }

    public RdbmsStatement usageExecutions(double value) {
        this.values[0] = value;
        return this;
    }

    public RdbmsStatement usageLogicalReads(double value) {
        this.values[1] = value;
        return this;
    }

    public RdbmsStatement usageLogicalWrites(double value) {
        this.values[2] = value;
        return this;
    }

    public RdbmsStatement timeCPU(double value) {
        this.values[3] = value;
        return this;
    }

    public RdbmsStatement timeElapsed(double value) {
        this.values[4] = value;
        return this;
    }

    public MessageEvent toMessageEvent() {
        Message message = new Message(this.getClass().getSimpleName());
        message.set("ts", (Object)this.ts);
        message.set("ss", this.source);
        Arrays.stream(this.magnitudes).forEach(m -> message.append("magnitudes", m.toString()));
        Arrays.stream(this.values).forEach(m -> message.append("values", (Object)m));
        return new MessageEvent(message);
    }
}

