/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.measurements.monitoring;

import io.intino.alexandria.event.measurement.MeasurementEvent;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;

public class CellularGateway
extends MeasurementEvent
implements Serializable {
    private static final String[] declaredMagnitudes = new String[]{"power;" + String.join((CharSequence)";", "format=%.1f", "operator=avg", "tail=DOWN", "distribution=Normal"), "quality;" + String.join((CharSequence)";", "format=%.1f", "operator=avg", "tail=DOWN", "distribution=Normal")};

    public CellularGateway(String ss) {
        super("CellularGateway", ss, Instant.now(), declaredMagnitudes, new double[2]);
    }

    public CellularGateway(String ss, String sensor) {
        super("CellularGateway", ss + "?sensor=" + sensor, Instant.now(), declaredMagnitudes, new double[2]);
    }

    public CellularGateway(String ss, String sensor, Instant ts) {
        super("CellularGateway", ss + "?sensor=" + sensor, ts, declaredMagnitudes, new double[2]);
    }

    public CellularGateway(MeasurementEvent event) {
        super("CellularGateway", event.ss(), event.ts(), event.magnitudes(), event.values());
    }

    public CellularGateway(Message message) {
        super("CellularGateway", message.get("ss").asString(), message.get("ts").asInstant(), (String[])message.get("magnitudes").as(String[].class), Arrays.stream((String[])message.get("values").as(String[].class)).mapToDouble(Double::parseDouble).toArray());
    }

    public double power() {
        return this.values[0];
    }

    public double quality() {
        return this.values[1];
    }

    public CellularGateway power(double value) {
        this.values[0] = value;
        return this;
    }

    public CellularGateway quality(double value) {
        this.values[1] = value;
        return this;
    }

    public MessageEvent toMessageEvent() {
        Message message = new Message(this.getClass().getSimpleName());
        message.set("ts", (Object)this.ts);
        message.set("ss", this.source);
        Arrays.stream(this.magnitudes).forEach(m -> message.append("magnitudes", m.toString()));
        Arrays.stream(this.values).forEach(m -> message.append("values", (Object)m));
        return new MessageEvent(message);
    }
}

