/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.measurements.analysis;

import io.intino.alexandria.event.measurement.MeasurementEvent;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;

public class Analysis
extends MeasurementEvent
implements Serializable {
    private static final String[] declaredMagnitudes = new String[]{"availability;" + String.join((CharSequence)";", "max=100", "min=0", "unit=%", "operator=avg", "tail=DOWN", "distribution=Poisson"), "health;" + String.join((CharSequence)";", "max=100", "min=0", "unit=%", "format=%,.0f", "operator=avg", "tail=DOWN", "distribution=Poisson"), "risk;" + String.join((CharSequence)";", "max=100", "min=0", "unit=%", "format=%,.0f", "operator=avg", "tail=UP", "distribution=Poisson")};

    public Analysis(String ss) {
        super("Analysis", ss, Instant.now(), declaredMagnitudes, new double[3]);
    }

    public Analysis(String ss, String sensor) {
        super("Analysis", ss + "?sensor=" + sensor, Instant.now(), declaredMagnitudes, new double[3]);
    }

    public Analysis(String ss, String sensor, Instant ts) {
        super("Analysis", ss + "?sensor=" + sensor, ts, declaredMagnitudes, new double[3]);
    }

    public Analysis(MeasurementEvent event) {
        super("Analysis", event.ss(), event.ts(), event.magnitudes(), event.values());
    }

    public Analysis(Message message) {
        super("Analysis", message.get("ss").asString(), message.get("ts").asInstant(), (String[])message.get("magnitudes").as(String[].class), Arrays.stream((String[])message.get("values").as(String[].class)).mapToDouble(Double::parseDouble).toArray());
    }

    public double availability() {
        return this.values[0];
    }

    public double health() {
        return this.values[1];
    }

    public double risk() {
        return this.values[2];
    }

    public Analysis availability(double value) {
        this.values[0] = value;
        return this;
    }

    public Analysis health(double value) {
        this.values[1] = value;
        return this;
    }

    public Analysis risk(double value) {
        this.values[2] = value;
        return this;
    }

    public MessageEvent toMessageEvent() {
        Message message = new Message(this.getClass().getSimpleName());
        message.set("ts", (Object)this.ts);
        message.set("ss", this.source);
        Arrays.stream(this.magnitudes).forEach(m -> message.append("magnitudes", m.toString()));
        Arrays.stream(this.values).forEach(m -> message.append("values", (Object)m));
        return new MessageEvent(message);
    }
}

