/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.datamarts.master;

import io.intino.cosmos.datahub.datamarts.master.MasterDatamart;
import io.intino.ness.master.model.Concept;
import io.intino.ness.master.model.Struct;
import io.intino.ness.master.reflection.AttributeDefinition;
import io.intino.ness.master.reflection.StructDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public abstract class MasterStruct
implements Struct {
    private final MasterDatamart datamart;
    private final Map<String, Attribute> attributes;

    public MasterStruct(MasterDatamart datamart) {
        this.datamart = datamart;
        this.attributes = this.createAllAttributes();
    }

    public Attribute attribute(String name) {
        return this.attributes.get(name);
    }

    public List<Concept.Attribute> attributes() {
        return new ArrayList<Concept.Attribute>(this.attributes.values());
    }

    public MasterDatamart datamart() {
        return this.datamart;
    }

    synchronized void addAttribute(final String name, Object value) {
        this.attributes.put(name, new Attribute(name, value));
        List attributeDefinitions = this.getDefinition().declaredAttributes();
        if (attributeDefinitions.stream().anyMatch(a -> a.name().equals(name))) {
            return;
        }
        attributeDefinitions.add(new AttributeDefinition(){

            public String name() {
                return name;
            }

            public Class<?> type() {
                return String.class;
            }

            public String toString() {
                return name;
            }
        });
    }

    synchronized void updateAttribute(String name, Object newValue) {
        Attribute attribute = this.attribute(name);
        if (attribute == null) {
            this.addAttribute(name, newValue);
        } else {
            attribute.setValue(newValue);
        }
    }

    public void addChangeListener(Concept.ChangeListener listener) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.attributes.equals(((MasterStruct)o).attributes);
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + String.valueOf(this.attributes);
    }

    protected Collection<Attribute> initDeclaredAttributes() {
        return new ArrayList<Attribute>();
    }

    private Map<String, Attribute> createAllAttributes() {
        Collection<Attribute> declaredAttribs = this.initDeclaredAttributes();
        LinkedHashMap<String, Attribute> attributes = new LinkedHashMap<String, Attribute>(2 + declaredAttribs.size());
        declaredAttribs.forEach(attr -> attributes.put(attr.name(), (Attribute)attr));
        return attributes;
    }

    protected final class Attribute
    implements Concept.Attribute {
        private final String name;
        private Concept.Attribute.Value value;

        public Attribute(String name, Object initialValue) {
            this.name = name;
            this.value = new Concept.Attribute.Value(initialValue);
        }

        public AttributeDefinition getDefinition() {
            return (AttributeDefinition)MasterStruct.this.getDefinition().attribute(this.name).get();
        }

        public String name() {
            return this.name;
        }

        public Concept.Attribute.Value value() {
            return this.value;
        }

        private void setValue(Object newValue) {
            this.value = new Concept.Attribute.Value(newValue);
        }

        public void addChangeListener(Concept.Attribute.ChangeListener listener) {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Attribute other = (Attribute)o;
            return this.name().equals(other.name()) && this.type().equals(other.type()) && this.value.equals((Object)other.value());
        }

        public int hashCode() {
            return Objects.hash(this.name(), this.type(), this.value());
        }

        public String toString() {
            return this.type().getSimpleName() + " " + this.name() + " = " + String.valueOf(this.value());
        }
    }

    protected static final class StructDefinitionInternal
    implements StructDefinition {
        private final String structName;

        public StructDefinitionInternal(String structName) {
            this.structName = structName;
        }

        public String fullName() {
            return this.definition().fullName();
        }

        public String name() {
            return this.definition().name();
        }

        public List<AttributeDefinition> declaredAttributes() {
            return this.definition().declaredAttributes();
        }

        public Optional<StructDefinition> parent() {
            return this.definition().parent();
        }

        public List<StructDefinition> ancestors() {
            return this.definition().ancestors();
        }

        public List<StructDefinition> descendants() {
            return this.definition().descendants();
        }

        public Class<?> javaClass() {
            return this.definition().javaClass();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof StructDefinition) {
                return o.equals(this.definition());
            }
            return false;
        }

        public int hashCode() {
            return this.definition().hashCode();
        }

        private StructDefinition definition() {
            return (StructDefinition)MasterDatamart.definition.struct(this.structName).orElseThrow(() -> new IllegalStateException("Cannot find definition of " + this.structName + " in MasterDatamart"));
        }
    }
}

