/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub.datamarts.master;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.terminal.Connector;
import io.intino.alexandria.terminal.StubConnector;
import io.intino.alexandria.zim.ZimStream;
import io.intino.cosmos.datahub.MonetTerminal;
import io.intino.cosmos.datahub.datamarts.master.MasterDatamart;
import io.intino.cosmos.datahub.datamarts.master.MasterMounter;
import io.intino.cosmos.datahub.datamarts.master.entities.Appliance;
import io.intino.cosmos.datahub.datamarts.master.entities.Application;
import io.intino.cosmos.datahub.datamarts.master.entities.Area;
import io.intino.cosmos.datahub.datamarts.master.entities.Asset;
import io.intino.cosmos.datahub.datamarts.master.entities.Computer;
import io.intino.cosmos.datahub.datamarts.master.entities.Hardware;
import io.intino.cosmos.datahub.datamarts.master.entities.IncidentRule;
import io.intino.cosmos.datahub.datamarts.master.entities.JavaApplication;
import io.intino.cosmos.datahub.datamarts.master.entities.Model;
import io.intino.cosmos.datahub.datamarts.master.entities.Observable;
import io.intino.cosmos.datahub.datamarts.master.entities.Observer;
import io.intino.cosmos.datahub.datamarts.master.entities.OrderType;
import io.intino.cosmos.datahub.datamarts.master.entities.Part;
import io.intino.cosmos.datahub.datamarts.master.entities.Person;
import io.intino.cosmos.datahub.datamarts.master.entities.Place;
import io.intino.cosmos.datahub.datamarts.master.entities.Process;
import io.intino.cosmos.datahub.datamarts.master.entities.Service;
import io.intino.cosmos.datahub.datamarts.master.entities.Software;
import io.intino.cosmos.datahub.datamarts.master.mounters.ApplianceMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.ApplicationMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.AreaMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.AssetMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.ComputerMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.HardwareMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.IncidentRuleMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.JavaApplicationMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.ModelMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.ObserverMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.OrderTypeMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.PartMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.PersonMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.PlaceMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.ProcessMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.ServiceMounter;
import io.intino.cosmos.datahub.datamarts.master.mounters.SoftwareMounter;
import io.intino.ness.master.Datamart;
import io.intino.ness.master.model.Entity;
import io.intino.ness.master.reflection.AttributeDefinition;
import io.intino.ness.master.reflection.ConceptDefinition;
import io.intino.ness.master.reflection.DatamartDefinition;
import io.intino.ness.master.reflection.EntityDefinition;
import io.intino.ness.master.reflection.StructDefinition;
import io.intino.sumus.chronos.Period;
import io.intino.sumus.chronos.Reel;
import io.intino.sumus.chronos.ReelFile;
import io.intino.sumus.chronos.Timeline;
import io.intino.sumus.chronos.TimelineFile;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jms.BytesMessage;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.apache.activemq.command.ActiveMQTextMessage;

public class MasterDatamartImpl
implements MasterDatamart {
    private static final String DATAHUB_MESSAGE_TOPIC = "service.ness.datamarts";
    private static final MasterDatamartDefinition definition = new MasterDatamartDefinition();
    private static final Set<String> TIMELINE_EVENTS = Set.of("Computer", "Switch", "CellularGateway", "Wireless", "Camera", "Application");
    private static final Set<String> REEL_EVENTS = Set.of("status");
    private final Connector connector;
    private final MonetTerminal.DatamartsRetryConfig retryConfig;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final List<Datamart.EntityListener> entityListeners = new ArrayList<Datamart.EntityListener>();
    private final Map<String, List<MasterMounter>> mounters = new HashMap<String, List<MasterMounter>>();
    private final MasterDatamart.Entities entities;
    private Instant ts;
    private final Map<String, TimelineNodeImpl> timelines = new ConcurrentHashMap<String, TimelineNodeImpl>();
    private final Map<String, ReelNodeImpl> reels = new ConcurrentHashMap<String, ReelNodeImpl>();

    public MasterDatamartImpl(Connector connector, MonetTerminal.DatamartsRetryConfig retryConfig) {
        this.connector = Objects.requireNonNull(connector);
        this.retryConfig = Objects.requireNonNull(retryConfig);
        this.entities = new MasterDatamart.Entities((MasterDatamart)this);
        this.initMounters();
    }

    public synchronized MasterDatamartImpl init(String datamartSourceSelector) {
        try {
            if (!this.initialized.compareAndSet(false, true)) {
                return this;
            }
            this.downloadDatamartFromDatahub(datamartSourceSelector);
            Logger.info((String)("MasterDatamart (" + (String)(this.snapshotTimetag().isEmpty() ? "" : "snapshot " + this.snapshotTimetag() + ", ") + this.connector.clientId() + ") initialized successfully."));
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError("MasterDatamart failed to start because a " + e.getClass().getName() + " occurred: " + e.getMessage());
        }
        return this;
    }

    public int size() {
        return this.entities.size();
    }

    public <T extends Entity> T get(String id) {
        return (T)this.entities.get(id);
    }

    public Stream<Entity> entities() {
        return this.entities.streamGeneric();
    }

    public void addEntityListener(Datamart.EntityListener listener) {
        if (listener == null) {
            throw new NullPointerException("EntityListener cannot be null");
        }
        this.entityListeners.add(listener);
    }

    public DatamartDefinition getDefinition() {
        return definition;
    }

    public List<String> listSnapshots() {
        try {
            Message message = this.requestResponseFromDatahub("listSnapshots", this.listSnapshotsRequest());
            if (!message.getBooleanProperty("success")) {
                throw new Exception(((TextMessage)message).getText());
            }
            return this.handleListSnapshotsResponse(message);
        }
        catch (Exception e) {
            Logger.error((String)("Could not download list of available snapshots: " + e.getMessage()), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private Message listSnapshotsRequest() throws Exception {
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        message.setText("datamart=" + this.name() + ";operation=snapshots");
        return message;
    }

    private List<String> handleListSnapshotsResponse(Message message) throws Exception {
        return Arrays.stream(((TextMessage)message).getText().split(",")).collect(Collectors.toList());
    }

    public synchronized MasterDatamart snapshot(final String timetag) {
        if (timetag == null) {
            return this;
        }
        return new MasterDatamartImpl(this.connector, this.retryConfig){

            @Override
            protected String snapshotTimetag() {
                return timetag;
            }

            @Override
            public synchronized MasterDatamart snapshot(String timetag2) {
                throw new UnsupportedOperationException("Cannot request snapshots to snapshot instances of a datamart");
            }
        }.init(null);
    }

    public Instant ts() {
        return this.ts;
    }

    public Place place(String id) {
        return id == null ? null : (Place)this.entities.get(MasterDatamartImpl.definition.placeEntityDefinition, id);
    }

    public Stream<Place> places() {
        return this.entities.stream(MasterDatamartImpl.definition.placeEntityDefinition);
    }

    public Area area(String id) {
        return id == null ? null : (Area)this.entities.get(MasterDatamartImpl.definition.areaEntityDefinition, id);
    }

    public Stream<Area> areas() {
        return this.entities.stream(MasterDatamartImpl.definition.areaEntityDefinition);
    }

    public IncidentRule incidentRule(String id) {
        return id == null ? null : (IncidentRule)this.entities.get(MasterDatamartImpl.definition.incidentRuleEntityDefinition, id);
    }

    public Stream<IncidentRule> incidentRules() {
        return this.entities.stream(MasterDatamartImpl.definition.incidentRuleEntityDefinition);
    }

    public Model model(String id) {
        return id == null ? null : (Model)this.entities.get(MasterDatamartImpl.definition.modelEntityDefinition, id);
    }

    public Stream<Model> models() {
        return this.entities.stream(MasterDatamartImpl.definition.modelEntityDefinition);
    }

    public OrderType orderType(String id) {
        return id == null ? null : (OrderType)this.entities.get(MasterDatamartImpl.definition.orderTypeEntityDefinition, id);
    }

    public Stream<OrderType> orderTypes() {
        return this.entities.stream(MasterDatamartImpl.definition.orderTypeEntityDefinition);
    }

    public Observable observable(String id) {
        return id == null ? null : (Observable)this.entities.getDescendant(MasterDatamartImpl.definition.observableEntityDefinition, id);
    }

    public Stream<Observable> observables() {
        return Stream.of(this.persons(), this.processes(), this.assets(), this.parts(), this.hardwares(), this.softwares()).flatMap(Function.identity());
    }

    public Person person(String id) {
        return id == null ? null : (Person)this.entities.get(MasterDatamartImpl.definition.personEntityDefinition, id);
    }

    public Stream<Person> persons() {
        return this.entities.stream(MasterDatamartImpl.definition.personEntityDefinition);
    }

    public Process process(String id) {
        return id == null ? null : (Process)this.entities.get(MasterDatamartImpl.definition.processEntityDefinition, id);
    }

    public Stream<Process> processes() {
        return this.entities.stream(MasterDatamartImpl.definition.processEntityDefinition);
    }

    public Asset asset(String id) {
        return id == null ? null : (Asset)this.entities.get(MasterDatamartImpl.definition.assetEntityDefinition, id);
    }

    public Stream<Asset> assets() {
        return this.entities.stream(MasterDatamartImpl.definition.assetEntityDefinition);
    }

    public Part part(String id) {
        return id == null ? null : (Part)this.entities.get(MasterDatamartImpl.definition.partEntityDefinition, id);
    }

    public Stream<Part> parts() {
        return this.entities.stream(MasterDatamartImpl.definition.partEntityDefinition);
    }

    public Hardware hardware(String id) {
        return id == null ? null : (Hardware)this.entities.getDescendant(MasterDatamartImpl.definition.hardwareEntityDefinition, id);
    }

    public Stream<Hardware> hardwares() {
        return Stream.of(this.entities.stream(MasterDatamartImpl.definition.hardwareEntityDefinition), this.appliances(), this.computers()).flatMap(Function.identity());
    }

    public Appliance appliance(String id) {
        return id == null ? null : (Appliance)this.entities.get(MasterDatamartImpl.definition.applianceEntityDefinition, id);
    }

    public Stream<Appliance> appliances() {
        return this.entities.stream(MasterDatamartImpl.definition.applianceEntityDefinition);
    }

    public Computer computer(String id) {
        return id == null ? null : (Computer)this.entities.get(MasterDatamartImpl.definition.computerEntityDefinition, id);
    }

    public Stream<Computer> computers() {
        return this.entities.stream(MasterDatamartImpl.definition.computerEntityDefinition);
    }

    public Software software(String id) {
        return id == null ? null : (Software)this.entities.getDescendant(MasterDatamartImpl.definition.softwareEntityDefinition, id);
    }

    public Stream<Software> softwares() {
        return Stream.of(this.entities.stream(MasterDatamartImpl.definition.softwareEntityDefinition), this.observers(), this.services(), this.applications()).flatMap(Function.identity());
    }

    public Observer observer(String id) {
        return id == null ? null : (Observer)this.entities.get(MasterDatamartImpl.definition.observerEntityDefinition, id);
    }

    public Stream<Observer> observers() {
        return this.entities.stream(MasterDatamartImpl.definition.observerEntityDefinition);
    }

    public Service service(String id) {
        return id == null ? null : (Service)this.entities.get(MasterDatamartImpl.definition.serviceEntityDefinition, id);
    }

    public Stream<Service> services() {
        return this.entities.stream(MasterDatamartImpl.definition.serviceEntityDefinition);
    }

    public Application application(String id) {
        return id == null ? null : (Application)this.entities.getDescendant(MasterDatamartImpl.definition.applicationEntityDefinition, id);
    }

    public Stream<Application> applications() {
        return Stream.of(this.entities.stream(MasterDatamartImpl.definition.applicationEntityDefinition), this.javaApplications()).flatMap(Function.identity());
    }

    public JavaApplication javaApplication(String id) {
        return id == null ? null : (JavaApplication)this.entities.get(MasterDatamartImpl.definition.javaApplicationEntityDefinition, id);
    }

    public Stream<JavaApplication> javaApplications() {
        return this.entities.stream(MasterDatamartImpl.definition.javaApplicationEntityDefinition);
    }

    public Stream<MasterDatamart.TimelineNode> timelines(String id) {
        Stream<MasterDatamart.TimelineNode> stream = this.timelines.values().stream().filter(t -> t.id.equals(id)).toList().stream();
        return stream;
    }

    public MasterDatamart.TimelineNode computerTimeline(String id) {
        return this.timelines.computeIfAbsent(id + ":Computer", theId -> new TimelineNodeImpl(id, "Computer", Set.of("Computer", "ComputerAssertion")));
    }

    public MasterDatamart.TimelineNode switchTimeline(String id) {
        return this.timelines.computeIfAbsent(id + ":Switch", theId -> new TimelineNodeImpl(id, "Switch", Set.of("Switch", "ApplianceAssertion")));
    }

    public MasterDatamart.TimelineNode cellularGatewayTimeline(String id) {
        return this.timelines.computeIfAbsent(id + ":CellularGateway", theId -> new TimelineNodeImpl(id, "CellularGateway", Set.of("CellularGateway", "ApplianceAssertion")));
    }

    public MasterDatamart.TimelineNode wirelessTimeline(String id) {
        return this.timelines.computeIfAbsent(id + ":Wireless", theId -> new TimelineNodeImpl(id, "Wireless", Set.of("Wireless", "ApplianceAssertion")));
    }

    public MasterDatamart.TimelineNode cameraTimeline(String id) {
        return this.timelines.computeIfAbsent(id + ":Camera", theId -> new TimelineNodeImpl(id, "Camera", Set.of("Camera", "ApplianceAssertion")));
    }

    public MasterDatamart.TimelineNode applicationTimeline(String id) {
        return this.timelines.computeIfAbsent(id + ":Application", theId -> new TimelineNodeImpl(id, "Application", Set.of("Application", "ApplicationAssertion")));
    }

    public Stream<MasterDatamart.ReelNode> reels(String id) {
        Stream<MasterDatamart.ReelNode> stream = this.reels.values().stream().filter(r -> r.id.equals(id)).toList().stream();
        return stream;
    }

    public MasterDatamart.ReelNode statusReel(String id) {
        return this.reels.computeIfAbsent(id + ":Status", theId -> new ReelNodeImpl(id, "Status", Set.of("Datalake#dl$status")));
    }

    public Stream<MasterDatamart.ReelNode> statusReels() {
        Stream<MasterDatamart.ReelNode> stream = this.reels.values().stream().filter(r -> r.type.equals("Status")).toList().stream();
        return stream;
    }

    private void downloadDatamartFromDatahub(String datamartSourceSelector) {
        if (this.connector instanceof StubConnector) {
            return;
        }
        Logger.debug((String)"Downloading datamart from datahub...");
        long start = System.currentTimeMillis();
        Logger.debug((String)"Downloading entities...");
        int[] eventCount = new int[1];
        this.loadEntitiesFromEvents(this.downloadEntities(eventCount, datamartSourceSelector), eventCount);
        this.loadTimelinesFromDatahub();
        this.loadReelsFromDatahub();
        long time = System.currentTimeMillis() - start;
        Logger.debug((String)("Datamart downloaded from datahub after " + time + " ms"));
    }

    private void loadTimelinesFromDatahub() {
        Logger.debug((String)"Downloading timelines...");
        for (String filename : this.listTimelineFiles()) {
            if (filename == null || filename.isBlank()) continue;
            try {
                File file = new File(filename);
                String id = file.getName().replace(".timeline", "");
                String type = file.getParentFile().getName();
                TimelineNodeImpl node = new TimelineNodeImpl(id, type, MasterDatamartImpl.sourcesOfTimeline(type), file.exists() ? file : null);
                this.timelines.put(id + ":" + type, node);
            }
            catch (Exception e) {
                Logger.debug((String)("Could not load timeline " + filename + " -> " + e.getClass().getSimpleName() + ": " + e.getMessage()));
            }
        }
        Logger.debug((String)("Loaded " + this.timelines.size() + " timelines"));
    }

    private String[] listTimelineFiles() {
        try {
            ActiveMQTextMessage request = new ActiveMQTextMessage();
            request.setText("datamart=" + this.name() + ";operation=list-timelines;");
            Message message = this.requestResponseFromDatahub("list-timelines", (Message)request);
            if (!message.getBooleanProperty("success")) {
                throw new Exception(((TextMessage)message).getText());
            }
            return ((TextMessage)message).getText().split(",");
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return new String[0];
        }
    }

    private void loadReelsFromDatahub() {
        Logger.debug((String)"Downloading reels...");
        for (String filename : this.listReelFiles()) {
            if (filename == null || filename.isBlank()) continue;
            try {
                File file = new File(filename);
                String id = file.getName().replace(".reel", "");
                String type = file.getParentFile().getName();
                ReelNodeImpl node = new ReelNodeImpl(id, type, MasterDatamartImpl.sourcesOfReel(type), file.exists() ? file : null);
                this.reels.put(id + ":" + type, node);
            }
            catch (Exception e) {
                Logger.debug((String)("Could not load reel " + filename + " -> " + e.getClass().getSimpleName() + ": " + e.getMessage()));
            }
        }
        Logger.debug((String)("Loaded " + this.reels.size() + " reels"));
    }

    private String[] listReelFiles() {
        try {
            ActiveMQTextMessage request = new ActiveMQTextMessage();
            request.setText("datamart=" + this.name() + ";operation=list-reels;");
            Message message = this.requestResponseFromDatahub("list-reels", (Message)request);
            if (!message.getBooleanProperty("success")) {
                throw new Exception(((TextMessage)message).getText());
            }
            return ((TextMessage)message).getText().split(",");
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return new String[0];
        }
    }

    private Stream<Event> downloadEntities(int[] eventCount, String datamartSourceSelector) {
        try {
            Message message = this.requestResponseFromDatahub("downloadEvents", this.downloadEntitiesRequest(datamartSourceSelector));
            if (!message.getBooleanProperty("success")) {
                throw new Exception(((TextMessage)message).getText());
            }
            return this.handleDownloadResponse(message, eventCount);
        }
        catch (NullPointerException e) {
            throw new NullPointerException("Could not download datamart: no response from datahub.");
        }
        catch (Exception e) {
            throw new RuntimeException("Could not download datamart: " + e.getMessage());
        }
    }

    private Message downloadEntitiesRequest(String datamartSourceSelector) throws Exception {
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        message.setText("datamart=" + this.name() + ";operation=entities" + (String)(this.snapshotTimetag().isEmpty() ? "" : ";timetag=" + this.snapshotTimetag()) + (String)(datamartSourceSelector == null ? "" : ";sourceSelector=" + datamartSourceSelector));
        return message;
    }

    protected String snapshotTimetag() {
        return "";
    }

    private Stream<Event> handleDownloadResponse(Message message, int[] eventCount) throws Exception {
        BytesMessage m = (BytesMessage)message;
        eventCount[0] = m.getIntProperty("size");
        int size = m.getIntProperty("size");
        byte[] bytes = new byte[size];
        m.readBytes(bytes, size);
        return ZimStream.of((InputStream)new ByteArrayInputStream(bytes)).map(MessageEvent::new);
    }

    private void loadEntitiesFromEvents(Stream<Event> events, int[] eventCount) {
        events.forEach(this::mount);
    }

    public synchronized void mount(Event event) {
        if (event == null) {
            return;
        }
        this.ts = event.ts();
        this.mountEntities(event);
        this.mountTimelines(event);
        this.mountReels(event);
    }

    private void mountReels(Event event) {
        String type;
        if (!REEL_EVENTS.contains(event.type())) {
            return;
        }
        String id = MasterDatamartImpl.sensorParameter(event.ss());
        String key = id + ":" + (type = event.type());
        if (!this.reels.containsKey(key)) {
            ReelNodeImpl node = new ReelNodeImpl(id, type, MasterDatamartImpl.sourcesOfReel(type), null);
            this.reels.put(key, node);
        }
        this.reels.values().forEach(reel -> reel.notifyEvent(event));
    }

    private void mountTimelines(Event event) {
        if (!TIMELINE_EVENTS.contains(event.type())) {
            return;
        }
        String id = MasterDatamartImpl.sensorParameter(event.ss());
        String type = event.type();
        TimelineNodeImpl node = this.timelines.computeIfAbsent(id + ":" + type, k -> new TimelineNodeImpl(id, type, MasterDatamartImpl.sourcesOfTimeline(type), null));
        node.notifyEvent(event);
    }

    private static String sensorParameter(String ss) {
        if (ss.contains("?")) {
            try {
                Map<String, String> map = Arrays.stream(ss.substring(ss.indexOf("?") + 1).split(";")).map(p -> p.split("=")).collect(Collectors.toMap(f -> f[0], f -> f[1]));
                if (map.containsKey("sensor")) {
                    return map.get("sensor");
                }
                ss.substring(0, ss.indexOf("?"));
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
            }
        }
        return ss;
    }

    private void mountEntities(Event event) {
        try {
            Optional.ofNullable(this.mounters.get(event.type())).ifPresent(mounters -> mounters.forEach(mounter -> mounter.mount(event)));
        }
        catch (Exception e) {
            Logger.error((String)("Failed to mount event of type " + event.type() + ": " + e.getMessage()), (Throwable)e);
        }
    }

    private void initMounters() {
        this.mounters.computeIfAbsent("PlaceAssertion", type -> new ArrayList(1)).add(new PlaceMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("AreaAssertion", type -> new ArrayList(1)).add(new AreaMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("IncidentRuleAssertion", type -> new ArrayList(1)).add(new IncidentRuleMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("ModelAssertion", type -> new ArrayList(1)).add(new ModelMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("OrderTypeAssertion", type -> new ArrayList(1)).add(new OrderTypeMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("PersonAssertion", type -> new ArrayList(1)).add(new PersonMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("ProcessAssertion", type -> new ArrayList(1)).add(new ProcessMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("AssetAssertion", type -> new ArrayList(1)).add(new AssetMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("PartAssertion", type -> new ArrayList(1)).add(new PartMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("HardwareAssertion", type -> new ArrayList(1)).add(new HardwareMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("ApplianceAssertion", type -> new ArrayList(1)).add(new ApplianceMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("ComputerAssertion", type -> new ArrayList(1)).add(new ComputerMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("SoftwareAssertion", type -> new ArrayList(1)).add(new SoftwareMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("ObserverAssertion", type -> new ArrayList(1)).add(new ObserverMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("ServiceAssertion", type -> new ArrayList(1)).add(new ServiceMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("ApplicationAssertion", type -> new ArrayList(1)).add(new ApplicationMounter(this.entities, this.entityListeners));
        this.mounters.computeIfAbsent("ApplicationJavaAssertion", type -> new ArrayList(1)).add(new JavaApplicationMounter(this.entities, this.entityListeners));
    }

    private static int availableThreads() {
        return Runtime.getRuntime().availableProcessors();
    }

    private Message requestResponseFromDatahub(String requestName, Message request) throws Exception {
        long timeout = this.retryConfig.initialTimeoutAmount;
        for (int i = 0; i < this.retryConfig.maxAttempts; ++i) {
            Message message = this.connector.requestResponse(DATAHUB_MESSAGE_TOPIC, request, timeout, this.retryConfig.timeoutUnit);
            if (message != null) {
                return message;
            }
            if (i < this.retryConfig.maxAttempts - 1) {
                Logger.warn((String)("(" + (i + 1) + ") Datahub did not respond after " + timeout + " " + this.retryConfig.timeoutUnit + " to the request '" + requestName + "'. Trying again..."));
            }
            timeout = (long)((float)timeout * this.retryConfig.timeoutMultiplier);
        }
        throw new RuntimeException("Datahub did not respond to the request '" + requestName + "' after " + this.retryConfig.maxAttempts);
    }

    private static Set<String> sourcesOfTimeline(String type) {
        return switch (type) {
            case "Computer" -> Set.of("Computer", "ComputerAssertion");
            case "Switch" -> Set.of("Switch", "ApplianceAssertion");
            case "CellularGateway" -> Set.of("CellularGateway", "ApplianceAssertion");
            case "Wireless" -> Set.of("Wireless", "ApplianceAssertion");
            case "Camera" -> Set.of("Camera", "ApplianceAssertion");
            case "Application" -> Set.of("Application", "ApplicationAssertion");
            default -> Collections.emptySet();
        };
    }

    private static Set<String> sourcesOfReel(String type) {
        return switch (type) {
            case "Status" -> Set.of("Datalake#dl$status");
            default -> Collections.emptySet();
        };
    }

    static {
        try {
            Object ref = MasterDatamart.class.getDeclaredField("definition").get(null);
            Field field = ref.getClass().getDeclaredField("definition");
            field.setAccessible(true);
            field.set(ref, definition);
            field.setAccessible(false);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError("Could not set MasterDatamart.definition field");
        }
    }

    public static final class MasterDatamartDefinition
    implements DatamartDefinition {
        public final EntityDefinition placeEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Place";
            }

            public String name() {
                return "Place";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.empty();
            }

            public List<EntityDefinition> ancestors() {
                return List.of();
            }

            public List<EntityDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Place.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "id";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "enabled";
                    }

                    public Class<?> type() {
                        return Boolean.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "label";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "coordinates";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "timeOffset";
                    }

                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "region";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "city";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "area";
                    }

                    public Class<?> type() {
                        return Area.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "address";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "postalCode";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition areaEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Area";
            }

            public String name() {
                return "Area";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.empty();
            }

            public List<EntityDefinition> ancestors() {
                return List.of();
            }

            public List<EntityDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Area.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "id";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "enabled";
                    }

                    public Class<?> type() {
                        return Boolean.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "label";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition incidentRuleEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "IncidentRule";
            }

            public String name() {
                return "IncidentRule";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.empty();
            }

            public List<EntityDefinition> ancestors() {
                return List.of();
            }

            public List<EntityDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return IncidentRule.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "id";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "enabled";
                    }

                    public Class<?> type() {
                        return Boolean.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "description";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "target";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "model";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "level";
                    }

                    public Class<?> type() {
                        return IncidentRule.Level.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "tracking";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "triggers";
                    }

                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "precondition";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "condition";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "countermeasures";
                    }

                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "orderTypes";
                    }

                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition modelEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Model";
            }

            public String name() {
                return "Model";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.empty();
            }

            public List<EntityDefinition> ancestors() {
                return List.of();
            }

            public List<EntityDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Model.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "id";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "enabled";
                    }

                    public Class<?> type() {
                        return Boolean.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "type";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "target";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "profile";
                    }

                    public Class<?> type() {
                        return Model.Profile.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition orderTypeEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "OrderType";
            }

            public String name() {
                return "OrderType";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.empty();
            }

            public List<EntityDefinition> ancestors() {
                return List.of();
            }

            public List<EntityDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return OrderType.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "id";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "enabled";
                    }

                    public Class<?> type() {
                        return Boolean.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition observableEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Observable";
            }

            public String name() {
                return "Observable";
            }

            public boolean isAbstract() {
                return true;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.empty();
            }

            public List<EntityDefinition> ancestors() {
                return List.of();
            }

            public List<EntityDefinition> descendants() {
                return List.of(personEntityDefinition, processEntityDefinition, assetEntityDefinition, partEntityDefinition, hardwareEntityDefinition, applianceEntityDefinition, computerEntityDefinition, softwareEntityDefinition, observerEntityDefinition, serviceEntityDefinition, applicationEntityDefinition, javaApplicationEntityDefinition);
            }

            public Class<?> javaClass() {
                return Observable.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "id";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "enabled";
                    }

                    public Class<?> type() {
                        return Boolean.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "label";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "place";
                    }

                    public Class<?> type() {
                        return Place.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "team";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "model";
                    }

                    public Class<?> type() {
                        return Model.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "container";
                    }

                    public Class<?> type() {
                        return Observable.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "observer";
                    }

                    public Class<?> type() {
                        return Observer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "responsible";
                    }

                    public Class<?> type() {
                        return Person.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "tags";
                    }

                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "operationList";
                    }

                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.of(this.datamart().observable$OperationStructDefinition);
                            }

                            public Class<?> javaClass() {
                                return Observable.Operation.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition personEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Observable.Person";
            }

            public String name() {
                return "Person";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.of(observableEntityDefinition);
            }

            public List<EntityDefinition> ancestors() {
                return List.of(observableEntityDefinition);
            }

            public List<EntityDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Person.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "area";
                    }

                    public Class<?> type() {
                        return Area.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "role";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "supervisor";
                    }

                    public Class<?> type() {
                        return Person.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "email";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "phone";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition processEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Observable.Process";
            }

            public String name() {
                return "Process";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.of(observableEntityDefinition);
            }

            public List<EntityDefinition> ancestors() {
                return List.of(observableEntityDefinition);
            }

            public List<EntityDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Process.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList list = new ArrayList();
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition assetEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Observable.Asset";
            }

            public String name() {
                return "Asset";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.of(observableEntityDefinition);
            }

            public List<EntityDefinition> ancestors() {
                return List.of(observableEntityDefinition);
            }

            public List<EntityDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Asset.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList list = new ArrayList();
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition partEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Observable.Part";
            }

            public String name() {
                return "Part";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.of(observableEntityDefinition);
            }

            public List<EntityDefinition> ancestors() {
                return List.of(observableEntityDefinition);
            }

            public List<EntityDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Part.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList list = new ArrayList();
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition hardwareEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Observable.Hardware";
            }

            public String name() {
                return "Hardware";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.of(observableEntityDefinition);
            }

            public List<EntityDefinition> ancestors() {
                return List.of(observableEntityDefinition);
            }

            public List<EntityDefinition> descendants() {
                return List.of(applianceEntityDefinition, computerEntityDefinition);
            }

            public Class<?> javaClass() {
                return Hardware.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "sn";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "ip";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "publicIp";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition applianceEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Observable.Hardware.Appliance";
            }

            public String name() {
                return "Appliance";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.of(hardwareEntityDefinition);
            }

            public List<EntityDefinition> ancestors() {
                return List.of(hardwareEntityDefinition, observableEntityDefinition);
            }

            public List<EntityDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Appliance.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList list = new ArrayList();
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition computerEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Observable.Hardware.Computer";
            }

            public String name() {
                return "Computer";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.of(hardwareEntityDefinition);
            }

            public List<EntityDefinition> ancestors() {
                return List.of(hardwareEntityDefinition, observableEntityDefinition);
            }

            public List<EntityDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Computer.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "architecture";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "os";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "cores";
                    }

                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "diskSize";
                    }

                    public Class<?> type() {
                        return Long.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "memorySize";
                    }

                    public Class<?> type() {
                        return Long.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "processes";
                    }

                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "maxOpenFiles";
                    }

                    public Class<?> type() {
                        return Long.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "jvm";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "isp";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition softwareEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Observable.Software";
            }

            public String name() {
                return "Software";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.of(observableEntityDefinition);
            }

            public List<EntityDefinition> ancestors() {
                return List.of(observableEntityDefinition);
            }

            public List<EntityDefinition> descendants() {
                return List.of(observerEntityDefinition, serviceEntityDefinition, applicationEntityDefinition, javaApplicationEntityDefinition);
            }

            public Class<?> javaClass() {
                return Software.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList list = new ArrayList();
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition observerEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Observable.Software.Observer";
            }

            public String name() {
                return "Observer";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.of(softwareEntityDefinition);
            }

            public List<EntityDefinition> ancestors() {
                return List.of(softwareEntityDefinition, observableEntityDefinition);
            }

            public List<EntityDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Observer.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "version";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "installedActivities";
                    }

                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "enabledActivities";
                    }

                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition serviceEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Observable.Software.Service";
            }

            public String name() {
                return "Service";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.of(softwareEntityDefinition);
            }

            public List<EntityDefinition> ancestors() {
                return List.of(softwareEntityDefinition, observableEntityDefinition);
            }

            public List<EntityDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Service.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<1> list = new ArrayList<1>();
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "url";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition applicationEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Observable.Software.Application";
            }

            public String name() {
                return "Application";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.of(softwareEntityDefinition);
            }

            public List<EntityDefinition> ancestors() {
                return List.of(softwareEntityDefinition, observableEntityDefinition);
            }

            public List<EntityDefinition> descendants() {
                return List.of(javaApplicationEntityDefinition);
            }

            public Class<?> javaClass() {
                return Application.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "name";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "user";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "systemService";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "startingTime";
                    }

                    public Class<?> type() {
                        return LocalDateTime.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "pid";
                    }

                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "commandLine";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "state";
                    }

                    public Class<?> type() {
                        return Application.State.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final EntityDefinition javaApplicationEntityDefinition = new EntityDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Observable.Software.Application.JavaApplication";
            }

            public String name() {
                return "JavaApplication";
            }

            public boolean isAbstract() {
                return false;
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<EntityDefinition> parent() {
                return Optional.of(applicationEntityDefinition);
            }

            public List<EntityDefinition> ancestors() {
                return List.of(applicationEntityDefinition, softwareEntityDefinition, observableEntityDefinition);
            }

            public List<EntityDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return JavaApplication.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "classpathPrefix";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "mainArtifact";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "debugPort";
                    }

                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "jmxPort";
                    }

                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "minMemory";
                    }

                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "maxMemory";
                    }

                    public Class<?> type() {
                        return Integer.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "classpath";
                    }

                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "inputArguments";
                    }

                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "jvmParameter";
                    }

                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "jvmVersion";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((EntityDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final StructDefinition model$ProfileStructDefinition = new StructDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Model$Profile";
            }

            public String name() {
                return "Profile";
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<StructDefinition> parent() {
                return Optional.empty();
            }

            public List<StructDefinition> ancestors() {
                return List.of();
            }

            public List<StructDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Model.Profile.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<MasterDatamartDefinition.1> list = new ArrayList<MasterDatamartDefinition.1>();
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "variableList";
                    }

                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.of(this.datamart().model$Profile$VariableStructDefinition);
                            }

                            public Class<?> javaClass() {
                                return Model.Profile.Variable.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((StructDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final StructDefinition model$Profile$VariableStructDefinition = new StructDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Model$Profile$Variable";
            }

            public String name() {
                return "Variable";
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<StructDefinition> parent() {
                return Optional.empty();
            }

            public List<StructDefinition> ancestors() {
                return List.of();
            }

            public List<StructDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Model.Profile.Variable.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "name";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "className";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "label";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "type";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "operator";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "unit";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "symbol";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "values";
                    }

                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.empty();
                            }

                            public Class<?> javaClass() {
                                return String.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "min";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "max";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "description";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "format";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((StructDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final StructDefinition observable$OperationStructDefinition = new StructDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Observable$Operation";
            }

            public String name() {
                return "Operation";
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<StructDefinition> parent() {
                return Optional.empty();
            }

            public List<StructDefinition> ancestors() {
                return List.of();
            }

            public List<StructDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Observable.Operation.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "activity";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "name";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "procedureList";
                    }

                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.of(this.datamart().observable$Operation$ProcedureStructDefinition);
                            }

                            public Class<?> javaClass() {
                                return Observable.Operation.Procedure.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((StructDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final StructDefinition observable$Operation$ProcedureStructDefinition = new StructDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Observable$Operation$Procedure";
            }

            public String name() {
                return "Procedure";
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<StructDefinition> parent() {
                return Optional.empty();
            }

            public List<StructDefinition> ancestors() {
                return List.of();
            }

            public List<StructDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Observable.Operation.Procedure.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "name";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "returnType";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "description";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "parameterList";
                    }

                    public Class<?> type() {
                        return List.class;
                    }

                    public String toString() {
                        return this.name();
                    }

                    public List<AttributeDefinition.ParameterDefinition> parameters() {
                        return List.of(new AttributeDefinition.ParameterDefinition(){

                            public Optional<ConceptDefinition<?>> asConceptDefinition() {
                                return Optional.of(this.datamart().observable$Operation$Procedure$ParameterStructDefinition);
                            }

                            public Class<?> javaClass() {
                                return Observable.Operation.Procedure.Parameter.class;
                            }

                            public String toString() {
                                return this.javaClass().getSimpleName();
                            }
                        });
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((StructDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };
        public final StructDefinition observable$Operation$Procedure$ParameterStructDefinition = new StructDefinition(){
            private final List<AttributeDefinition> declaredAttributes = this.initAttributeDefinitions();

            public String fullName() {
                return "Observable$Operation$Procedure$Parameter";
            }

            public String name() {
                return "Parameter";
            }

            public List<AttributeDefinition> declaredAttributes() {
                return this.declaredAttributes;
            }

            public Optional<StructDefinition> parent() {
                return Optional.empty();
            }

            public List<StructDefinition> ancestors() {
                return List.of();
            }

            public List<StructDefinition> descendants() {
                return List.of();
            }

            public Class<?> javaClass() {
                return Observable.Operation.Procedure.Parameter.class;
            }

            private List<AttributeDefinition> initAttributeDefinitions() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "type";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                list.add(new AttributeDefinition(){

                    public String name() {
                        return "name";
                    }

                    public Class<?> type() {
                        return String.class;
                    }

                    public String toString() {
                        return this.name();
                    }
                });
                return Collections.synchronizedList(list);
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                return this.fullName().equals(((StructDefinition)other).fullName());
            }

            public int hashCode() {
                return this.fullName().hashCode();
            }

            public String toString() {
                return this.fullName();
            }
        };

        public String name() {
            return "master";
        }

        public Datamart.Scale scale() {
            return Datamart.Scale.Day;
        }

        public DatamartDefinition.Query<EntityDefinition> entities() {
            return new DatamartDefinition.Query(List.of(this.placeEntityDefinition, this.areaEntityDefinition, this.incidentRuleEntityDefinition, this.modelEntityDefinition, this.orderTypeEntityDefinition, this.observableEntityDefinition, this.personEntityDefinition, this.processEntityDefinition, this.assetEntityDefinition, this.partEntityDefinition, this.hardwareEntityDefinition, this.applianceEntityDefinition, this.computerEntityDefinition, this.softwareEntityDefinition, this.observerEntityDefinition, this.serviceEntityDefinition, this.applicationEntityDefinition, this.javaApplicationEntityDefinition));
        }

        public DatamartDefinition.Query<StructDefinition> structs() {
            return new DatamartDefinition.Query(List.of(this.model$ProfileStructDefinition, this.model$Profile$VariableStructDefinition, this.observable$OperationStructDefinition, this.observable$Operation$ProcedureStructDefinition, this.observable$Operation$Procedure$ParameterStructDefinition));
        }

        public Optional<EntityDefinition> entity(String name) {
            switch (name) {
                case "Place": {
                    return Optional.of(this.placeEntityDefinition);
                }
                case "Area": {
                    return Optional.of(this.areaEntityDefinition);
                }
                case "IncidentRule": {
                    return Optional.of(this.incidentRuleEntityDefinition);
                }
                case "Model": {
                    return Optional.of(this.modelEntityDefinition);
                }
                case "OrderType": {
                    return Optional.of(this.orderTypeEntityDefinition);
                }
                case "Observable": {
                    return Optional.of(this.observableEntityDefinition);
                }
                case "Person": {
                    return Optional.of(this.personEntityDefinition);
                }
                case "Process": {
                    return Optional.of(this.processEntityDefinition);
                }
                case "Asset": {
                    return Optional.of(this.assetEntityDefinition);
                }
                case "Part": {
                    return Optional.of(this.partEntityDefinition);
                }
                case "Hardware": {
                    return Optional.of(this.hardwareEntityDefinition);
                }
                case "Appliance": {
                    return Optional.of(this.applianceEntityDefinition);
                }
                case "Computer": {
                    return Optional.of(this.computerEntityDefinition);
                }
                case "Software": {
                    return Optional.of(this.softwareEntityDefinition);
                }
                case "Observer": {
                    return Optional.of(this.observerEntityDefinition);
                }
                case "Service": {
                    return Optional.of(this.serviceEntityDefinition);
                }
                case "Application": {
                    return Optional.of(this.applicationEntityDefinition);
                }
                case "JavaApplication": {
                    return Optional.of(this.javaApplicationEntityDefinition);
                }
            }
            return Optional.empty();
        }

        public Optional<StructDefinition> struct(String name) {
            switch (name) {
                case "Model$Profile": {
                    return Optional.of(this.model$ProfileStructDefinition);
                }
                case "Model$Profile$Variable": {
                    return Optional.of(this.model$Profile$VariableStructDefinition);
                }
                case "Observable$Operation": {
                    return Optional.of(this.observable$OperationStructDefinition);
                }
                case "Observable$Operation$Procedure": {
                    return Optional.of(this.observable$Operation$ProcedureStructDefinition);
                }
                case "Observable$Operation$Procedure$Parameter": {
                    return Optional.of(this.observable$Operation$Procedure$ParameterStructDefinition);
                }
            }
            return Optional.empty();
        }

        private MasterDatamartDefinition datamart() {
            return this;
        }
    }

    private class TimelineNodeImpl
    implements MasterDatamart.TimelineNode {
        private final String id;
        private final String type;
        private final Set<String> sources;
        private volatile File file;
        private volatile TimelineFile timelineFile;
        private volatile SoftReference<Timeline> cache;
        private volatile MasterDatamart.TimelineNode.EventListener listener;
        private volatile boolean disposed;

        private TimelineNodeImpl(String id, String type, Set<String> sources) {
            this(id, type, sources, null);
        }

        private TimelineNodeImpl(String id, String type, Set<String> sources, File file) {
            this.id = Objects.requireNonNull(id);
            this.type = Objects.requireNonNull(type);
            this.sources = Objects.requireNonNull(sources);
            this.file = file;
        }

        public String id() {
            return this.id;
        }

        public String type() {
            return this.type;
        }

        public boolean exists() {
            return this.timelineFile() != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            TimelineNodeImpl timelineNodeImpl = this;
            synchronized (timelineNodeImpl) {
                if (this.disposed) {
                    return;
                }
                this.clearCache();
                this.listener = null;
                MasterDatamartImpl.this.timelines.remove(this.id + ":" + this.type);
                this.disposed = true;
            }
        }

        public TimelineFile.TimeModel timeModel() {
            return this.timelineFile().timeModel();
        }

        public TimelineFile.SensorModel sensorModel() {
            return this.timelineFile().sensorModel();
        }

        public Instant first() {
            return this.timelineFile().first();
        }

        public Instant last() {
            return this.timelineFile().last();
        }

        public Timeline get() {
            TimelineNodeImpl timelineNodeImpl = this;
            synchronized (timelineNodeImpl) {
                if (this.disposed) {
                    throw new IllegalStateException("This " + this.getClass().getSimpleName() + " is disposed.");
                }
                try {
                    Timeline timeline;
                    if (this.cache != null && (timeline = this.cache.get()) != null) {
                        return timeline;
                    }
                    timeline = this.timelineFile().timeline();
                    this.cache = new SoftReference<Timeline>(timeline);
                    return timeline;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private TimelineFile timelineFile() {
            TimelineNodeImpl timelineNodeImpl = this;
            synchronized (timelineNodeImpl) {
                if (this.disposed) {
                    throw new IllegalStateException("This " + this.getClass().getSimpleName() + " is disposed.");
                }
                try {
                    if (this.timelineFile != null) {
                        return this.timelineFile;
                    }
                    this.timelineFile = !MasterDatamart.TimelineNode.AlwaysDownloadFromDatahub.get() && this.file != null && this.file.exists() ? this.loadFile() : this.downloadFromDatahub();
                    return this.timelineFile;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public void setEventListener(MasterDatamart.TimelineNode.EventListener listener) {
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyEvent(Event event) {
            TimelineNodeImpl timelineNodeImpl = this;
            synchronized (timelineNodeImpl) {
                if (this.disposed) {
                    return;
                }
                try {
                    if (!this.sources.contains(event.type())) {
                        return;
                    }
                    this.clearCache();
                    if (this.listener != null) {
                        this.listener.onEventReceived((MasterDatamart.TimelineNode)this, event);
                    }
                }
                catch (Throwable e) {
                    Logger.error((Throwable)e);
                }
            }
        }

        private void clearCache() {
            if (this.cache != null) {
                this.cache.enqueue();
                this.cache = null;
            }
            this.timelineFile = null;
            this.file = null;
        }

        private TimelineFile loadFile() throws Exception {
            return TimelineFile.open((File)this.file);
        }

        private TimelineFile downloadFromDatahub() throws Exception {
            Message response = MasterDatamartImpl.this.requestResponseFromDatahub("get-timeline=" + this.id(), this.request(MasterDatamart.TimelineNode.AlwaysDownloadFromDatahub.get() ? "download" : "path"));
            if (!response.getBooleanProperty("success")) {
                return null;
            }
            if (response instanceof TextMessage) {
                TextMessage textResponse = (TextMessage)response;
                this.file = this.getFile(textResponse);
                if (this.file != null && this.file.exists()) {
                    return this.loadFile();
                }
                this.file = null;
                response = MasterDatamartImpl.this.requestResponseFromDatahub("get-timeline=" + this.id(), this.request("download"));
            }
            if (!response.getBooleanProperty("success")) {
                return null;
            }
            return this.readFromBytes((BytesMessage)response);
        }

        private TimelineFile readFromBytes(BytesMessage m) throws Exception {
            int size = m.getIntProperty("size");
            byte[] bytes = new byte[size];
            m.readBytes(bytes, size);
            this.file = File.createTempFile(this.id(), ".timeline");
            Files.write(this.file.toPath(), bytes, StandardOpenOption.CREATE);
            this.file.deleteOnExit();
            return this.loadFile();
        }

        private File getFile(TextMessage m) {
            try {
                return new File(m.getText());
            }
            catch (Exception e) {
                return null;
            }
        }

        private Message request(String mode) throws Exception {
            ActiveMQTextMessage message = new ActiveMQTextMessage();
            String command = "datamart=" + MasterDatamartImpl.this.name() + ";operation=get-timeline;id=" + this.id() + ";mode=" + mode + ";type=" + this.type;
            message.setText(command);
            return message;
        }
    }

    private class ReelNodeImpl
    implements MasterDatamart.ReelNode {
        private final String id;
        private final String type;
        private final Set<String> sources;
        private volatile File file;
        private volatile ReelFile reelFile;
        private volatile MasterDatamart.ReelNode.EventListener listener;
        private volatile boolean disposed;

        private ReelNodeImpl(String id, String type, Set<String> sources) {
            this(id, type, sources, null);
        }

        private ReelNodeImpl(String id, String type, Set<String> sources, File file) {
            this.id = Objects.requireNonNull(id);
            this.type = Objects.requireNonNull(type);
            this.sources = Objects.requireNonNull(sources);
            this.file = file;
        }

        public String id() {
            return this.id;
        }

        public String type() {
            return this.type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            ReelNodeImpl reelNodeImpl = this;
            synchronized (reelNodeImpl) {
                if (this.disposed) {
                    return;
                }
                this.clearCache();
                this.listener = null;
                MasterDatamartImpl.this.reels.remove(this.id + ":" + this.type);
                this.disposed = true;
            }
        }

        public ReelFile.Group groupOf(String signal) {
            ReelFile reelFile = this.reelFile();
            if (reelFile == null) {
                return null;
            }
            return reelFile.groupOf(signal);
        }

        public Reel.State stateOf(String signal) {
            ReelFile reelFile = this.reelFile();
            if (reelFile == null) {
                throw new IllegalArgumentException("Reel file not found");
            }
            return reelFile.stateOf(signal);
        }

        public List<Reel.State> stateOf(Stream<String> signals) {
            ReelFile reelFile = this.reelFile();
            if (reelFile == null) {
                throw new IllegalArgumentException("Reel file not found");
            }
            return signals.map(arg_0 -> ((ReelFile)reelFile).stateOf(arg_0)).toList();
        }

        public Reel get(Period period) {
            ReelFile reelFile = this.reelFile();
            if (reelFile == null) {
                throw new IllegalArgumentException("Reel file not found");
            }
            return this.reelFile().reel().by(period);
        }

        public Reel get(Instant from, Instant to, Period period) {
            ReelFile reelFile = this.reelFile();
            if (reelFile == null) {
                throw new IllegalArgumentException("Reel file not found");
            }
            return reelFile.reel(from, to).by(period);
        }

        public boolean exists() {
            return this.reelFile() != null;
        }

        private ReelFile reelFile() {
            ReelNodeImpl reelNodeImpl = this;
            synchronized (reelNodeImpl) {
                if (this.disposed) {
                    throw new IllegalStateException("This " + this.getClass().getSimpleName() + " is disposed.");
                }
                try {
                    if (this.reelFile != null) {
                        return this.reelFile;
                    }
                    this.reelFile = this.file != null && this.file.exists() ? this.loadFile() : this.downloadFromDatahub();
                    return this.reelFile;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public void setEventListener(MasterDatamart.ReelNode.EventListener listener) {
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyEvent(Event event) {
            ReelNodeImpl reelNodeImpl = this;
            synchronized (reelNodeImpl) {
                if (this.disposed) {
                    return;
                }
                try {
                    if (!this.sources.contains(event.type())) {
                        return;
                    }
                    this.clearCache();
                    if (this.listener != null) {
                        this.listener.onEventReceived((MasterDatamart.ReelNode)this, event);
                    }
                }
                catch (Throwable e) {
                    Logger.error((Throwable)e);
                }
            }
        }

        private void clearCache() {
            this.reelFile = null;
            this.file = null;
        }

        private ReelFile loadFile() throws Exception {
            return ReelFile.open((File)this.file);
        }

        private ReelFile downloadFromDatahub() throws Exception {
            Message response = MasterDatamartImpl.this.requestResponseFromDatahub("get-reel=" + this.id(), this.request("path"));
            if (!response.getBooleanProperty("success")) {
                return null;
            }
            if (response instanceof TextMessage) {
                TextMessage textResponse = (TextMessage)response;
                this.file = this.getFile(textResponse);
                if (this.file != null && this.file.exists()) {
                    return this.loadFile();
                }
                this.file = null;
                response = MasterDatamartImpl.this.requestResponseFromDatahub("get-reel=" + this.id(), this.request("download"));
            }
            if (!response.getBooleanProperty("success")) {
                return null;
            }
            return this.readFromBytes((BytesMessage)response);
        }

        private ReelFile readFromBytes(BytesMessage m) throws Exception {
            int size = m.getIntProperty("size");
            byte[] bytes = new byte[size];
            m.readBytes(bytes, size);
            this.file = File.createTempFile(this.id(), ".reel");
            Files.write(this.file.toPath(), bytes, StandardOpenOption.CREATE);
            this.file.deleteOnExit();
            return this.loadFile();
        }

        private File getFile(TextMessage m) {
            try {
                return new File(m.getText());
            }
            catch (Exception e) {
                return null;
            }
        }

        private Message request(String mode) throws Exception {
            ActiveMQTextMessage message = new ActiveMQTextMessage();
            String command = "datamart=" + MasterDatamartImpl.this.name() + ";operation=get-reel;id=" + this.id() + ";mode=" + mode + ";type=" + this.type;
            message.setText(command);
            return message;
        }
    }
}

