/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.datahub;

import com.google.gson.JsonObject;
import io.intino.alexandria.Json;
import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.datalake.file.FileDatalake;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.ingestion.EventSession;
import io.intino.alexandria.ingestion.SessionHandler;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.terminal.Connector;
import io.intino.alexandria.terminal.JmsConnector;
import io.intino.alexandria.terminal.remotedatalake.RemoteDatalake;
import io.intino.cosmos.datahub.datamarts.master.MasterDatamart;
import io.intino.cosmos.datahub.datamarts.master.MasterDatamartImpl;
import io.intino.cosmos.datahub.measurements.monitoring.Application;
import io.intino.cosmos.datahub.measurements.monitoring.Camera;
import io.intino.cosmos.datahub.measurements.monitoring.CellularGateway;
import io.intino.cosmos.datahub.measurements.monitoring.Computer;
import io.intino.cosmos.datahub.measurements.monitoring.Switch;
import io.intino.cosmos.datahub.measurements.monitoring.Wireless;
import io.intino.cosmos.datahub.messages.actuation.Assertion;
import io.intino.cosmos.datahub.messages.actuation.Pop;
import io.intino.cosmos.datahub.messages.actuation.Push;
import io.intino.cosmos.datahub.messages.monitoring.Status;
import io.intino.cosmos.datahub.messages.universe.ApplianceAssertion;
import io.intino.cosmos.datahub.messages.universe.ApplicationAssertion;
import io.intino.cosmos.datahub.messages.universe.ApplicationJavaAssertion;
import io.intino.cosmos.datahub.messages.universe.AreaAssertion;
import io.intino.cosmos.datahub.messages.universe.AssetAssertion;
import io.intino.cosmos.datahub.messages.universe.ComputerAssertion;
import io.intino.cosmos.datahub.messages.universe.HardwareAssertion;
import io.intino.cosmos.datahub.messages.universe.IncidentRuleAssertion;
import io.intino.cosmos.datahub.messages.universe.ModelAssertion;
import io.intino.cosmos.datahub.messages.universe.ObserverAssertion;
import io.intino.cosmos.datahub.messages.universe.OrderTypeAssertion;
import io.intino.cosmos.datahub.messages.universe.PartAssertion;
import io.intino.cosmos.datahub.messages.universe.PersonAssertion;
import io.intino.cosmos.datahub.messages.universe.PlaceAssertion;
import io.intino.cosmos.datahub.messages.universe.ProcessAssertion;
import io.intino.cosmos.datahub.messages.universe.ServiceAssertion;
import io.intino.cosmos.datahub.messages.universe.SoftwareAssertion;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.apache.activemq.command.ActiveMQTextMessage;

public class MonetTerminal {
    public static String[] subscriptionChannels = new String[0];
    private final Connector connector;
    private final Set<BiConsumer> datamartConsumers = new HashSet<BiConsumer>();
    private final DatamartsRetryConfig datamartsRetryConfig;
    private String sourceSelector;
    private final Map<BiConsumer<?, String>, List<Consumer<Event>>> consumers = new HashMap();
    private volatile MasterDatamartImpl datamart;
    private final Object monitor = new Object();

    public MonetTerminal(Connector connector) {
        this(connector, new DatamartsRetryConfig());
    }

    public MonetTerminal(Connector connector, DatamartsRetryConfig datamartsRetryConfig) {
        this.connector = connector;
        this.datamartsRetryConfig = datamartsRetryConfig;
        this.datamart = new MasterDatamartImpl(connector, datamartsRetryConfig);
    }

    public MasterDatamart datamart() {
        return this.datamart;
    }

    public void initDatamarts() {
        this.initDatamarts(null);
    }

    public void initDatamarts(String sourceSelector) {
        this.sourceSelector = sourceSelector;
        this.datamart.init(sourceSelector);
        this.addDatamartSubscribers(sourceSelector);
    }

    public void publish(Event event) {
        switch (event.type()) {
            case "Assertion": {
                Assertion e;
                this.publish(event instanceof Assertion ? (e = (Assertion)event) : new Assertion(((MessageEvent)event).toMessage()));
                break;
            }
            case "Push": {
                Push e;
                this.publish(event instanceof Push ? (e = (Push)event) : new Push(((MessageEvent)event).toMessage()));
                break;
            }
            case "Pop": {
                Pop e;
                this.publish(event instanceof Pop ? (e = (Pop)event) : new Pop(((MessageEvent)event).toMessage()));
                break;
            }
            default: {
                Logger.warn((String)(this.getClass().getSimpleName() + " is not configured to publish " + event.type() + " events."));
            }
        }
    }

    public void publish(Event first, Event ... others) {
        this.publish(Stream.concat(Stream.of(first), Arrays.stream(others)));
    }

    public void publish(Event[] events) {
        this.publish(Arrays.stream(events));
    }

    public void publish(Collection<Event> events) {
        this.publish(events.stream());
    }

    public void publish(Stream<Event> events) {
        events.filter(e -> this.channelOf(e.type()) != null).collect(Collectors.groupingBy(Event::type)).forEach((type, eventList) -> this.connector.sendEvents(this.channelOf((String)type), eventList));
    }

    public Datalake datalake() {
        try {
            Message message = this.connector.requestResponse("service.ness.datalake", this.request("Datalake"), 5L, TimeUnit.SECONDS);
            if (message == null) {
                return null;
            }
            String path = ((TextMessage)message).getText();
            if (path == null) {
                return null;
            }
            return new File(path).exists() ? new FileDatalake(new File(path)) : new RemoteDatalake((JmsConnector)this.connector);
        }
        catch (JMSException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public BatchSession batch(File temporalStageDirectory) {
        return new BatchSession(temporalStageDirectory);
    }

    public BatchSession batch(File temporalStageDirectory, Config config) {
        return new BatchSession(temporalStageDirectory, config);
    }

    public void publish(Assertion e) {
        this.connector.sendEvent("actuation.Assertion", (Event)e);
    }

    public void publish(Assertion first, Assertion ... others) {
        Assertion[] array = new Assertion[1 + others.length];
        array[0] = first;
        System.arraycopy(others, 0, array, 1, others.length);
        this.publish(array);
    }

    public void publish(Assertion[] events) {
        this.connector.sendEvents("actuation.Assertion", Arrays.asList(events));
    }

    public void publish(Push e) {
        this.connector.sendEvent("actuation.Push", (Event)e);
    }

    public void publish(Push first, Push ... others) {
        Push[] array = new Push[1 + others.length];
        array[0] = first;
        System.arraycopy(others, 0, array, 1, others.length);
        this.publish(array);
    }

    public void publish(Push[] events) {
        this.connector.sendEvents("actuation.Push", Arrays.asList(events));
    }

    public void publish(Pop e) {
        this.connector.sendEvent("actuation.Pop", (Event)e);
    }

    public void publish(Pop first, Pop ... others) {
        Pop[] array = new Pop[1 + others.length];
        array[0] = first;
        System.arraycopy(others, 0, array, 1, others.length);
        this.publish(array);
    }

    public void publish(Pop[] events) {
        this.connector.sendEvents("actuation.Pop", Arrays.asList(events));
    }

    public void subscribe(ActuationAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new Assertion((MessageEvent)event), "actuation.Assertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("actuation.Assertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(ActuationAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new Assertion((MessageEvent)event), "actuation.Assertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("actuation.Assertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(ActuationAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new Assertion((MessageEvent)event), "actuation.Assertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("actuation.Assertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(ActuationAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new Assertion((MessageEvent)event), "actuation.Assertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("actuation.Assertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(ActuationAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(arg_0 -> ((Connector)this.connector).detachListeners(arg_0));
    }

    public void subscribe(ActuationPushConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new Push((MessageEvent)event), "actuation.Push");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("actuation.Push", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(ActuationPushConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new Push((MessageEvent)event), "actuation.Push");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("actuation.Push", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(ActuationPushConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new Push((MessageEvent)event), "actuation.Push");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("actuation.Push", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(ActuationPushConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new Push((MessageEvent)event), "actuation.Push");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("actuation.Push", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(ActuationPushConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(arg_0 -> ((Connector)this.connector).detachListeners(arg_0));
    }

    public void subscribe(ActuationPopConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new Pop((MessageEvent)event), "actuation.Pop");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("actuation.Pop", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(ActuationPopConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new Pop((MessageEvent)event), "actuation.Pop");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("actuation.Pop", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(ActuationPopConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new Pop((MessageEvent)event), "actuation.Pop");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("actuation.Pop", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(ActuationPopConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new Pop((MessageEvent)event), "actuation.Pop");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("actuation.Pop", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(ActuationPopConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(arg_0 -> ((Connector)this.connector).detachListeners(arg_0));
    }

    public void subscribe(UniversePlaceAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new PlaceAssertion((MessageEvent)event), "universe.PlaceAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.PlaceAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniversePlaceAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new PlaceAssertion((MessageEvent)event), "universe.PlaceAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.PlaceAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniversePlaceAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new PlaceAssertion((MessageEvent)event), "universe.PlaceAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.PlaceAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniversePlaceAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new PlaceAssertion((MessageEvent)event), "universe.PlaceAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.PlaceAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniversePlaceAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(arg_0 -> ((Connector)this.connector).detachListeners(arg_0));
    }

    public void subscribe(UniverseAreaAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new AreaAssertion((MessageEvent)event), "universe.AreaAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.AreaAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniverseAreaAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new AreaAssertion((MessageEvent)event), "universe.AreaAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.AreaAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniverseAreaAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new AreaAssertion((MessageEvent)event), "universe.AreaAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.AreaAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniverseAreaAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new AreaAssertion((MessageEvent)event), "universe.AreaAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.AreaAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniverseAreaAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(arg_0 -> ((Connector)this.connector).detachListeners(arg_0));
    }

    public void subscribe(UniverseIncidentRuleAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new IncidentRuleAssertion((MessageEvent)event), "universe.IncidentRuleAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.IncidentRuleAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniverseIncidentRuleAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new IncidentRuleAssertion((MessageEvent)event), "universe.IncidentRuleAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.IncidentRuleAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniverseIncidentRuleAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new IncidentRuleAssertion((MessageEvent)event), "universe.IncidentRuleAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.IncidentRuleAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniverseIncidentRuleAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new IncidentRuleAssertion((MessageEvent)event), "universe.IncidentRuleAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.IncidentRuleAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniverseIncidentRuleAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(arg_0 -> ((Connector)this.connector).detachListeners(arg_0));
    }

    public void subscribe(UniverseModelAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ModelAssertion((MessageEvent)event), "universe.ModelAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.ModelAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniverseModelAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ModelAssertion((MessageEvent)event), "universe.ModelAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.ModelAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniverseModelAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ModelAssertion((MessageEvent)event), "universe.ModelAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.ModelAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniverseModelAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ModelAssertion((MessageEvent)event), "universe.ModelAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.ModelAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniverseModelAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(arg_0 -> ((Connector)this.connector).detachListeners(arg_0));
    }

    public void subscribe(UniverseOrderTypeAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new OrderTypeAssertion((MessageEvent)event), "universe.OrderTypeAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.OrderTypeAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniverseOrderTypeAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new OrderTypeAssertion((MessageEvent)event), "universe.OrderTypeAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.OrderTypeAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniverseOrderTypeAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new OrderTypeAssertion((MessageEvent)event), "universe.OrderTypeAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.OrderTypeAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniverseOrderTypeAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new OrderTypeAssertion((MessageEvent)event), "universe.OrderTypeAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.OrderTypeAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniverseOrderTypeAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(arg_0 -> ((Connector)this.connector).detachListeners(arg_0));
    }

    public void subscribe(UniversePersonAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new PersonAssertion((MessageEvent)event), "universe.PersonAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.PersonAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniversePersonAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new PersonAssertion((MessageEvent)event), "universe.PersonAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.PersonAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniversePersonAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new PersonAssertion((MessageEvent)event), "universe.PersonAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.PersonAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniversePersonAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new PersonAssertion((MessageEvent)event), "universe.PersonAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.PersonAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniversePersonAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(arg_0 -> ((Connector)this.connector).detachListeners(arg_0));
    }

    public void subscribe(UniverseProcessAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ProcessAssertion((MessageEvent)event), "universe.ProcessAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.ProcessAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniverseProcessAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ProcessAssertion((MessageEvent)event), "universe.ProcessAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.ProcessAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniverseProcessAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ProcessAssertion((MessageEvent)event), "universe.ProcessAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.ProcessAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniverseProcessAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ProcessAssertion((MessageEvent)event), "universe.ProcessAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.ProcessAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniverseProcessAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(arg_0 -> ((Connector)this.connector).detachListeners(arg_0));
    }

    public void subscribe(UniverseAssetAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new AssetAssertion((MessageEvent)event), "universe.AssetAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.AssetAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniverseAssetAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new AssetAssertion((MessageEvent)event), "universe.AssetAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.AssetAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniverseAssetAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new AssetAssertion((MessageEvent)event), "universe.AssetAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.AssetAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniverseAssetAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new AssetAssertion((MessageEvent)event), "universe.AssetAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.AssetAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniverseAssetAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(arg_0 -> ((Connector)this.connector).detachListeners(arg_0));
    }

    public void subscribe(UniversePartAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new PartAssertion((MessageEvent)event), "universe.PartAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.PartAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniversePartAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new PartAssertion((MessageEvent)event), "universe.PartAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.PartAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniversePartAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new PartAssertion((MessageEvent)event), "universe.PartAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.PartAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniversePartAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new PartAssertion((MessageEvent)event), "universe.PartAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.PartAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniversePartAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(arg_0 -> ((Connector)this.connector).detachListeners(arg_0));
    }

    public void subscribe(UniverseHardwareAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new HardwareAssertion((MessageEvent)event), "universe.HardwareAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.HardwareAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniverseHardwareAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new HardwareAssertion((MessageEvent)event), "universe.HardwareAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.HardwareAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniverseHardwareAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new HardwareAssertion((MessageEvent)event), "universe.HardwareAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.HardwareAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniverseHardwareAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new HardwareAssertion((MessageEvent)event), "universe.HardwareAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.HardwareAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniverseHardwareAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(arg_0 -> ((Connector)this.connector).detachListeners(arg_0));
    }

    public void subscribe(UniverseApplianceAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ApplianceAssertion((MessageEvent)event), "universe.ApplianceAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.ApplianceAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniverseApplianceAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ApplianceAssertion((MessageEvent)event), "universe.ApplianceAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.ApplianceAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniverseApplianceAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ApplianceAssertion((MessageEvent)event), "universe.ApplianceAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.ApplianceAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniverseApplianceAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ApplianceAssertion((MessageEvent)event), "universe.ApplianceAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.ApplianceAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniverseApplianceAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(arg_0 -> ((Connector)this.connector).detachListeners(arg_0));
    }

    public void subscribe(UniverseComputerAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ComputerAssertion((MessageEvent)event), "universe.ComputerAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.ComputerAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniverseComputerAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ComputerAssertion((MessageEvent)event), "universe.ComputerAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.ComputerAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniverseComputerAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ComputerAssertion((MessageEvent)event), "universe.ComputerAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.ComputerAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniverseComputerAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ComputerAssertion((MessageEvent)event), "universe.ComputerAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.ComputerAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniverseComputerAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(arg_0 -> ((Connector)this.connector).detachListeners(arg_0));
    }

    public void subscribe(UniverseSoftwareAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new SoftwareAssertion((MessageEvent)event), "universe.SoftwareAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.SoftwareAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniverseSoftwareAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new SoftwareAssertion((MessageEvent)event), "universe.SoftwareAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.SoftwareAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniverseSoftwareAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new SoftwareAssertion((MessageEvent)event), "universe.SoftwareAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.SoftwareAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniverseSoftwareAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new SoftwareAssertion((MessageEvent)event), "universe.SoftwareAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.SoftwareAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniverseSoftwareAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(arg_0 -> ((Connector)this.connector).detachListeners(arg_0));
    }

    public void subscribe(UniverseObserverAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ObserverAssertion((MessageEvent)event), "universe.ObserverAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.ObserverAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniverseObserverAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ObserverAssertion((MessageEvent)event), "universe.ObserverAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.ObserverAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniverseObserverAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ObserverAssertion((MessageEvent)event), "universe.ObserverAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.ObserverAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniverseObserverAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ObserverAssertion((MessageEvent)event), "universe.ObserverAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.ObserverAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniverseObserverAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(arg_0 -> ((Connector)this.connector).detachListeners(arg_0));
    }

    public void subscribe(UniverseServiceAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ServiceAssertion((MessageEvent)event), "universe.ServiceAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.ServiceAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniverseServiceAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ServiceAssertion((MessageEvent)event), "universe.ServiceAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.ServiceAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniverseServiceAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ServiceAssertion((MessageEvent)event), "universe.ServiceAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.ServiceAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniverseServiceAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ServiceAssertion((MessageEvent)event), "universe.ServiceAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.ServiceAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniverseServiceAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(arg_0 -> ((Connector)this.connector).detachListeners(arg_0));
    }

    public void subscribe(UniverseApplicationAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ApplicationAssertion((MessageEvent)event), "universe.ApplicationAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.ApplicationAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniverseApplicationAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ApplicationAssertion((MessageEvent)event), "universe.ApplicationAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.ApplicationAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniverseApplicationAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ApplicationAssertion((MessageEvent)event), "universe.ApplicationAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.ApplicationAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniverseApplicationAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ApplicationAssertion((MessageEvent)event), "universe.ApplicationAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.ApplicationAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniverseApplicationAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(arg_0 -> ((Connector)this.connector).detachListeners(arg_0));
    }

    public void subscribe(UniverseApplicationJavaAssertionConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ApplicationJavaAssertion((MessageEvent)event), "universe.ApplicationJavaAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.ApplicationJavaAssertion", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(UniverseApplicationJavaAssertionConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ApplicationJavaAssertion((MessageEvent)event), "universe.ApplicationJavaAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.ApplicationJavaAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(UniverseApplicationJavaAssertionConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ApplicationJavaAssertion((MessageEvent)event), "universe.ApplicationJavaAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.ApplicationJavaAssertion", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(UniverseApplicationJavaAssertionConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ApplicationJavaAssertion((MessageEvent)event), "universe.ApplicationJavaAssertion");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("universe.ApplicationJavaAssertion", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(UniverseApplicationJavaAssertionConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(arg_0 -> ((Connector)this.connector).detachListeners(arg_0));
    }

    public void subscribe(MonitoringComputerConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Computer(((MessageEvent)event).toMessage()) : (Computer)event, "monitoring.Computer");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("monitoring.Computer", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(MonitoringComputerConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Computer(((MessageEvent)event).toMessage()) : (Computer)event, "monitoring.Computer");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("monitoring.Computer", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(MonitoringComputerConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Computer(((MessageEvent)event).toMessage()) : (Computer)event, "monitoring.Computer");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("monitoring.Computer", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(MonitoringComputerConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Computer(((MessageEvent)event).toMessage()) : (Computer)event, "monitoring.Computer");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("monitoring.Computer", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(MonitoringComputerConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(arg_0 -> ((Connector)this.connector).detachListeners(arg_0));
    }

    public void subscribe(MonitoringSwitchConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Switch(((MessageEvent)event).toMessage()) : (Switch)event, "monitoring.Switch");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("monitoring.Switch", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(MonitoringSwitchConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Switch(((MessageEvent)event).toMessage()) : (Switch)event, "monitoring.Switch");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("monitoring.Switch", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(MonitoringSwitchConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Switch(((MessageEvent)event).toMessage()) : (Switch)event, "monitoring.Switch");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("monitoring.Switch", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(MonitoringSwitchConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Switch(((MessageEvent)event).toMessage()) : (Switch)event, "monitoring.Switch");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("monitoring.Switch", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(MonitoringSwitchConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(arg_0 -> ((Connector)this.connector).detachListeners(arg_0));
    }

    public void subscribe(MonitoringCellularGatewayConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new CellularGateway(((MessageEvent)event).toMessage()) : (CellularGateway)event, "monitoring.CellularGateway");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("monitoring.CellularGateway", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(MonitoringCellularGatewayConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new CellularGateway(((MessageEvent)event).toMessage()) : (CellularGateway)event, "monitoring.CellularGateway");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("monitoring.CellularGateway", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(MonitoringCellularGatewayConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new CellularGateway(((MessageEvent)event).toMessage()) : (CellularGateway)event, "monitoring.CellularGateway");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("monitoring.CellularGateway", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(MonitoringCellularGatewayConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new CellularGateway(((MessageEvent)event).toMessage()) : (CellularGateway)event, "monitoring.CellularGateway");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("monitoring.CellularGateway", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(MonitoringCellularGatewayConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(arg_0 -> ((Connector)this.connector).detachListeners(arg_0));
    }

    public void subscribe(MonitoringWirelessConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Wireless(((MessageEvent)event).toMessage()) : (Wireless)event, "monitoring.Wireless");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("monitoring.Wireless", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(MonitoringWirelessConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Wireless(((MessageEvent)event).toMessage()) : (Wireless)event, "monitoring.Wireless");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("monitoring.Wireless", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(MonitoringWirelessConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Wireless(((MessageEvent)event).toMessage()) : (Wireless)event, "monitoring.Wireless");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("monitoring.Wireless", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(MonitoringWirelessConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Wireless(((MessageEvent)event).toMessage()) : (Wireless)event, "monitoring.Wireless");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("monitoring.Wireless", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(MonitoringWirelessConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(arg_0 -> ((Connector)this.connector).detachListeners(arg_0));
    }

    public void subscribe(MonitoringCameraConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Camera(((MessageEvent)event).toMessage()) : (Camera)event, "monitoring.Camera");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("monitoring.Camera", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(MonitoringCameraConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Camera(((MessageEvent)event).toMessage()) : (Camera)event, "monitoring.Camera");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("monitoring.Camera", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(MonitoringCameraConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Camera(((MessageEvent)event).toMessage()) : (Camera)event, "monitoring.Camera");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("monitoring.Camera", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(MonitoringCameraConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Camera(((MessageEvent)event).toMessage()) : (Camera)event, "monitoring.Camera");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("monitoring.Camera", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(MonitoringCameraConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(arg_0 -> ((Connector)this.connector).detachListeners(arg_0));
    }

    public void subscribe(MonitoringApplicationConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Application(((MessageEvent)event).toMessage()) : (Application)event, "monitoring.Application");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("monitoring.Application", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(MonitoringApplicationConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Application(((MessageEvent)event).toMessage()) : (Application)event, "monitoring.Application");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("monitoring.Application", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(MonitoringApplicationConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Application(((MessageEvent)event).toMessage()) : (Application)event, "monitoring.Application");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("monitoring.Application", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(MonitoringApplicationConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(event instanceof MessageEvent ? new Application(((MessageEvent)event).toMessage()) : (Application)event, "monitoring.Application");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("monitoring.Application", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(MonitoringApplicationConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(arg_0 -> ((Connector)this.connector).detachListeners(arg_0));
    }

    public void subscribe(MonitoringStatusConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new Status((MessageEvent)event), "monitoring.Status");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("monitoring.Status", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(MonitoringStatusConsumer onEventReceived, String subscriberId, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new Status((MessageEvent)event), "monitoring.Status");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("monitoring.Status", subscriberId, this.consumers.get(onEventReceived).get(0), sourceSelector);
    }

    public void subscribe(MonitoringStatusConsumer onEventReceived, String subscriberId, Predicate<Instant> filter, String sourceSelector) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new Status((MessageEvent)event), "monitoring.Status");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("monitoring.Status", subscriberId, this.consumers.get(onEventReceived).get(0), filter, sourceSelector);
    }

    public void subscribe(MonitoringStatusConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new Status((MessageEvent)event), "monitoring.Status");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("monitoring.Status", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(MonitoringStatusConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(arg_0 -> ((Connector)this.connector).detachListeners(arg_0));
    }

    public synchronized void requestSeal() {
        this.connector.requestResponse("service.ness.seal", this.request("Seal"), 30L, TimeUnit.MINUTES);
    }

    public synchronized Instant requestLastSeal() {
        Message message = this.connector.requestResponse("service.ness.seal.last", this.request("LastSeal"), 10L, TimeUnit.MINUTES);
        if (message == null) {
            return Instant.now();
        }
        try {
            return Instant.parse(((TextMessage)message).getText());
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return Instant.now();
        }
    }

    private Message request(String type) {
        return this.request(type, Collections.emptyMap());
    }

    private Message request(String type, Map<String, String> attributes) {
        try {
            ActiveMQTextMessage m = new ActiveMQTextMessage();
            io.intino.alexandria.message.Message message = new io.intino.alexandria.message.Message(type);
            attributes.forEach((arg_0, arg_1) -> ((io.intino.alexandria.message.Message)message).set(arg_0, arg_1));
            m.setText(message.toString());
            return m;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addDatamartSubscribers(String sourceSelector) {
        this.addDatamartEventSubscribers(sourceSelector, ts -> ts.isAfter(this.datamart.ts()));
        this.connector.attachListener("service.ness.datamarts", null, (m, c) -> new Thread(() -> this.manageDatamartMessage(m)).start());
    }

    private void addDatamartEventSubscribers(String sourceSelector, Predicate<Instant> predicate) {
        this.datamartConsumers.clear();
        BiConsumer<Wireless, String> subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((MonitoringWirelessConsumer)subscriber, this.connector.clientId() + "_master_Wireless", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((MonitoringStatusConsumer)subscriber, this.connector.clientId() + "_master_Status", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniversePlaceAssertionConsumer)subscriber, this.connector.clientId() + "_master_PlaceAssertion", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniverseIncidentRuleAssertionConsumer)subscriber, this.connector.clientId() + "_master_IncidentRuleAssertion", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniversePartAssertionConsumer)subscriber, this.connector.clientId() + "_master_PartAssertion", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniverseComputerAssertionConsumer)subscriber, this.connector.clientId() + "_master_ComputerAssertion", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniverseApplicationAssertionConsumer)subscriber, this.connector.clientId() + "_master_ApplicationAssertion", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniverseProcessAssertionConsumer)subscriber, this.connector.clientId() + "_master_ProcessAssertion", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniverseSoftwareAssertionConsumer)subscriber, this.connector.clientId() + "_master_SoftwareAssertion", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniverseObserverAssertionConsumer)subscriber, this.connector.clientId() + "_master_ObserverAssertion", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniverseHardwareAssertionConsumer)subscriber, this.connector.clientId() + "_master_HardwareAssertion", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniverseAreaAssertionConsumer)subscriber, this.connector.clientId() + "_master_AreaAssertion", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniverseApplianceAssertionConsumer)subscriber, this.connector.clientId() + "_master_ApplianceAssertion", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniverseApplicationJavaAssertionConsumer)subscriber, this.connector.clientId() + "_master_ApplicationJavaAssertion", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniverseModelAssertionConsumer)subscriber, this.connector.clientId() + "_master_ModelAssertion", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((MonitoringSwitchConsumer)subscriber, this.connector.clientId() + "_master_Switch", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((MonitoringCellularGatewayConsumer)subscriber, this.connector.clientId() + "_master_CellularGateway", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniversePersonAssertionConsumer)subscriber, this.connector.clientId() + "_master_PersonAssertion", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniverseAssetAssertionConsumer)subscriber, this.connector.clientId() + "_master_AssetAssertion", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((MonitoringComputerConsumer)subscriber, this.connector.clientId() + "_master_Computer", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniverseOrderTypeAssertionConsumer)subscriber, this.connector.clientId() + "_master_OrderTypeAssertion", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((UniverseServiceAssertionConsumer)subscriber, this.connector.clientId() + "_master_ServiceAssertion", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((MonitoringCameraConsumer)subscriber, this.connector.clientId() + "_master_Camera", predicate, sourceSelector);
        subscriber = (event, topic) -> this.datamart.mount((Event)event);
        this.datamartConsumers.add(subscriber);
        this.subscribe((MonitoringApplicationConsumer)subscriber, this.connector.clientId() + "_master_Application", predicate, sourceSelector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void manageDatamartMessage(String message) {
        Object object = this.monitor;
        synchronized (object) {
            JsonObject jsonObject = (JsonObject)Json.fromJson((String)message, JsonObject.class);
            String operation = jsonObject.getAsJsonPrimitive("operation").getAsString();
            if (operation.equals("reload")) {
                this.datamartConsumers.forEach(c -> this.consumers.get(c).forEach(arg_0 -> ((Connector)this.connector).detachListeners(arg_0)));
                MasterDatamartImpl temporal = new MasterDatamartImpl(this.connector, this.datamartsRetryConfig);
                temporal.init(this.sourceSelector);
                this.datamart = temporal;
                this.addDatamartEventSubscribers(this.sourceSelector, ts -> ts.isAfter(temporal.ts()));
            }
        }
    }

    private String channelOf(String type) {
        return switch (type) {
            case "Assertion" -> "actuation.Assertion";
            case "Push" -> "actuation.Push";
            case "Pop" -> "actuation.Pop";
            default -> null;
        };
    }

    public static class DatamartsRetryConfig {
        public final long initialTimeoutAmount;
        public final TimeUnit timeoutUnit;
        public final float timeoutMultiplier;
        public final int maxAttempts;

        public DatamartsRetryConfig() {
            this(1L, TimeUnit.MINUTES, 2.0f, 5);
        }

        public DatamartsRetryConfig(long initialTimeoutAmount, TimeUnit timeoutUnit, float timeoutMultiplier, int maxAttempts) {
            this.initialTimeoutAmount = initialTimeoutAmount;
            this.timeoutUnit = timeoutUnit;
            this.timeoutMultiplier = timeoutMultiplier;
            this.maxAttempts = maxAttempts;
        }
    }

    public class BatchSession {
        private final File temporalStage;
        private final SessionHandler sessionHandler;
        private final EventSession session;
        private final Scale scale;

        public BatchSession(File temporalStage) {
            this(temporalStage, new Config());
        }

        public BatchSession(File temporalStage, Config config) {
            this.temporalStage = temporalStage;
            this.scale = config.scale;
            this.sessionHandler = new SessionHandler(temporalStage);
            this.session = this.sessionHandler.createEventSession(config.eventsBufferSize);
        }

        public void feed(Event event) throws IOException {
            this.session.put(this.tankOf(event), event.ss(), Timetag.of((Instant)event.ts(), (Scale)this.scale), event.format(), new Event[]{event});
        }

        public void feed(Event event, Scale scale) throws IOException {
            this.session.put(this.tankOf(event), event.ss(), Timetag.of((Instant)event.ts(), (Scale)scale), event.format(), new Event[]{event});
        }

        public void flush() {
            this.session.flush();
        }

        public void push(File dataHubStage) {
            this.session.close();
            this.sessionHandler.pushTo(dataHubStage);
        }

        public void push(String host, String user, String dataHubStageAbsolutePath) {
            this.session.close();
            try {
                List<File> files = BatchSession.allFilesIn(this.temporalStage.toPath(), path -> path.getName().endsWith(".session")).collect(Collectors.toList());
                this.upload(files, host, user, dataHubStageAbsolutePath);
                this.temporalStage.renameTo(new File(this.temporalStage.getParentFile(), this.temporalStage.getName() + ".treated"));
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
            }
        }

        private static Stream<File> allFilesIn(Path path, Predicate<File> filter) throws Exception {
            Stream.Builder streamBuilder = Stream.builder();
            try (Stream<Path> paths = Files.walk(path, new FileVisitOption[0]);){
                paths.filter(p -> Files.isRegularFile(p, new LinkOption[0]) && filter.test(p.toFile())).forEach(p -> streamBuilder.add(p.toFile()));
            }
            return streamBuilder.build();
        }

        public synchronized void seal() {
            MonetTerminal.this.connector.requestResponse("service.ness.seal", MonetTerminal.this.request("Seal", Map.of("stage", this.temporalStage.getName())));
        }

        private void upload(List<File> sessions, String host, String user, String dataHubStageAbsolutePath) {
            try {
                String connectionChain = user + "@" + host + ":" + dataHubStageAbsolutePath;
                Logger.info((String)("Uploading sessions to " + connectionChain + "..."));
                for (File s : sessions) {
                    Process process = new ProcessBuilder("scp", s.getAbsolutePath(), connectionChain).inheritIO().start();
                    process.waitFor(1L, TimeUnit.HOURS);
                }
                Logger.info((String)"sessions uploaded");
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
        }

        private String tankOf(Event event) {
            if (event instanceof Assertion) {
                return "actuation.Assertion";
            }
            if (event instanceof Push) {
                return "actuation.Push";
            }
            if (event instanceof Pop) {
                return "actuation.Pop";
            }
            return event.type();
        }
    }

    public static class Config {
        private int eventsBufferSize = 1000000;
        private int setsBufferSize = 1000000;
        private Scale scale = Scale.Day;

        public Config scale(Scale scale) {
            this.scale = scale;
            return this;
        }

        public Config eventsBufferSize(int eventsBufferSize) {
            this.eventsBufferSize = eventsBufferSize;
            return this;
        }

        public Config setsBufferSize(int setsBufferSize) {
            this.setsBufferSize = setsBufferSize;
            return this;
        }
    }

    public static interface ActuationAssertionConsumer
    extends BiConsumer<Assertion, String> {
    }

    public static interface ActuationPushConsumer
    extends BiConsumer<Push, String> {
    }

    public static interface ActuationPopConsumer
    extends BiConsumer<Pop, String> {
    }

    public static interface UniversePlaceAssertionConsumer
    extends BiConsumer<PlaceAssertion, String> {
    }

    public static interface UniverseAreaAssertionConsumer
    extends BiConsumer<AreaAssertion, String> {
    }

    public static interface UniverseIncidentRuleAssertionConsumer
    extends BiConsumer<IncidentRuleAssertion, String> {
    }

    public static interface UniverseModelAssertionConsumer
    extends BiConsumer<ModelAssertion, String> {
    }

    public static interface UniverseOrderTypeAssertionConsumer
    extends BiConsumer<OrderTypeAssertion, String> {
    }

    public static interface UniversePersonAssertionConsumer
    extends BiConsumer<PersonAssertion, String> {
    }

    public static interface UniverseProcessAssertionConsumer
    extends BiConsumer<ProcessAssertion, String> {
    }

    public static interface UniverseAssetAssertionConsumer
    extends BiConsumer<AssetAssertion, String> {
    }

    public static interface UniversePartAssertionConsumer
    extends BiConsumer<PartAssertion, String> {
    }

    public static interface UniverseHardwareAssertionConsumer
    extends BiConsumer<HardwareAssertion, String> {
    }

    public static interface UniverseApplianceAssertionConsumer
    extends BiConsumer<ApplianceAssertion, String> {
    }

    public static interface UniverseComputerAssertionConsumer
    extends BiConsumer<ComputerAssertion, String> {
    }

    public static interface UniverseSoftwareAssertionConsumer
    extends BiConsumer<SoftwareAssertion, String> {
    }

    public static interface UniverseObserverAssertionConsumer
    extends BiConsumer<ObserverAssertion, String> {
    }

    public static interface UniverseServiceAssertionConsumer
    extends BiConsumer<ServiceAssertion, String> {
    }

    public static interface UniverseApplicationAssertionConsumer
    extends BiConsumer<ApplicationAssertion, String> {
    }

    public static interface UniverseApplicationJavaAssertionConsumer
    extends BiConsumer<ApplicationJavaAssertion, String> {
    }

    public static interface MonitoringComputerConsumer
    extends BiConsumer<Computer, String> {
    }

    public static interface MonitoringSwitchConsumer
    extends BiConsumer<Switch, String> {
    }

    public static interface MonitoringCellularGatewayConsumer
    extends BiConsumer<CellularGateway, String> {
    }

    public static interface MonitoringWirelessConsumer
    extends BiConsumer<Wireless, String> {
    }

    public static interface MonitoringCameraConsumer
    extends BiConsumer<Camera, String> {
    }

    public static interface MonitoringApplicationConsumer
    extends BiConsumer<Application, String> {
    }

    public static interface MonitoringStatusConsumer
    extends BiConsumer<Status, String> {
    }
}

