package io.intino.cosmos.datahub.datamarts.master.mounters;

import io.intino.ness.master.Datamart.EntityListener;
import io.intino.cosmos.datahub.datamarts.master.MasterDatamart;

import java.time.*;
import java.util.*;
import java.util.stream.*;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.cosmos.datahub.datamarts.master.MasterEntity;
import io.intino.cosmos.datahub.datamarts.master.entities.IncidentRule;

import static io.intino.cosmos.datahub.datamarts.master.MasterMounter.Operation.*;

public class IncidentRuleMounter implements io.intino.cosmos.datahub.datamarts.master.MasterMounter {

	private final MasterDatamart.Entities entities;
	private final List<EntityListener> listeners;

	public IncidentRuleMounter(MasterDatamart.Entities entities, List<EntityListener> listeners) {
		this.entities = entities;
		this.listeners = listeners;
	}

	@Override
	public void mount(Event event) {
		Message message = ((MessageEvent)event).toMessage();
		String id = message.get("id").asString();
		Operation[] operation = {Update};
		MasterEntity entity = findOrCreateEntity(id, operation);
		updateAttributes(message, operation, entity);
		if(operation[0] != Skip) notifyListeners(operation[0], entity);
	}

	private void updateAttributes(Message message, Operation[] operation, MasterEntity owner) {
		for(String attr : message.attributes()) {
			update(owner, attr, parse(attr, message));
			if(attr.equals("enabled") && !message.get("enabled").asBoolean()) {
				operation[0] = operation[0] == Create ? Skip : Remove;
				entities.remove(owner.id());
				return;
			}
		}
	}

	private MasterEntity findOrCreateEntity(String id, Operation[] operation) {
		MasterEntity entity = entities.get(io.intino.cosmos.datahub.datamarts.master.entities.IncidentRule.definition, id);
		if(entity == null) {
			entity = new IncidentRule(id, entities.datamart());
			entities.add(entity);
			operation[0] = Create;
		}
		return entity;
	}

	private void notifyListeners(Operation operation, MasterEntity entity) {
		for(EntityListener listener : listeners) {
			switch(operation) {
				case Create: listener.onCreate(entity); break;
				case Update: listener.onUpdate(entity); break;
				case Remove: listener.onRemove(entity); break;
			}
		}
	}

	private Object parse(String attribute, Message message) {
		if(message.get(attribute).isNull()) return null;
		switch(attribute) {
			case "description": return parseDescription(message);
			case "target": return parseTarget(message);
			case "model": return parseModel(message);
			case "level": return parseLevel(message);
			case "tracking": return parseTracking(message);
			case "triggers": return parseTriggers(message);
			case "precondition": return parsePrecondition(message);
			case "condition": return parseCondition(message);
			case "countermeasures": return parseCountermeasures(message);
			case "orderTypes": return parseOrderTypes(message);
		}
		return message.get(attribute).asString();
	}

	private String parseDescription(Message m) {
		return m.get("description").as(String.class);
	}

	private String parseTarget(Message m) {
		return m.get("target").as(String.class);
	}

	private String parseModel(Message m) {
		return m.get("model").as(String.class);
	}

	private io.intino.cosmos.datahub.datamarts.master.entities.IncidentRule.Level parseLevel(Message m) {
		try {
			return io.intino.cosmos.datahub.datamarts.master.entities.IncidentRule.Level.valueOf(m.get("level").asString());
		} catch(Exception ignored) {
			return null;
		}
	}

	private String parseTracking(Message m) {
		return m.get("tracking").as(String.class);
	}

	private java.util.List<String> parseTriggers(Message m) {
		var value = m.get("triggers");
		return value.data().isEmpty() ? java.util.Collections.emptyList() : value.asList(String.class);
	}

	private String parsePrecondition(Message m) {
		return m.get("precondition").as(String.class);
	}

	private String parseCondition(Message m) {
		return m.get("condition").as(String.class);
	}

	private java.util.List<String> parseCountermeasures(Message m) {
		var value = m.get("countermeasures");
		return value.data().isEmpty() ? java.util.Collections.emptyList() : value.asList(String.class);
	}

	private java.util.List<String> parseOrderTypes(Message m) {
		var value = m.get("orderTypes");
		return value.data().isEmpty() ? java.util.Collections.emptyList() : value.asList(String.class);
	}
}