/*
 * Decompiled with CFR 0.152.
 */
package smile.validation.metric;

public interface CrossEntropy {
    public static double of(int[] truth, double[][] probability) {
        if (truth.length != probability.length) {
            throw new IllegalArgumentException(String.format("The vector sizes don't match: %d != %d.", truth.length, probability.length));
        }
        int n = truth.length;
        double loss = 0.0;
        for (int i = 0; i < n; ++i) {
            loss -= Math.log(probability[i][truth[i]]);
        }
        return loss / (double)n;
    }
}

