/*
 * Decompiled with CFR 0.152.
 */
package smile.timeseries;

import smile.math.MathEx;
import smile.math.matrix.Matrix;

public interface TimeSeries {
    public static double[] diff(double[] x, int lag) {
        return TimeSeries.diff(x, lag, 1)[0];
    }

    public static double[][] diff(double[] x, int lag, int differences) {
        double[][] diff = new double[differences][];
        for (int d = 0; d < differences; ++d) {
            int n = x.length - lag;
            double[] y = new double[n];
            for (int i = 0; i < n; ++i) {
                y[i] = x[i + lag] - x[i];
            }
            diff[d] = y;
            x = diff[d];
        }
        return diff;
    }

    public static double cov(double[] x, int lag) {
        if (lag < 0) {
            lag = -lag;
        }
        int T = x.length;
        double mu = MathEx.mean(x);
        double cov = 0.0;
        for (int i = lag; i < T; ++i) {
            cov += (x[i] - mu) * (x[i - lag] - mu);
        }
        return cov;
    }

    public static double acf(double[] x, int lag) {
        if (lag == 0) {
            return 1.0;
        }
        if (lag < 0) {
            lag = -lag;
        }
        int T = x.length;
        double mu = MathEx.mean(x);
        double variance = 0.0;
        for (int i = 0; i < lag; ++i) {
            variance += MathEx.pow2(x[i] - mu);
        }
        double cov = 0.0;
        for (int i = lag; i < T; ++i) {
            cov += (x[i] - mu) * (x[i - lag] - mu);
            variance += MathEx.pow2(x[i] - mu);
        }
        return cov / variance;
    }

    public static double pacf(double[] x, int lag) {
        if (lag < 0) {
            lag = -lag;
        }
        if (lag <= 1) {
            return TimeSeries.acf(x, lag);
        }
        double[] r = new double[lag];
        for (int i = 0; i < lag; ++i) {
            r[i] = TimeSeries.acf(x, i + 1);
        }
        double[] r1 = new double[lag];
        r1[0] = 1.0;
        System.arraycopy(r, 0, r1, 1, lag - 1);
        Matrix toeplitz = Matrix.toeplitz(r1);
        Matrix.Cholesky cholesky = toeplitz.cholesky();
        double[] pacf = cholesky.solve(r);
        return pacf[lag - 1];
    }
}

