/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collector;
import java.util.stream.Stream;
import smile.data.DatasetImpl;
import smile.math.matrix.Matrix;

public interface Dataset<T> {
    default public boolean distributed() {
        return false;
    }

    public int size();

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    public T get(int var1);

    default public T apply(int i) {
        return this.get(i);
    }

    public Stream<T> stream();

    default public List<T> toList() {
        return this.stream().collect(java.util.stream.Collectors.toList());
    }

    default public String toString(int numRows) {
        StringBuilder sb = new StringBuilder();
        String top = this.stream().limit(numRows).map(Object::toString).collect(java.util.stream.Collectors.joining("\n"));
        sb.append(top);
        int rest = this.size() - numRows;
        if (rest > 0) {
            String rowsString = rest == 1 ? "row" : "rows";
            sb.append(String.format("\n%d more %s...\n", rest, rowsString));
        }
        return sb.toString();
    }

    public static <T> Dataset<T> of(Collection<T> data) {
        return new DatasetImpl<T>(data);
    }

    public static interface Collectors {
        public static <T> Collector<T, List<T>, Dataset<T>> toDataset() {
            return Collector.of(ArrayList::new, List::add, (c1, c2) -> {
                c1.addAll(c2);
                return c1;
            }, Dataset::of, new Collector.Characteristics[0]);
        }

        public static Collector<double[], List<double[]>, Matrix> toMatrix() {
            return Collector.of(ArrayList::new, List::add, (c1, c2) -> {
                c1.addAll(c2);
                return c1;
            }, container -> Matrix.of((double[][])container.toArray((T[])new double[container.size()][])), new Collector.Characteristics[0]);
        }
    }
}

