/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.representation;

import ro.hasna.ts.math.distribution.NormalDistributionDivider;
import ro.hasna.ts.math.normalization.Normalizer;
import ro.hasna.ts.math.normalization.ZNormalizer;
import ro.hasna.ts.math.representation.GenericTransformer;
import ro.hasna.ts.math.representation.PiecewiseAggregateApproximation;

public class SymbolicAggregateApproximation
implements GenericTransformer<double[], int[]> {
    private static final long serialVersionUID = -2951279057715694424L;
    private final PiecewiseAggregateApproximation paa;
    private final Normalizer normalizer;
    private final double[] breakpoints;

    public SymbolicAggregateApproximation(int segments, int alphabetSize) {
        this(new PiecewiseAggregateApproximation(segments), new ZNormalizer(), new NormalDistributionDivider().getBreakpoints(alphabetSize));
    }

    public SymbolicAggregateApproximation(int segments, double[] breakpoints) {
        this(new PiecewiseAggregateApproximation(segments), new ZNormalizer(), breakpoints);
    }

    public SymbolicAggregateApproximation(PiecewiseAggregateApproximation paa, Normalizer normalizer, double[] breakpoints) {
        this.paa = paa;
        this.normalizer = normalizer;
        this.breakpoints = breakpoints;
    }

    @Override
    public int[] transform(double[] values) {
        double[] copy = this.paa.transform(values);
        if (this.normalizer != null) {
            copy = this.normalizer.normalize(copy);
        }
        int n = 0;
        int[] result = new int[copy.length];
        for (double item : copy) {
            boolean found = false;
            for (int i = 0; i < this.breakpoints.length && !found; ++i) {
                double breakpoint = this.breakpoints[i];
                if (!(breakpoint > item)) continue;
                result[n] = i;
                found = true;
            }
            if (!found) {
                result[n] = this.breakpoints.length;
            }
            ++n;
        }
        return result;
    }

    public double[] getBreakpoints() {
        return this.breakpoints;
    }
}

