/*
 * Decompiled with CFR 0.152.
 */
package ro.hasna.ts.math.distribution;

import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import ro.hasna.ts.math.distribution.DistributionDivider;

public class UniformDistributionDivider
implements DistributionDivider {
    private static final long serialVersionUID = 3307519249593191140L;
    private final double lower;
    private final double upper;

    public UniformDistributionDivider(double lower, double upper) {
        if (lower > upper) {
            throw new NumberIsTooLargeException(lower, (Number)upper, true);
        }
        this.lower = lower;
        this.upper = upper;
    }

    @Override
    public double[] getBreakpoints(int areas) {
        if (areas < 2) {
            throw new NumberIsTooSmallException(areas, (Number)2, true);
        }
        int len = areas - 1;
        double[] result = new double[len];
        double intervalSize = (this.upper - this.lower) / (double)areas;
        for (int i = 0; i < len; ++i) {
            result[i] = this.lower + (double)(i + 1) * intervalSize;
        }
        return result;
    }
}

