/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.language.semantics.constraints.flags;

import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.MogramRoot;
import io.intino.tara.language.model.Tag;
import io.intino.tara.language.model.rules.Size;
import io.intino.tara.language.semantics.constraints.flags.FlagChecker;
import io.intino.tara.language.semantics.errorcollector.SemanticException;
import io.intino.tara.language.semantics.errorcollector.SemanticNotification;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FlagCoherenceCheckerFactory {
    private static final Map<String, FlagChecker> checkers = new HashMap<String, FlagChecker>();

    private FlagCoherenceCheckerFactory() {
    }

    public static FlagChecker get(Object key) {
        return checkers.get(key.toString());
    }

    public static SemanticException error(Mogram mogram, List<String> flags) {
        return new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, "reject.flag.combination", mogram, flags));
    }

    public static SemanticException error(String message, Mogram mogram) {
        return new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, message, mogram));
    }

    public static SemanticException error(String message, Mogram mogram, List<String> parameters) {
        return new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, message, mogram, parameters));
    }

    static {
        checkers.put(Tag.Private.name().toLowerCase(), new PrivateChecker());
        checkers.put(Tag.Feature.name().toLowerCase(), new FeatureChecker());
        checkers.put(Tag.Component.name().toLowerCase(), new ComponentChecker());
    }

    private static class PrivateChecker
    implements FlagChecker {
        private PrivateChecker() {
        }

        @Override
        public void check(Mogram mogram) throws SemanticException {
            if (mogram.flags().contains((Object)Tag.Final)) {
                throw FlagCoherenceCheckerFactory.error(mogram, Arrays.asList(Tag.Final.name(), Tag.Private.name()));
            }
        }
    }

    private static class FeatureChecker
    implements FlagChecker {
        private FeatureChecker() {
        }

        @Override
        public void check(Mogram mogram) throws SemanticException {
            if (mogram.type().equals("MetaConcept")) {
                throw FlagCoherenceCheckerFactory.error("metaconcept.cannot.be", mogram, Collections.singletonList(Tag.Feature.name()));
            }
            if (mogram.isReference() && !mogram.targetOfReference().is(Tag.Feature)) {
                throw FlagCoherenceCheckerFactory.error("declared.node.must.be", mogram, Collections.singletonList(Tag.Feature.name()));
            }
        }
    }

    private static class ComponentChecker
    implements FlagChecker {
        private ComponentChecker() {
        }

        @Override
        public void check(Mogram mogram) throws SemanticException {
            if (mogram.isReference() || !(mogram.container() instanceof MogramRoot)) {
                return;
            }
            if (mogram.isReference() && !mogram.targetOfReference().is(Tag.Component)) {
                throw FlagCoherenceCheckerFactory.error("declared.node.must.be", mogram, Collections.singletonList(Tag.Component.name()));
            }
            if (mogram.flags().contains((Object)Tag.Feature)) {
                throw FlagCoherenceCheckerFactory.error(mogram, Arrays.asList(Tag.Feature.name(), Tag.Component.name()));
            }
            Size size = mogram.container().sizeOf(mogram);
            if (size == null) {
                return;
            }
            if (size.min() != 0 || size.max() != Integer.MAX_VALUE) {
                throw FlagCoherenceCheckerFactory.error("reject.root.component.size", mogram);
            }
        }
    }
}

