/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara;

import io.intino.tara.Language;
import io.intino.tara.language.model.Facet;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.Parameter;
import io.intino.tara.language.semantics.Constraint;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class Resolver {
    private final Language language;

    public Resolver(Language language) {
        this.language = language;
    }

    public static String shortType(String absoluteType) {
        return absoluteType.contains(".") ? absoluteType.substring(absoluteType.lastIndexOf(46) + 1) : absoluteType;
    }

    public void resolve(Mogram mogram) {
        if (this.context(mogram) == null) {
            return;
        }
        this.resolveNode(mogram);
    }

    private void resolveNode(Mogram mogram) {
        this.resolve(this.context(mogram));
        List<Constraint> contextConstraints = this.contextConstraints(mogram);
        if (contextConstraints == null) {
            return;
        }
        for (Constraint constraint2 : this.components(contextConstraints)) {
            if (!this.checkComponentConstraint(mogram, constraint2)) continue;
            return;
        }
        this.metaFacets(contextConstraints).forEach(constraint -> this.checkMetaFacetConstraint(mogram, (Constraint.MetaFacet)constraint));
    }

    private List<Constraint> contextConstraints(Mogram mogram) {
        List<Constraint> constraints;
        if (mogram == null || this.language == null) {
            return Collections.emptyList();
        }
        Mogram context = this.context(mogram);
        List<Constraint> list = constraints = context != null && context.type() != null ? this.language.constraints(context.type()) : null;
        if (constraints != null && (this.isComponent(constraints, mogram) || this.isMetaFacet(constraints, mogram))) {
            return constraints;
        }
        return this.findInFacets(mogram);
    }

    private boolean isMetaFacet(List<Constraint> constraints, Mogram mogram) {
        return this.metaFacets(constraints).stream().anyMatch(constraint -> Resolver.shortType(constraint.type()).equals(mogram.type()));
    }

    private boolean isComponent(List<Constraint> context, Mogram mogram) {
        return context.stream().anyMatch(constraint -> constraint instanceof Constraint.Component && (Resolver.shortType(((Constraint.Component)constraint).type()).equals(mogram.type()) || ((Constraint.Component)constraint).type().equals(mogram.type()) || this.isOneOf((Constraint.Component)constraint, mogram.type())));
    }

    private List<Constraint.Component> components(List<Constraint> context) {
        return context.stream().filter(c -> c instanceof Constraint.Component).map(c -> (Constraint.Component)c).collect(Collectors.toList());
    }

    private List<Constraint.MetaFacet> metaFacets(List<Constraint> context) {
        return context.stream().filter(c -> c instanceof Constraint.MetaFacet).map(c -> (Constraint.MetaFacet)c).collect(Collectors.toList());
    }

    private boolean isOneOf(Constraint.Component allow, String type) {
        if (!(allow instanceof Constraint.OneOf)) {
            return false;
        }
        return ((Constraint.OneOf)allow).components().stream().anyMatch(one -> one.type().endsWith("." + type) || one.type().equals(type));
    }

    private List<Constraint> findInFacets(Mogram mogram) {
        Mogram context = this.context(mogram);
        for (Facet facet : context.appliedFacets()) {
            List<Constraint> constraints = this.language.constraints(facet.fullType());
            if (constraints == null || !this.isComponent(constraints, mogram)) continue;
            return constraints;
        }
        return null;
    }

    private String simpleType(Constraint.Facet facet) {
        return facet.type().contains(".") ? facet.type().substring(facet.type().lastIndexOf(".") + 1) : facet.type();
    }

    private boolean checkComponentConstraint(Mogram mogram, Constraint constraint) {
        if (!(constraint instanceof Constraint.Component)) {
            return false;
        }
        if (constraint instanceof Constraint.OneOf) {
            return this.checkAllowOneOf(mogram, constraint);
        }
        return this.checkAsComponent(mogram, (Constraint.Component)constraint);
    }

    private void checkMetaFacetConstraint(Mogram mogram, Constraint.MetaFacet constraint) {
        if (mogram.type() != null && Resolver.shortType(mogram.type()).equals(Resolver.shortType(constraint.type()))) {
            mogram.type(constraint.type());
        }
    }

    private boolean checkAllowOneOf(Mogram mogram, Constraint allow) {
        for (Constraint.Component one : ((Constraint.OneOf)allow).components()) {
            String absoluteType = one.type();
            if (mogram.type() == null || !Resolver.shortType(mogram.type()).equals(Resolver.shortType(absoluteType))) continue;
            mogram.type(absoluteType);
            mogram.metaTypes(this.language.types(absoluteType));
            this.resolveFacets(mogram);
            return true;
        }
        return false;
    }

    private boolean checkAsComponent(Mogram mogram, Constraint.Component allow) {
        String absoluteType = allow.type();
        if (mogram.type() != null && Resolver.shortType(mogram.type()).equals(Resolver.shortType(absoluteType))) {
            mogram.type(absoluteType);
            mogram.metaTypes(this.language.types(absoluteType));
            this.resolveFacets(mogram);
            this.resolveParameters(mogram);
            return true;
        }
        return false;
    }

    private void resolveFacets(Mogram mogram) {
        for (Facet facet : mogram.appliedFacets()) {
            Constraint.Facet constraint = this.language.constraints(mogram.type()).stream().filter(c -> c instanceof Constraint.Facet && this.simpleType((Constraint.Facet)c).equals(facet.type())).findFirst().orElse(null);
            if (constraint == null) continue;
            facet.fullType(constraint.type());
            List<Constraint.Parameter> parameterConstraints = constraint.constraints().stream().filter(c -> c instanceof Constraint.Parameter).map(c -> (Constraint.Parameter)c).collect(Collectors.toList());
            Resolver.resolveParameters(facet.parameters(), parameterConstraints);
        }
    }

    private void resolveParameters(Mogram mogram) {
        List<Constraint.Parameter> constraints = this.language.constraints(mogram.type()).stream().filter(c -> c instanceof Constraint.Parameter).map(c -> (Constraint.Parameter)c).collect(Collectors.toList());
        Resolver.resolveParameters(mogram.parameters(), constraints);
    }

    private static void resolveParameters(List<Parameter> parameters, List<Constraint.Parameter> constraints) {
        for (Parameter param : parameters) {
            Constraint.Parameter constraint = constraints.stream().filter(p -> p.name().equals(param.name()) || p.position() == param.position()).findFirst().orElse(null);
            if (constraint == null || !param.name().isEmpty() || !constraint.facet().equals(param.facet())) continue;
            param.name(constraint.name());
        }
    }

    public Mogram context(Mogram mogram) {
        if (mogram == null) {
            return null;
        }
        return mogram.container();
    }
}

