/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.chronos.timelines.blocks;

import io.intino.sumus.chronos.InvalidChronosBlockMarkException;
import io.intino.sumus.chronos.TimelineStore;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;

public class Header
implements TimelineStore.Header {
    public static final int SIZE = 512;
    public String sensor;
    public long sensorModelPosition = 0L;
    public long timeModelPosition = 0L;
    public long recordCount = 0L;
    public Instant first = Instant.EPOCH;
    public Instant last = Instant.EPOCH;
    public Instant next = Instant.EPOCH;

    public Header() {
    }

    public Header(String sensor) {
        this.setSensor(sensor);
    }

    @Override
    public String sensor() {
        return this.sensor;
    }

    @Override
    public long sensorModelPosition() {
        return this.sensorModelPosition;
    }

    @Override
    public long timeModelPosition() {
        return this.timeModelPosition;
    }

    @Override
    public long recordCount() {
        return this.recordCount;
    }

    @Override
    public Instant first() {
        return this.first == Instant.EPOCH ? null : this.first;
    }

    @Override
    public Instant last() {
        return this.last == Instant.EPOCH ? null : this.last;
    }

    @Override
    public Instant next() {
        return this.next == Instant.EPOCH ? null : this.next;
    }

    public void setSensor(String sensor) {
        if (sensor.getBytes(StandardCharsets.UTF_8).length > 255) {
            throw new IllegalArgumentException("Sensor name length must be < 255 bytes (UTF-8)");
        }
        this.sensor = sensor;
    }

    public void setTimeModel(long position, TimelineStore.TimeModel timeModel) {
        this.setInstant(timeModel);
        this.timeModelPosition = position;
    }

    public void setInstant(TimelineStore.TimeModel timeModel) {
        this.first = this.first == Instant.EPOCH || this.recordCount == 0L ? timeModel.instant() : this.first;
        this.next = timeModel.instant();
    }

    public void step(TimelineStore.TimeModel timeModel) {
        this.first = this.first == Instant.EPOCH ? this.next : this.first;
        this.last = this.next;
        this.next = timeModel.next(this.last);
        ++this.recordCount;
    }

    public void setSensorModel(long position) {
        this.sensorModelPosition = position;
    }

    public static ByteBuffer serialize(TimelineStore.Header header) {
        return Header.serialize(header, ByteBuffer.allocate(512)).clear();
    }

    public static ByteBuffer serialize(TimelineStore.Header header, ByteBuffer buffer) {
        int initialPosition = buffer.position();
        buffer.putShort((short)20485);
        buffer.putLong(header.recordCount());
        buffer.putLong(header.sensorModelPosition());
        buffer.putLong(header.timeModelPosition());
        buffer.putLong(header.first().toEpochMilli());
        buffer.putLong(header.last() == null ? Instant.EPOCH.toEpochMilli() : header.last().toEpochMilli());
        buffer.putLong(header.next().toEpochMilli());
        byte[] sensorUTF8 = header.sensor().getBytes(StandardCharsets.UTF_8);
        buffer.putShort((short)sensorUTF8.length);
        buffer.put(sensorUTF8);
        buffer.position(initialPosition + 512);
        return buffer;
    }

    public static TimelineStore.Header deserialize(ByteBuffer buffer) {
        return Header.deserialize(buffer, new Header());
    }

    public static Header deserialize(ByteBuffer buffer, Header header) {
        short mark = buffer.getShort();
        if (mark != 20485) {
            throw new InvalidChronosBlockMarkException("Header", 20485, mark);
        }
        header.recordCount = buffer.getLong();
        header.sensorModelPosition = buffer.getLong();
        header.timeModelPosition = buffer.getLong();
        header.first = Instant.ofEpochMilli(buffer.getLong());
        header.last = Instant.ofEpochMilli(buffer.getLong());
        header.next = Instant.ofEpochMilli(buffer.getLong());
        short length = buffer.getShort();
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        header.sensor = new String(bytes, StandardCharsets.UTF_8);
        return header;
    }
}

