/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.chronos;

import io.intino.sumus.chronos.Group;
import io.intino.sumus.chronos.Period;
import io.intino.sumus.chronos.Shot;
import io.intino.sumus.chronos.ShotCollector;
import io.intino.sumus.chronos.State;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Reel {
    public final Instant from;
    public final Instant to;
    public final int step;
    public final int length;
    private final Map<String, byte[]> signals;
    private final List<Group> groups;
    private static final Map<Integer, String> Chunks = Reel.createChunks();

    private Reel(Instant from, Instant to, int step, int length, Map<String, byte[]> signals, List<Group> groups) {
        this.from = from;
        this.to = to;
        this.step = step;
        this.length = length;
        this.signals = signals;
        this.groups = groups;
    }

    public String get(String signal) {
        return new Line(signal).serialize();
    }

    public List<String> signals() {
        return new ArrayList<String>(this.signals.keySet());
    }

    public List<String> signals(String group) {
        return this.signalsOf(this.find(group));
    }

    private Group find(String group) {
        return this.groups.stream().filter(g -> g.name.equals(group)).findFirst().orElse(new Group(group));
    }

    private List<String> signalsOf(Group group) {
        return group != null ? this.signals.keySet().stream().filter(group::contains).collect(Collectors.toList()) : Collections.emptyList();
    }

    private static String chunk(int i) {
        return Chunks.get(i & 0xFF);
    }

    private static Map<Integer, String> createChunks() {
        return IntStream.range(0, 256).boxed().collect(Collectors.toMap(i -> i, Reel::createChunk));
    }

    private static String createChunk(int i) {
        return Integer.toBinaryString((i & 0xFF) + 256).substring(1).replace('0', ' ').replace('1', '-');
    }

    public static class ReelBuilder
    implements ShotCollector {
        private final Instant from;
        private final Instant to;
        private final Map<Integer, String> names;
        private final Map<Integer, byte[]> signals;
        private final List<Group> groups;
        private int step;

        public ReelBuilder(Instant from, Instant to) {
            this(from, to, Collections.emptyList());
        }

        public ReelBuilder(Instant from, Instant to, List<Group> groups) {
            this.from = from;
            this.to = to;
            this.step = 1;
            this.names = new HashMap<Integer, String>();
            this.signals = new HashMap<Integer, byte[]>();
            this.groups = groups;
        }

        @Override
        public void add(Shot shot) {
            if (shot.state == State.On) {
                this.on(shot.signal, shot.ts);
            } else {
                this.off(shot.signal, shot.ts);
            }
        }

        public ReelBuilder on(String signal, Instant ts) {
            this.createSignalNameIfNotExists(signal.hashCode(), signal);
            return this.on(signal.hashCode(), ts);
        }

        private ReelBuilder on(int hash, Instant ts) {
            if (this.isInRange(ts)) {
                this.fillFrom(this.indexOf(ts), true, this.signalOf(hash));
            }
            return this;
        }

        public ReelBuilder off(String signal, Instant ts) {
            return this.off(signal.hashCode(), ts);
        }

        private ReelBuilder off(int hash, Instant ts) {
            if (this.isInRange(ts)) {
                this.fillFrom(this.indexOf(ts), false, this.signalOf(hash));
            }
            return this;
        }

        private boolean isInRange(Instant ts) {
            return ts.getEpochSecond() <= this.to.getEpochSecond();
        }

        private byte[] signalOf(int hash) {
            this.createIfNotExists(hash);
            return this.signals.get(hash);
        }

        private void createIfNotExists(int hash) {
            if (this.signals.containsKey(hash)) {
                return;
            }
            this.signals.put(hash, new byte[this.size()]);
        }

        private void createSignalNameIfNotExists(int hash, String signal) {
            if (this.names.containsKey(hash)) {
                return;
            }
            this.names.put(hash, signal);
        }

        private int size() {
            return (int)Math.ceil((double)this.length() / 8.0);
        }

        private int length() {
            return (int)this.indexOf(this.to);
        }

        private void fillFrom(long index, boolean set, byte[] values) {
            int position = (int)(index >> 3);
            if (position < 0 || position >= values.length) {
                return;
            }
            values[position] = set ? (byte)(values[position] | ReelBuilder.mask(ReelBuilder.offset(index))) : (byte)(values[position] & ~ReelBuilder.mask(ReelBuilder.offset(index)));
            byte value = (byte)(set ? 255 : 0);
            int size = this.size();
            for (int i = position + 1; i < size; ++i) {
                values[i] = value;
            }
        }

        private static byte offset(long index) {
            return (byte)(index & 7L);
        }

        private static byte mask(int offset) {
            return (byte)((1 << 8 - offset) - 1);
        }

        private long indexOf(Instant ts) {
            long index = (ts.getEpochSecond() - this.from.getEpochSecond()) / (long)this.step;
            return index >= 0L ? index : 0L;
        }

        public Reel close() {
            return new Reel(this.from, this.to, this.step, this.length(), this.consolidateSignals(), this.groups);
        }

        private Map<String, byte[]> consolidateSignals() {
            return this.signals.keySet().stream().filter(this::hasAnyNonZero).collect(Collectors.toMap(this.names::get, this.signals::get));
        }

        private boolean hasAnyNonZero(int hash) {
            return ReelBuilder.hasAnyNonZero(this.signals.get(hash));
        }

        private static boolean hasAnyNonZero(byte[] bytes) {
            return IntStream.range(0, bytes.length).anyMatch(i -> bytes[i] != 0);
        }

        public ReelBuilder by(Period period) {
            this.step = (int)period.duration();
            return this;
        }

        public ReelBuilder by(int seconds) {
            this.step = seconds;
            return this;
        }
    }

    private class Line {
        final String signal;
        final byte[] bytes;
        final boolean last;

        Line(String signal) {
            this.signal = signal;
            this.bytes = Reel.this.signals.getOrDefault(signal, new byte[0]);
            this.last = this.get(Reel.this.length - 1);
        }

        boolean get(int position) {
            int index = position / 8;
            return this.get(index < this.bytes.length ? this.bytes[index] : (byte)0, position % 8);
        }

        boolean get(byte chunk, int bit) {
            return (chunk >> 7 - bit & 1) == 1;
        }

        private String serialize() {
            StringBuilder sb = new StringBuilder(Reel.this.length);
            for (byte b : this.bytes) {
                sb.append(Reel.chunk(b));
            }
            while (sb.length() < Reel.this.length) {
                sb.append(' ');
            }
            return sb.substring(0, Reel.this.length);
        }
    }
}

