/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.bigbang.box.report;

import io.intino.cosmos.bigbang.box.report.HtmlIssueReportDocumentBuilder;
import io.intino.cosmos.bigbang.box.report.Issue;
import io.intino.cosmos.bigbang.box.report.TxtIssueReportDocumentBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class IssueReport {
    public static final String OTHER = "Other";
    private final Map<String, List<Issue>> issues = new HashMap<String, List<Issue>>();

    public boolean isEmpty() {
        return this.issues.isEmpty();
    }

    public IssueReport put(Stream<Issue> issues) {
        if (issues == null) {
            return this;
        }
        issues.forEach(this::put);
        return this;
    }

    public void put(Issue issue) {
        if (issue == null) {
            return;
        }
        String key = issue.sourceFile() == null ? OTHER : issue.sourceFile().getAbsolutePath();
        List issuesOfThatFile = this.issues.computeIfAbsent(key, k -> new ArrayList());
        issuesOfThatFile.add(issue);
    }

    public Map<String, List<Issue>> getAll() {
        return Collections.unmodifiableMap(this.issues);
    }

    public int errorCount() {
        return (int)this.filter(Issue.Level.Error).count();
    }

    public int warningCount() {
        return (int)this.filter(Issue.Level.Warning).count();
    }

    public List<Issue> errors() {
        return this.filter(Issue.Level.Error).collect(Collectors.toList());
    }

    public List<Issue> warnings() {
        return this.filter(Issue.Level.Warning).collect(Collectors.toList());
    }

    public int count() {
        return this.issues.values().stream().mapToInt(List::size).sum();
    }

    public Map<String, IssuesCount> issueTypes() {
        HashMap types = new HashMap();
        for (List<Issue> issueList : this.issues.values()) {
            issueList.forEach(i -> types.compute(i.type(), (k, v) -> {
                IssuesCount count;
                IssuesCount issuesCount = count = v == null ? new IssuesCount() : v;
                if (i.level() == Issue.Level.Error) {
                    ++count.errors;
                } else {
                    ++count.warnings;
                }
                return count;
            }));
        }
        return types.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, LinkedHashMap::new));
    }

    private Stream<Issue> filter(Issue.Level level) {
        return this.issues.values().stream().flatMap(Collection::stream).filter((? super T i) -> i.level().equals((Object)level));
    }

    public void saveHtml(File file) {
        new HtmlIssueReportDocumentBuilder(this).build(file);
    }

    public void saveTxt(File file) {
        new TxtIssueReportDocumentBuilder(this).build(file);
    }

    public static class IssuesCount
    implements Comparable<IssuesCount> {
        private int warnings;
        private int errors;

        private IssuesCount warnings(int warnings) {
            this.warnings = warnings;
            return this;
        }

        private IssuesCount errors(int errors) {
            this.errors = errors;
            return this;
        }

        public int warnings() {
            return this.warnings;
        }

        public int errors() {
            return this.errors;
        }

        public int total() {
            return this.warnings + this.errors;
        }

        @Override
        public int compareTo(IssuesCount o) {
            int cmp = Integer.compare(o.errors, this.errors);
            return cmp == 0 ? Integer.compare(o.warnings, this.warnings) : cmp;
        }
    }
}

