/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.bigbang.box.generators;

import io.intino.alexandria.jmx.JMXClient;
import io.intino.alexandria.logger.Logger;
import io.intino.cosmos.bigbang.box.BigBangException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;

public class ChangeBroadcaster {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String execute() {
        Collection<String> chains = JMXClient.allJMXLocalURLs().values();
        Iterator<String> iterator = chains.iterator();
        while (iterator.hasNext()) {
            String chain = iterator.next();
            try {
                JMXClient.JMXConnection connection = new JMXClient(chain).connect();
                try {
                    Coors coors = this.coors(connection);
                    if (coors == null || !"datahub".equals(coors.artifactId)) continue;
                    ObjectName objectName = connection.findObjectName("Konos");
                    if (objectName == null) {
                        throw new BigBangException("Operation not found");
                    }
                    MBeanOperationInfo op = connection.operationInfos(objectName).keySet().stream().filter(i -> i.getName().equals("recreateDatamart")).findFirst().orElse(null);
                    if (op == null) {
                        throw new BigBangException("Operation not found");
                    }
                    String string = connection.invokeOperation(objectName, op, new Object[]{"all"}).toString();
                    return string;
                }
                finally {
                    if (connection == null) continue;
                    connection.close();
                }
            }
            catch (Throwable e) {
                Logger.error(e.getMessage());
                return e.getMessage();
            }
        }
        return "Process not found";
    }

    private Coors coors(JMXClient.JMXConnection connection) {
        RuntimeMXBean runtime = connection.mBean(RuntimeMXBean.class, ManagementFactory.getRuntimeMXBean().getObjectName());
        List<String> classpath = Arrays.asList(runtime.getClassPath().split(File.pathSeparator));
        return ChangeBroadcaster.coors(classpath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Coors coors(List<String> classpath) {
        if (classpath.isEmpty()) {
            return null;
        }
        File mainArtifact = new File(classpath.get(0));
        try {
            if (mainArtifact.isDirectory()) {
                return new Coors("", mainArtifact.getName(), "1.0.0");
            }
            URL url = new URL("jar:file:" + mainArtifact.getAbsolutePath() + "!/META-INF/MANIFEST.MF");
            InputStream inputStream = url.openStream();
            Manifest manifest = new Manifest(inputStream);
            Attributes attributes = manifest.getMainAttributes();
            inputStream.close();
            if (attributes.getValue("Package") != null && attributes.getValue("Implementation-Title") != null && attributes.getValue("Implementation-Version") != null) {
                return new Coors(attributes.getValue("Package"), attributes.getValue("Implementation-Title"), attributes.getValue("Implementation-Version"));
            }
            try (JarFile jarFile = new JarFile(mainArtifact);){
                JarEntry jarEntry = jarFile.stream().filter(e -> e.getName().endsWith("/pom.properties")).findFirst().orElse(null);
                if (jarEntry == null) return new Coors("", attributes.getValue("Implementation-Title"), attributes.getValue("Implementation-Version"));
                PropertyResourceBundle bundle = new PropertyResourceBundle(jarFile.getInputStream(jarEntry));
                Coors coors = new Coors(bundle.getString("groupId"), bundle.getString("artifactId"), bundle.getString("version"));
                return coors;
            }
        }
        catch (IOException e2) {
            Logger.error(e2.getMessage());
            return new Coors("", mainArtifact.getName().replace(".jar", ""), "1.0.0");
        }
    }

    public record Coors(String groupId, String artifactId, String version) {
        public String name() {
            return this.groupId + ":" + this.artifactId;
        }
    }
}

